/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource.support;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractResource;
import com.hellosign.sdk.resource.support.types.FieldType;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomField
extends AbstractResource {
    public static final String CUSTOM_FIELD_NAME = "name";
    public static final String CUSTOM_FIELD_TYPE = "type";
    public static final String CUSTOM_FIELD_API_ID = "api_id";
    public static final String CUSTOM_FIELD_VALUE = "value";
    public static final String CUSTOM_FIELD_EDITOR = "editor";
    public static final String CUSTOM_FIELD_REQUIRED = "required";
    public static final String CUSTOM_FIELD_X = "x";
    public static final String CUSTOM_FIELD_Y = "y";
    public static final String CUSTOM_FIELD_WIDTH = "width";
    public static final String CUSTOM_FIELD_HEIGHT = "height";
    public static final String CUSTOM_FIELD_AVG_TEXT_LENGTH = "avg_text_length";
    public static final String CUSTOM_FIELD_NUM_LINES = "num_lines";
    public static final String CUSTOM_FIELD_NUM_CHARS_PER_LINE = "num_chars_per_line";

    public CustomField() {
    }

    public CustomField(JSONObject json) throws HelloSignException {
        super(json, null);
    }

    public String getName() {
        return this.getString(CUSTOM_FIELD_NAME);
    }

    public void setName(String name) {
        this.set(CUSTOM_FIELD_NAME, name);
    }

    public FieldType getType() {
        return FieldType.valueOf(this.getString(CUSTOM_FIELD_TYPE));
    }

    public String getTypeString() {
        if (this.has(CUSTOM_FIELD_TYPE)) {
            return this.getType().toString();
        }
        return null;
    }

    public void setType(FieldType type) {
        this.set(CUSTOM_FIELD_TYPE, type.toString());
    }

    public String getValue() {
        return this.getString(CUSTOM_FIELD_VALUE);
    }

    public void setValue(String value) {
        this.set(CUSTOM_FIELD_VALUE, value);
    }

    public String getApiId() {
        return this.getString(CUSTOM_FIELD_API_ID);
    }

    public void setApiId(String apiId) {
        this.set(CUSTOM_FIELD_API_ID, apiId);
    }

    public String getEditor() {
        return this.getString(CUSTOM_FIELD_EDITOR);
    }

    public void setEditor(String editor) {
        this.set(CUSTOM_FIELD_EDITOR, editor);
    }

    public Boolean isRequired() {
        return this.getBoolean(CUSTOM_FIELD_REQUIRED);
    }

    public void setIsRequired(Boolean isRequired) {
        this.set(CUSTOM_FIELD_REQUIRED, isRequired);
    }

    public Integer getX() {
        return this.getInteger(CUSTOM_FIELD_X);
    }

    public Integer getY() {
        return this.getInteger(CUSTOM_FIELD_Y);
    }

    public void setX(int x) {
        this.set(CUSTOM_FIELD_X, x);
    }

    public void setY(int y) {
        this.set(CUSTOM_FIELD_Y, y);
    }

    public Integer getWidth() {
        return this.getInteger(CUSTOM_FIELD_WIDTH);
    }

    public void setWidth(int width) {
        this.set(CUSTOM_FIELD_WIDTH, width);
    }

    public Integer getHeight() {
        return this.getInteger(CUSTOM_FIELD_HEIGHT);
    }

    public void setHeight(int height) {
        this.set(CUSTOM_FIELD_HEIGHT, height);
    }

    public Integer getEstimatedTextLines() {
        if (!this.dataObj.has(CUSTOM_FIELD_AVG_TEXT_LENGTH)) {
            return null;
        }
        Integer numLines = null;
        try {
            JSONObject obj = this.dataObj.getJSONObject(CUSTOM_FIELD_AVG_TEXT_LENGTH);
            numLines = obj.getInt(CUSTOM_FIELD_NUM_LINES);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return numLines;
    }

    public Integer getEstimatedCharsPerLine() {
        if (!this.dataObj.has(CUSTOM_FIELD_AVG_TEXT_LENGTH)) {
            return null;
        }
        Integer numLines = null;
        try {
            JSONObject obj = this.dataObj.getJSONObject(CUSTOM_FIELD_AVG_TEXT_LENGTH);
            numLines = obj.getInt(CUSTOM_FIELD_NUM_CHARS_PER_LINE);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return numLines;
    }
}

