/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractRequest;
import com.hellosign.sdk.resource.Template;
import com.hellosign.sdk.resource.support.CustomField;
import com.hellosign.sdk.resource.support.Signer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;

public class TemplateSignatureRequest
extends AbstractRequest {
    private static final String TEMPLATE_IDS = "template_ids";
    private static final String TEMPLATE_SIGNERS = "signers";
    private static final String TEMPLATE_SIGNERS_EMAIL = "email_address";
    private static final String TEMPLATE_SIGNERS_NAME = "name";
    private static final String TEMPLATE_CCS = "ccs";
    private static final String TEMPLATE_CCS_EMAIL = "email_address";
    private static final String TEMPLATE_CUSTOM_FIELDS = "custom_fields";
    private Map<String, Signer> signers = new HashMap<String, Signer>();
    private Map<String, String> ccs = new HashMap<String, String>();
    private List<CustomField> customFields = new ArrayList<CustomField>();

    public TemplateSignatureRequest() {
    }

    public TemplateSignatureRequest(Template template) throws HelloSignException {
        this();
        this.setTemplateId(template.getId());
    }

    public TemplateSignatureRequest(List<Template> templates) throws HelloSignException {
        this();
        for (Template template : templates) {
            this.addTemplateId(template.getId());
        }
    }

    public Map<String, String> getCCs() {
        return this.ccs;
    }

    public void setCCs(Map<String, String> newCCs) {
        this.ccs = newCCs;
    }

    public void setCC(String role, String email) {
        this.ccs.put(role, email);
    }

    public void clearCCs() {
        this.ccs = new HashMap<String, String>();
    }

    public void setSigner(String role, String email, String name) throws HelloSignException {
        this.signers.put(role, new Signer(email, name));
    }

    public Map<String, Signer> getSigners() {
        return this.signers;
    }

    public void setSigners(Map<String, Signer> signers) {
        this.signers = signers;
    }

    public void removeSignerByEmail(String email) throws HelloSignException {
        if (email == null) {
            return;
        }
        for (int i = 0; i < this.signers.size(); ++i) {
            if (!email.equalsIgnoreCase(this.signers.get(i).getEmail())) continue;
            this.signers.remove(i);
        }
    }

    public void addCustomField(CustomField field) {
        this.customFields.add(field);
    }

    public void setCustomFieldValue(String fieldNameOrApiId, String value) {
        CustomField f = new CustomField();
        f.setName(fieldNameOrApiId);
        f.setValue(value);
        this.customFields.add(f);
    }

    public Map<String, String> getCustomFields() {
        HashMap<String, String> fields = new HashMap<String, String>();
        for (CustomField f : this.customFields) {
            fields.put(f.getName(), f.getValue());
        }
        return fields;
    }

    public List<CustomField> getCustomFieldsList() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> fields) {
        this.clearCustomFields();
        for (String key : fields.keySet()) {
            CustomField f = new CustomField();
            f.setName(key);
            f.setValue(fields.get(key));
            this.customFields.add(f);
        }
    }

    public void clearCustomFields() {
        this.customFields = new ArrayList<CustomField>();
    }

    public void setTemplateId(String id) throws HelloSignException {
        this.clearList(TEMPLATE_IDS);
        this.addTemplateId(id, null);
    }

    public String getTemplateId() throws HelloSignException {
        List<String> templateIds = this.getTemplateIds();
        if (templateIds.size() == 0) {
            return null;
        }
        return templateIds.get(0);
    }

    public void addTemplateId(String id) throws HelloSignException {
        this.addTemplateId(id, null);
    }

    public void addTemplateId(String id, Integer index) throws HelloSignException {
        List<String> currentList = this.getList(String.class, TEMPLATE_IDS);
        if (index == null) {
            index = currentList.size();
        } else {
            if (index < 0) {
                throw new HelloSignException("index cannot be negative");
            }
            if (index > currentList.size()) {
                throw new HelloSignException("index is greater than template ID list size: " + currentList.size());
            }
        }
        if (index.intValue() == currentList.size()) {
            this.add(TEMPLATE_IDS, id);
        } else {
            this.clearList(TEMPLATE_IDS);
            int limit = currentList.size();
            for (int i = 0; i < limit + 1; ++i) {
                if (i == index) {
                    this.add(TEMPLATE_IDS, id);
                }
                if (i >= limit) continue;
                this.add(TEMPLATE_IDS, currentList.get(i));
            }
        }
    }

    public List<String> getTemplateIds() {
        return this.getList(String.class, TEMPLATE_IDS);
    }

    @Override
    public Map<String, Serializable> getPostFields() throws HelloSignException {
        Map<String, Serializable> fields = super.getPostFields();
        try {
            List<String> templateIds = this.getTemplateIds();
            for (int i = 0; i < templateIds.size(); ++i) {
                fields.put("template_ids[" + i + "]", (Serializable)((Object)templateIds.get(i)));
            }
            Map<String, Signer> signerz = this.getSigners();
            for (String string : signerz.keySet()) {
                Signer s = signerz.get(string);
                fields.put("signers[" + string + "][" + "email_address" + "]", (Serializable)((Object)s.getEmail()));
                fields.put("signers[" + string + "][" + TEMPLATE_SIGNERS_NAME + "]", (Serializable)((Object)s.getNameOrRole()));
            }
            if (this.hasTitle()) {
                fields.put("title", (Serializable)((Object)this.getTitle()));
            }
            if (this.hasSubject()) {
                fields.put("subject", (Serializable)((Object)this.getSubject()));
            }
            if (this.hasMessage()) {
                fields.put("message", (Serializable)((Object)this.getMessage()));
            }
            Map<String, String> ccz = this.getCCs();
            for (String role : ccz.keySet()) {
                fields.put("ccs[" + role + "][" + "email_address" + "]", (Serializable)((Object)ccz.get(role)));
            }
            if (this.customFields.size() > 0) {
                JSONArray jSONArray = new JSONArray();
                for (CustomField f : this.customFields) {
                    jSONArray.put((Object)f.getJSONObject());
                }
                fields.put(TEMPLATE_CUSTOM_FIELDS, (Serializable)((Object)jSONArray.toString()));
            }
            if (this.isTestMode()) {
                fields.put("test_mode", Boolean.valueOf(true));
            }
        }
        catch (Exception ex) {
            throw new HelloSignException("Could not extract form fields from TemplateSignatureRequest.", ex);
        }
        return fields;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public boolean hasUseTextTags() {
        return false;
    }

    @Override
    public Boolean isUsingTextTags() {
        return null;
    }

    @Override
    public void setUseTextTags(boolean useTextTags) {
    }

    @Override
    public boolean hasHideTextTags() {
        return false;
    }

    @Override
    public Boolean isHidingTextTags() {
        return null;
    }

    @Override
    public void setHideTextTags(boolean hideTextTags) {
    }
}

