/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractRequest;
import com.hellosign.sdk.resource.support.Document;
import com.hellosign.sdk.resource.support.FormField;
import com.hellosign.sdk.resource.support.ResponseData;
import com.hellosign.sdk.resource.support.Signature;
import com.hellosign.sdk.resource.support.Signer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class SignatureRequest
extends AbstractRequest {
    public static final String SIGREQ_KEY = "signature_request";
    public static final String SIGREQ_ID = "signature_request_id";
    public static final String SIGREQ_SIGNERS = "signers";
    public static final String SIGREQ_SIGNER_EMAIL = "email_address";
    public static final String SIGREQ_SIGNER_NAME = "name";
    public static final String SIGREQ_SIGNER_ORDER = "order";
    public static final String SIGREQ_SIGNER_PIN = "pin";
    public static final String SIGREQ_CCS = "cc_email_addresses";
    public static final String SIGREQ_FILES = "file";
    public static final String SIGREQ_FORM_FIELDS = "form_fields_per_document";
    public static final String SIGREQ_IS_COMPLETE = "is_complete";
    public static final String SIGREQ_HAS_ERROR = "has_error";
    public static final String SIGREQ_RESPONSE_DATA = "response_data";
    public static final String SIGREQ_FINAL_COPY_URL = "final_copy_url";
    public static final String SIGREQ_FILES_URL = "files_url";
    public static final String SIGREQ_SIGNING_URL = "signing_url";
    public static final String SIGREQ_DETAILS_URL = "details_url";
    public static final String SIGREQ_IS_DECLINED = "is_declined";
    public static final String SIGREQ_FORMAT_ZIP = "zip";
    public static final String SIGREQ_FORMAT_PDF = "pdf";
    private List<Signer> signers = new ArrayList<Signer>();

    public SignatureRequest() {
    }

    public SignatureRequest(JSONObject json) throws HelloSignException {
        super(json, SIGREQ_KEY);
    }

    public SignatureRequest(JSONObject json, String key) throws HelloSignException {
        super(json, key);
    }

    @Override
    public String getId() {
        return this.getString(SIGREQ_ID);
    }

    public boolean hasId() {
        return this.has(SIGREQ_ID);
    }

    public List<String> getCCs() {
        return this.getList(String.class, SIGREQ_CCS);
    }

    public void addCC(String email) {
        this.add(SIGREQ_CCS, email);
    }

    public List<Signature> getSignatures() {
        return this.getList(Signature.class, "signatures");
    }

    public Signature getSignature(String email, String name) throws HelloSignException {
        if (email == null || "".equals(email)) {
            throw new HelloSignException("Email address cannot be empty");
        }
        if (name == null || "".equals(name)) {
            throw new HelloSignException("Name cannot be empty");
        }
        for (Signature s : this.getSignatures()) {
            if (!email.equalsIgnoreCase(s.getEmail()) || !name.equalsIgnoreCase(s.getName())) continue;
            return s;
        }
        return null;
    }

    public void addSigner(Signer signer) throws HelloSignException {
        this.signers.add(signer);
    }

    public void addSigner(String email, String name) throws HelloSignException {
        this.signers.add(new Signer(email, name));
    }

    public void addSigner(String email, String name, int order) throws HelloSignException {
        try {
            this.signers.add(order - 1, new Signer(email, name));
        }
        catch (Exception ex) {
            throw new HelloSignException(ex);
        }
    }

    public List<Signer> getSigners() {
        return this.signers;
    }

    public void setSigners(List<Signer> signers) {
        this.signers = signers;
    }

    public void removeSigner(String email) throws HelloSignException {
        if (email == null) {
            throw new HelloSignException("Cannot remove null signer");
        }
        for (int i = 0; i < this.signers.size(); ++i) {
            if (!email.equalsIgnoreCase(this.signers.get(i).getEmail())) continue;
            this.signers.remove(i);
        }
    }

    public Signature getSignatureBySigner(String email, String name) {
        if (email == null || name == null) {
            return null;
        }
        for (Signature s : this.getSignatures()) {
            if (!name.equalsIgnoreCase(s.getName()) || !email.equalsIgnoreCase(s.getEmail())) continue;
            return s;
        }
        return null;
    }

    @Override
    public Map<String, Serializable> getPostFields() throws HelloSignException {
        Map<String, Serializable> fields = super.getPostFields();
        try {
            if (this.hasTitle()) {
                fields.put("title", (Serializable)((Object)this.getTitle()));
            }
            if (this.hasSubject()) {
                fields.put("subject", (Serializable)((Object)this.getSubject()));
            }
            if (this.hasMessage()) {
                fields.put("message", (Serializable)((Object)this.getMessage()));
            }
            List<Signer> signerz = this.getSigners();
            for (int i = 0; i < signerz.size(); ++i) {
                Signer s = signerz.get(i);
                fields.put("signers[" + (i + 1) + "][" + SIGREQ_SIGNER_EMAIL + "]", (Serializable)((Object)s.getEmail()));
                fields.put("signers[" + (i + 1) + "][" + SIGREQ_SIGNER_NAME + "]", (Serializable)((Object)s.getNameOrRole()));
                if (this.getOrderMatters()) {
                    fields.put("signers[" + (i + 1) + "][" + SIGREQ_SIGNER_ORDER + "]", Integer.valueOf(i));
                }
                if (s.getAccessCode() == null) continue;
                fields.put("signers[" + (i + 1) + "][" + SIGREQ_SIGNER_PIN + "]", (Serializable)((Object)s.getAccessCode()));
            }
            List<String> ccz = this.getCCs();
            for (int i = 0; i < ccz.size(); ++i) {
                String cc = ccz.get(i);
                fields.put("cc_email_addresses[" + (i + 1) + "]", (Serializable)((Object)cc));
            }
            JSONArray reqFormFields = new JSONArray();
            boolean hasFormFields = false;
            List<Document> docs = this.getDocuments();
            for (int i = 0; i < docs.size(); ++i) {
                Document d = docs.get(i);
                fields.put("file[" + (i + 1) + "]", d.getFile());
                JSONArray docFormFields = new JSONArray();
                for (FormField ff : d.getFormFields()) {
                    hasFormFields = true;
                    docFormFields.put((Object)ff.getJSONObject());
                }
                reqFormFields.put((Object)docFormFields);
            }
            List<String> fileUrls = this.getFileUrls();
            for (int i = 0; i < fileUrls.size(); ++i) {
                fields.put("file_url[" + (i + 1) + "]", (Serializable)((Object)fileUrls.get(i)));
            }
            if (hasFormFields) {
                fields.put(SIGREQ_FORM_FIELDS, (Serializable)((Object)reqFormFields.toString()));
            }
            if (this.isTestMode()) {
                fields.put("test_mode", Boolean.valueOf(true));
            }
            if (this.hasRedirectUrl()) {
                fields.put("signing_redirect_url", (Serializable)((Object)this.getRedirectUrl()));
            }
            if (this.hasUseTextTags()) {
                fields.put("use_text_tags", this.isUsingTextTags());
            }
            if (this.hasHideTextTags()) {
                fields.put("hide_text_tags", this.isHidingTextTags());
            }
        }
        catch (Exception ex) {
            throw new HelloSignException("Could not extract form fields from SignatureRequest.", ex);
        }
        return fields;
    }

    public boolean isComplete() {
        return this.getBoolean(SIGREQ_IS_COMPLETE);
    }

    public boolean hasError() {
        return this.getBoolean(SIGREQ_HAS_ERROR);
    }

    public List<ResponseData> getResponseData() {
        return this.getList(ResponseData.class, SIGREQ_RESPONSE_DATA);
    }

    public String getFinalCopyUrl() {
        return this.getString(SIGREQ_FINAL_COPY_URL);
    }

    public String getFilesUrl() {
        return this.getString(SIGREQ_FILES_URL);
    }

    public String getSigningUrl() {
        return this.getString(SIGREQ_SIGNING_URL);
    }

    public String getDetailsUrl() {
        return this.getString(SIGREQ_DETAILS_URL);
    }

    public boolean isDeclined() {
        if (this.has(SIGREQ_IS_DECLINED)) {
            return this.getBoolean(SIGREQ_IS_DECLINED);
        }
        return false;
    }
}

