/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractResource;
import com.hellosign.sdk.resource.SignatureRequest;
import com.hellosign.sdk.resource.Template;
import com.hellosign.sdk.resource.support.Signature;
import com.hellosign.sdk.resource.support.types.EventType;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONException;
import org.json.JSONObject;

public class Event
extends AbstractResource {
    public static final String EVENT_KEY = "event";
    public static final String EVENT_METADATA = "event_metadata";
    public static final String REPORTED_FOR_ACCOUNT_ID = "reported_for_account_id";
    public static final String REPORTED_FOR_APP_ID = "reported_for_app_id";
    public static final String RELATED_SIGNATURE_ID = "related_signature_id";
    public static final String EVENT_TYPE = "event_type";
    public static final String EVENT_TIME = "event_time";
    public static final String EVENT_HASH = "event_hash";
    public static final String EVENT_MESSAGE = "event_message";
    public static final String HASH_ALGORITHM = "HmacSHA256";
    private AbstractResource resource;
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public Event(JSONObject json) throws HelloSignException {
        super(json, EVENT_KEY);
        if (EventType.test.equals((Object)this.getType())) {
            return;
        }
        if (json.has("signature_request")) {
            try {
                this.resource = new SignatureRequest(json.getJSONObject("signature_request"));
            }
            catch (JSONException ex) {
                throw new HelloSignException((Exception)((Object)ex));
            }
        }
        if (json.has("template")) {
            try {
                this.resource = new Template(json.getJSONObject("template"));
            }
            catch (JSONException ex) {
                throw new HelloSignException((Exception)((Object)ex));
            }
        }
    }

    public String getAccountId() throws HelloSignException {
        JSONObject metadata = (JSONObject)this.get(EVENT_METADATA);
        String id = null;
        try {
            id = metadata.getString(REPORTED_FOR_ACCOUNT_ID);
        }
        catch (JSONException ex) {
            throw new HelloSignException((Exception)((Object)ex));
        }
        return id;
    }

    public boolean hasAccountId() throws HelloSignException {
        return this.has(REPORTED_FOR_ACCOUNT_ID);
    }

    public String getAppId() throws HelloSignException {
        JSONObject metadata = (JSONObject)this.get(EVENT_METADATA);
        String id = null;
        try {
            id = metadata.getString(REPORTED_FOR_APP_ID);
        }
        catch (JSONException ex) {
            throw new HelloSignException((Exception)((Object)ex));
        }
        return id;
    }

    public boolean hasAppId() throws HelloSignException {
        return this.has(REPORTED_FOR_APP_ID);
    }

    public Date getEventDate() {
        return this.getDate(EVENT_TIME);
    }

    public String getEventMessage() throws HelloSignException {
        JSONObject metadata = (JSONObject)this.get(EVENT_METADATA);
        String eventMessage = null;
        try {
            eventMessage = metadata.getString(EVENT_MESSAGE);
        }
        catch (JSONException ex) {
            throw new HelloSignException((Exception)((Object)ex));
        }
        return eventMessage;
    }

    public String getRelatedSignatureId() throws HelloSignException {
        JSONObject metadata = (JSONObject)this.get(EVENT_METADATA);
        if (metadata == null) {
            return null;
        }
        String id = null;
        try {
            id = metadata.getString(RELATED_SIGNATURE_ID);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return id;
    }

    public boolean hasRelatedSignatureId() {
        JSONObject metadata = (JSONObject)this.get(EVENT_METADATA);
        if (metadata == null) {
            return false;
        }
        return metadata.has(RELATED_SIGNATURE_ID) && !metadata.isNull(RELATED_SIGNATURE_ID);
    }

    public Signature getRelatedSignature() throws HelloSignException {
        String id = this.getRelatedSignatureId();
        if (id == null) {
            return null;
        }
        for (Signature sig : ((SignatureRequest)this.resource).getSignatures()) {
            if (!id.equals(sig.getId())) continue;
            return sig;
        }
        return null;
    }

    public SignatureRequest getSignatureRequest() {
        if (this.hasSignatureRequest()) {
            return (SignatureRequest)this.resource;
        }
        return null;
    }

    public boolean hasSignatureRequest() {
        return this.resource != null && this.resource instanceof SignatureRequest;
    }

    public Template getTemplate() {
        if (this.hasTemplate()) {
            return (Template)this.resource;
        }
        return null;
    }

    public boolean hasTemplate() {
        return this.resource != null && this.resource instanceof Template;
    }

    public EventType getType() {
        return EventType.valueOf(this.getTypeString());
    }

    public String getTypeString() {
        return this.getString(EVENT_TYPE);
    }

    public String getHash() {
        return this.getString(EVENT_HASH);
    }

    public boolean isValid(String apiKey) throws HelloSignException {
        if (apiKey == null || apiKey == "") {
            return false;
        }
        try {
            Mac sha256HMAC = Mac.getInstance(HASH_ALGORITHM);
            SecretKeySpec secretKey = new SecretKeySpec(apiKey.getBytes(), HASH_ALGORITHM);
            sha256HMAC.init(secretKey);
            String data = String.valueOf(this.getLong(EVENT_TIME)) + (Object)((Object)this.getType());
            String computedHash = Event.bytesToHex(sha256HMAC.doFinal(data.getBytes()));
            String providedHash = this.getString(EVENT_HASH);
            return computedHash.equalsIgnoreCase(providedHash);
        }
        catch (InvalidKeyException e) {
            throw new HelloSignException("Invalid API Key (" + e.getMessage() + "): " + apiKey);
        }
        catch (IllegalArgumentException e) {
            throw new HelloSignException("Invalid API Key (" + e.getMessage() + "): " + apiKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HelloSignException("Unable to process API key", e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    @Override
    public String toString() {
        String retStr = super.toString();
        if (this.resource != null) {
            String className = this.resource.getClass().getName();
            retStr = retStr + "\nAssociated " + className + ":\n";
            retStr = retStr + this.resource.toString();
        }
        return retStr;
    }
}

