/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractResource;
import com.hellosign.sdk.resource.support.OauthData;
import com.hellosign.sdk.resource.support.Quotas;
import com.hellosign.sdk.resource.support.types.RoleType;
import org.json.JSONObject;

public class Account
extends AbstractResource {
    public static final String ACCOUNT_KEY = "account";
    public static final String ACCOUNT_ID = "account_id";
    public static final String ACCOUNT_EMAIL_ADDRESS = "email_address";
    public static final String ACCOUNT_IS_PAID_HS = "is_paid_hs";
    public static final String ACCOUNT_IS_PAID_HF = "is_paid_hf";
    public static final String ACCOUNT_CALLBACK_URL = "callback_url";
    public static final String ACCOUNT_ROLE_CODE = "role_code";
    public static final String OAUTH_DATA = "oauth_data";
    public static final String ACCOUNT_PASSWORD = "password";
    private Quotas quotas;

    public Account() {
    }

    public Account(JSONObject json) throws HelloSignException {
        this(json, ACCOUNT_KEY);
    }

    public Account(JSONObject json, String custom_key) throws HelloSignException {
        super(json, custom_key);
        this.quotas = new Quotas(this.dataObj);
    }

    public String getId() {
        return this.getString(ACCOUNT_ID);
    }

    public boolean hasId() {
        return this.has(ACCOUNT_ID);
    }

    public String getEmail() {
        return this.getString(ACCOUNT_EMAIL_ADDRESS);
    }

    public boolean hasEmail() {
        return this.has(ACCOUNT_EMAIL_ADDRESS);
    }

    public boolean isPaidHS() {
        return this.getBoolean(ACCOUNT_IS_PAID_HS);
    }

    public boolean isPaidHF() {
        return this.getBoolean(ACCOUNT_IS_PAID_HF);
    }

    public Integer getTemplatesLeft() {
        return this.quotas.getTemplatesLeft();
    }

    public Integer getApiSignatureRequestsLeft() {
        return this.quotas.getApiSignatureRequestsLeft();
    }

    public Integer getDocumentsLeft() {
        return this.quotas.getDocumentsLeft();
    }

    public String getCallbackUrl() {
        return this.getString(ACCOUNT_CALLBACK_URL);
    }

    public boolean hasCallbackUrl() {
        return this.has(ACCOUNT_CALLBACK_URL);
    }

    public RoleType getRoleCode() throws HelloSignException {
        String code = this.getString(ACCOUNT_ROLE_CODE);
        for (RoleType type : RoleType.values()) {
            if (!type.toString().equalsIgnoreCase(code)) continue;
            return type;
        }
        throw new HelloSignException("Unknown role code: " + code);
    }

    public boolean hasRoleCode() {
        return this.has(ACCOUNT_ROLE_CODE);
    }

    public OauthData getOauthData() throws HelloSignException {
        return new OauthData((JSONObject)this.get(OAUTH_DATA));
    }

    public Quotas getQuotas() {
        return this.quotas;
    }
}

