/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractResource;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractResourceList<E>
extends AbstractResource
implements Iterable<E> {
    public static final String LIST_INFO = "list_info";
    public static final String PAGE = "page";
    public static final String NUM_PAGES = "num_pages";
    public static final String NUM_RESULTS = "num_results";
    public static final String PAGE_SIZE = "page_size";
    private JSONObject listInfo;
    private String listKey;

    protected AbstractResourceList(JSONObject json, String listKey) throws HelloSignException {
        super(json, null);
        this.listKey = listKey;
        try {
            this.listInfo = this.dataObj.getJSONObject(LIST_INFO);
        }
        catch (JSONException e) {
            throw new HelloSignException((Exception)((Object)e));
        }
    }

    public Integer getPage() {
        try {
            return this.listInfo.getInt(PAGE);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Integer getNumPages() {
        try {
            return this.listInfo.getInt(NUM_PAGES);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Integer getNumResults() {
        try {
            return this.listInfo.getInt(NUM_RESULTS);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Integer getPageSize() {
        try {
            return this.listInfo.getInt(PAGE_SIZE);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Iterator<E> iterator() {
        List<E> list = null;
        try {
            list = this.getCurrentPageList();
        }
        catch (HelloSignException e) {
            e.printStackTrace();
        }
        return list.iterator();
    }

    public List<E> getCurrentPageList() throws HelloSignException {
        return this.filterCurrentPageBy(null, null);
    }

    public List<E> filterCurrentPageBy(String columnName, Serializable filterValue) throws HelloSignException {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class clazz = (Class)genericSuperclass.getActualTypeArguments()[0];
        return this.getList(clazz, this.listKey, filterValue, columnName);
    }
}

