/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.http;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.http.AbstractHttpRequest;
import com.hellosign.sdk.http.Authentication;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpGetRequest
extends AbstractHttpRequest {
    private static final Logger logger = LoggerFactory.getLogger(HttpGetRequest.class);
    private Map<String, String> parameters = null;

    public HttpGetRequest(String url) throws HelloSignException {
        this(url, null, null);
    }

    public HttpGetRequest(String url, Authentication auth) throws HelloSignException {
        this(url, null, auth);
    }

    public HttpGetRequest(String url, Map<String, String> parameters) throws HelloSignException {
        this(url, parameters, null);
    }

    public HttpGetRequest(String url, Map<String, String> parameters, Authentication auth) throws HelloSignException {
        if (url == null || "".equals(url)) {
            throw new HelloSignException("URL cannot be null or empty");
        }
        this.url = url;
        if (parameters != null) {
            this.parameters = parameters;
        }
        if (auth != null) {
            this.auth = new Authentication(auth);
        }
    }

    public JSONObject getJsonResponse() throws HelloSignException {
        JSONObject json = null;
        try {
            HttpURLConnection connection = HttpGetRequest.get(this.url, this.parameters, this.auth);
            int httpCode = connection.getResponseCode();
            InputStream is = null;
            is = 200 == httpCode ? connection.getInputStream() : connection.getErrorStream();
            String response = HttpGetRequest.convertStreamToString(is);
            json = new JSONObject(response);
            HttpGetRequest.validate(json, httpCode);
        }
        catch (HelloSignException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HelloSignException(e);
        }
        return json;
    }

    public File getFileResponse(String filename) throws HelloSignException {
        File f = HttpGetRequest.createTemporaryFile(filename);
        return HttpGetRequest.getFile(this.url, this.auth, f);
    }

    private static File createTemporaryFile(String filename) throws HelloSignException {
        String prefix = filename.substring(0, filename.indexOf("."));
        String postfix = filename.substring(filename.indexOf(".") + 1, filename.length());
        if (prefix == null || postfix == null) {
            throw new HelloSignException("Invalid file name: " + prefix + "." + postfix);
        }
        File f = null;
        try {
            f = File.createTempFile(prefix, "." + postfix);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new HelloSignException(ex.getMessage());
        }
        return f;
    }

    private static HttpURLConnection get(String url, Map<String, String> parameters, Authentication auth) throws UnsupportedEncodingException, IOException, MalformedURLException {
        if (parameters != null) {
            url = url + "?";
            Iterator<String> keys = parameters.keySet().iterator();
            while (keys.hasNext()) {
                String key = keys.next();
                url = url + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(parameters.get(key), "UTF-8");
                if (!keys.hasNext()) continue;
                url = url + "&";
            }
        }
        logger.debug("GET: " + url);
        HttpURLConnection connection = HttpGetRequest.getConnection(url);
        connection.setRequestProperty("Accept-Charset", "UTF-8");
        connection.setRequestProperty("user-agent", USER_AGENT);
        if (auth != null) {
            logger.debug("Authenticating...");
            auth.authenticate(connection, url);
        }
        return connection;
    }

    private static File getFile(String url, Authentication auth, File f) throws HelloSignException {
        InputStream in = null;
        OutputStream out = null;
        try {
            HttpURLConnection connection = HttpGetRequest.get(url, null, auth);
            int httpCode = connection.getResponseCode();
            if (httpCode == 200) {
                Files.copy(connection.getInputStream(), f.toPath(), StandardCopyOption.REPLACE_EXISTING);
                File file = f;
                return file;
            }
            try {
                in = connection.getErrorStream();
                String responseStr = HttpGetRequest.convertStreamToString(in);
                try {
                    JSONObject json = new JSONObject(responseStr);
                    HttpGetRequest.validate(json, httpCode);
                }
                catch (JSONException e) {
                    throw new HelloSignException("Error encountered attempting to parse API error response: " + e.getMessage());
                }
                throw new HelloSignException("Unable to process response from HelloSign. Please contact support.");
            }
            catch (HelloSignException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new HelloSignException(e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

