/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.http;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.http.AbstractHttpRequest;
import com.hellosign.sdk.http.Authentication;
import java.net.HttpURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDeleteRequest
extends AbstractHttpRequest {
    private static final Logger logger = LoggerFactory.getLogger(HttpDeleteRequest.class);

    public HttpDeleteRequest(String url) throws HelloSignException {
        this(url, null);
    }

    public HttpDeleteRequest(String url, Authentication auth) throws HelloSignException {
        if (url == null || "".equals(url)) {
            throw new HelloSignException("URL cannot be null or empty");
        }
        this.url = url;
        if (auth != null) {
            this.auth = new Authentication(auth);
        }
    }

    public int getHttpResponseCode() throws HelloSignException {
        try {
            logger.debug("DELETE: " + this.url);
            HttpURLConnection connection = HttpDeleteRequest.getConnection(this.url);
            connection.setRequestProperty("Accept-Charset", "UTF-8");
            connection.setRequestProperty("user-agent", USER_AGENT);
            if (this.auth != null) {
                logger.debug("Authenticating...");
                this.auth.authenticate(connection, this.url);
            }
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestMethod("DELETE");
            connection.connect();
            return connection.getResponseCode();
        }
        catch (Exception e) {
            throw new HelloSignException(e);
        }
    }
}

