/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.http;

import com.hellosign.sdk.HelloSignException;
import java.net.HttpURLConnection;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authentication {
    private static final Logger logger = LoggerFactory.getLogger(Authentication.class);
    private String email = new String();
    private String password = new String();
    private String apiKey = new String();
    private String accessToken = new String();
    private String accessTokenType = new String();
    private static final String[] allowedOauthOps = new String[]{"account", "signature_request", "reusable_form", "template"};

    public Authentication() {
    }

    public Authentication(Authentication clone) throws HelloSignException {
        if (clone.hasWebsiteCredentials()) {
            this.setWebsiteCredentials(clone.getEmail(), clone.getPassword());
        }
        if (clone.hasApiKey()) {
            this.setApiKey(clone.getApiKey());
        }
        if (clone.hasAccessToken()) {
            this.setAccessToken(clone.getAccessToken(), clone.getAccessTokenType());
        }
    }

    public void setWebsiteCredentials(String email, String password) throws HelloSignException {
        if (email == null) {
            throw new HelloSignException("Email cannot be null");
        }
        if (password == null) {
            throw new HelloSignException("Password cannot be null");
        }
        this.email = new String(email);
        this.password = new String(password);
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean hasWebsiteCredentials() {
        return !"".equals(this.email) && !"".equals(this.password);
    }

    public String getApiKey() {
        return new String(this.apiKey);
    }

    public void setApiKey(String apiKey) {
        if (apiKey == null) {
            return;
        }
        this.apiKey = new String(apiKey);
    }

    public boolean hasApiKey() {
        return !"".equals(this.apiKey);
    }

    public String getAccessToken() {
        return new String(this.accessToken);
    }

    public String getAccessTokenType() {
        return new String(this.accessTokenType);
    }

    public void setAccessToken(String accessToken, String tokenType) throws HelloSignException {
        if (accessToken == null) {
            throw new HelloSignException("Access Token cannot be null");
        }
        if (tokenType == null) {
            throw new HelloSignException("Token Type cannot be null");
        }
        this.accessToken = new String(accessToken);
        this.accessTokenType = new String(tokenType);
    }

    public boolean hasAccessToken() {
        return !"".equals(this.accessToken) && !"".equals(this.accessTokenType);
    }

    private boolean isOperationOauth(String url) {
        for (String op : allowedOauthOps) {
            if (!url.contains(op)) continue;
            return true;
        }
        return false;
    }

    public void authenticate(HttpURLConnection httpConn, String url) {
        String authorization = null;
        if (this.hasAccessToken() && this.isOperationOauth(url)) {
            authorization = this.getAccessTokenType() + " " + this.getAccessToken();
        } else if (this.hasApiKey()) {
            String apiKey = this.getApiKey() + ":";
            authorization = "Basic " + DatatypeConverter.printBase64Binary((byte[])apiKey.getBytes()).trim();
        } else if (this.hasWebsiteCredentials()) {
            String authStr = this.getEmail() + ":" + this.getPassword();
            authorization = "Basic " + DatatypeConverter.printBase64Binary((byte[])authStr.getBytes()).trim();
        }
        if (authorization != null) {
            logger.debug("Authorization: " + authorization);
            httpConn.setRequestProperty("authorization", authorization);
        }
    }
}

