/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.http;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.http.Authentication;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Properties;
import java.util.Scanner;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractHttpRequest {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String USER_AGENT = AbstractHttpRequest.createUserAgent();
    protected String url;
    protected Authentication auth;

    private static String createUserAgent() {
        String filename = "config.properties";
        Properties props = new Properties();
        InputStream is = AbstractHttpRequest.class.getClassLoader().getResourceAsStream(filename);
        if (is != null) {
            try {
                props.load(is);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        } else {
            throw new Error(new FileNotFoundException("Could not find " + filename));
        }
        String version = props.getProperty("sdk.version");
        if (version == null) {
            version = "x.x.x";
        }
        return "hellosign-java-sdk/" + version;
    }

    public static String convertStreamToString(InputStream in) {
        Scanner s = new Scanner(in);
        s.useDelimiter("\\A");
        String result = s.hasNext() ? s.next() : "";
        s.close();
        return result;
    }

    protected static void validate(JSONObject json, int code) throws HelloSignException {
        if (json.has("error")) {
            try {
                JSONObject error = json.getJSONObject("error");
                String message = error.getString("error_msg");
                String type = error.getString("error_name");
                throw new HelloSignException(message, code, type);
            }
            catch (JSONException ex) {
                throw new HelloSignException((Exception)((Object)ex));
            }
        }
    }

    public static HttpURLConnection getConnection(String url) throws MalformedURLException, IOException {
        HttpURLConnection conn = null;
        Proxy proxy = null;
        String proxyUrlStr = System.getProperty("hellosign.proxy.url");
        String proxyPortStr = System.getProperty("hellosign.proxy.port");
        Integer proxyPort = 80;
        if (proxyPortStr != null) {
            proxyPort = Integer.parseInt(proxyPortStr);
        }
        if (proxyUrlStr != null) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUrlStr, (int)proxyPort));
        }
        conn = proxy == null ? (HttpURLConnection)new URL(url).openConnection() : (HttpURLConnection)new URL(url).openConnection(proxy);
        return conn;
    }
}

