/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.http.AbstractHttpRequest;
import com.hellosign.sdk.http.Authentication;
import com.hellosign.sdk.http.HttpDeleteRequest;
import com.hellosign.sdk.http.HttpGetRequest;
import com.hellosign.sdk.http.HttpPostRequest;
import com.hellosign.sdk.http.HttpPutRequest;
import com.hellosign.sdk.resource.AbstractRequest;
import com.hellosign.sdk.resource.Account;
import com.hellosign.sdk.resource.ApiApp;
import com.hellosign.sdk.resource.EmbeddedRequest;
import com.hellosign.sdk.resource.EmbeddedResponse;
import com.hellosign.sdk.resource.SignatureRequest;
import com.hellosign.sdk.resource.Team;
import com.hellosign.sdk.resource.Template;
import com.hellosign.sdk.resource.TemplateDraft;
import com.hellosign.sdk.resource.TemplateSignatureRequest;
import com.hellosign.sdk.resource.UnclaimedDraft;
import com.hellosign.sdk.resource.support.ApiAppList;
import com.hellosign.sdk.resource.support.OauthData;
import com.hellosign.sdk.resource.support.SignatureRequestList;
import com.hellosign.sdk.resource.support.TemplateList;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONException;
import org.json.JSONObject;

public class HelloSignClient {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final String API_VERSION = "v3";
    private String URL_HELLOSIGN = "https://api.hellosign.com";
    private static final String URL_API_BASE = "https://api.hellosign.com";
    private String URL_OAUTH_TOKEN;
    private static final String URL_OAUTH_TOKEN_PRODUCTION = "https://www.hellosign.com/oauth/token";
    private String URL_API;
    private String URL_ACCOUNT;
    private String URL_VALIDATE_ACCOUNT;
    private String URL_ACCOUNT_CREATE;
    private String URL_TEAM;
    private String URL_TEAM_CREATE;
    private String URL_TEAM_DESTROY;
    private String URL_TEAM_ADD_MEMBER;
    private String URL_TEAM_REMOVE_MEMBER;
    private String URL_SIGNATURE_REQUEST;
    private String URL_SIGNATURE_REQUEST_LIST;
    private String URL_SIGNATURE_REQUEST_SEND;
    private String URL_TEMPLATE;
    private String URL_TEMPLATE_FILE;
    private String URL_TEMPLATE_LIST;
    private String URL_TEMPLATE_ADD_USER;
    private String URL_TEMPLATE_REMOVE_USER;
    private String URL_TEMPLATE_DELETE;
    private String URL_TEMPLATE_CREATE_EMBEDDED_DRAFT;
    private String URL_TEMPLATE_SIGNATURE_REQUEST;
    private String URL_SIGNATURE_REQUEST_CANCEL;
    private String URL_SIGNATURE_REQUEST_REMIND;
    private String URL_SIGNATURE_REQUEST_FINAL_COPY;
    private String URL_SIGNATURE_REQUEST_FILES;
    private String URL_SIGNATURE_REQUEST_UPDATE;
    private String URL_SIGNATURE_REQUEST_EMBEDDED;
    private String URL_SIGNATURE_REQUEST_EMBEDDED_TEMPLATE;
    private String URL_EMBEDDED_SIGN_URL;
    private String URL_EMBEDDED_EDIT_URL;
    private String URL_UNCLAIMED_DRAFT_CREATE;
    private String URL_UNCLAIMED_DRAFT_CREATE_EMBEDDED;
    private String URL_UNCLAIMED_DRAFT_CREATE_EMBEDDED_WITH_TEMPLATE;
    private String URL_API_APP;
    private String URL_API_APP_LIST;
    private String URL_PARAM_FILE_TYPE = "file_type";
    public static final String FINAL_COPY_FILE_NAME = "final-copy";
    public static final String FINAL_COPY_FILE_EXT = "pdf";
    public static final String FILES_FILE_NAME = "files";
    public static final String FILES_FILE_EXT = "pdf";
    public static final String TEMPLATE_FILE_NAME = "template";
    public static final String TEMPLATE_FILE_EXT = "pdf";
    public static final String OAUTH_CODE = "code";
    public static final String OAUTH_STATE = "state";
    public static final String OAUTH_GRANT_TYPE = "grant_type";
    public static final String OAUTH_REFRESH_TOKEN = "refresh_token";
    public static final String OAUTH_GRANT_TYPE_AUTHORIZE_CODE = "authorization_code";
    public static final String OAUTH_GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String CLIENT_ID = "client_id";
    private Authentication auth = new Authentication();

    private HelloSignClient() {
        String disableSslCheck;
        String baseUrl = System.getProperty("hellosign.base.url");
        if (baseUrl != null && !baseUrl.isEmpty()) {
            this.URL_HELLOSIGN = baseUrl;
        }
        this.URL_OAUTH_TOKEN = URL_OAUTH_TOKEN_PRODUCTION;
        String customOauthToken = System.getProperty("hellosign.oauth.base.url");
        if (customOauthToken != null && !customOauthToken.isEmpty()) {
            this.URL_OAUTH_TOKEN = customOauthToken;
        }
        if ((disableSslCheck = System.getProperty("hellosign.disable.ssl")) != null && "true".equalsIgnoreCase(disableSslCheck)) {
            HelloSignClient.disableStrictSSL();
        }
        this.initApiEndpoints();
    }

    private void initApiEndpoints() {
        this.URL_API = this.URL_HELLOSIGN + "/" + API_VERSION;
        this.URL_ACCOUNT = this.URL_API + "/account";
        this.URL_VALIDATE_ACCOUNT = this.URL_ACCOUNT + "/verify";
        this.URL_ACCOUNT_CREATE = this.URL_ACCOUNT + "/create";
        this.URL_TEAM = this.URL_API + "/team";
        this.URL_TEAM_CREATE = this.URL_TEAM + "/create";
        this.URL_TEAM_DESTROY = this.URL_TEAM + "/destroy";
        this.URL_TEAM_ADD_MEMBER = this.URL_TEAM + "/add_member";
        this.URL_TEAM_REMOVE_MEMBER = this.URL_TEAM + "/remove_member";
        this.URL_SIGNATURE_REQUEST = this.URL_API + "/signature_request";
        this.URL_SIGNATURE_REQUEST_LIST = this.URL_SIGNATURE_REQUEST + "/list";
        this.URL_SIGNATURE_REQUEST_SEND = this.URL_SIGNATURE_REQUEST + "/send";
        this.URL_TEMPLATE = this.URL_API + "/template";
        this.URL_TEMPLATE_FILE = this.URL_TEMPLATE + "/files";
        this.URL_TEMPLATE_LIST = this.URL_TEMPLATE + "/list";
        this.URL_TEMPLATE_ADD_USER = this.URL_TEMPLATE + "/add_user";
        this.URL_TEMPLATE_REMOVE_USER = this.URL_TEMPLATE + "/remove_user";
        this.URL_TEMPLATE_DELETE = this.URL_TEMPLATE + "/delete";
        this.URL_TEMPLATE_CREATE_EMBEDDED_DRAFT = this.URL_TEMPLATE + "/create_embedded_draft";
        this.URL_TEMPLATE_SIGNATURE_REQUEST = this.URL_SIGNATURE_REQUEST + "/send_with_template";
        this.URL_SIGNATURE_REQUEST_CANCEL = this.URL_SIGNATURE_REQUEST + "/cancel";
        this.URL_SIGNATURE_REQUEST_REMIND = this.URL_SIGNATURE_REQUEST + "/remind";
        this.URL_SIGNATURE_REQUEST_FINAL_COPY = this.URL_SIGNATURE_REQUEST + "/final_copy";
        this.URL_SIGNATURE_REQUEST_FILES = this.URL_SIGNATURE_REQUEST + "/files";
        this.URL_SIGNATURE_REQUEST_UPDATE = this.URL_SIGNATURE_REQUEST + "/update";
        this.URL_SIGNATURE_REQUEST_EMBEDDED = this.URL_SIGNATURE_REQUEST + "/create_embedded";
        this.URL_SIGNATURE_REQUEST_EMBEDDED_TEMPLATE = this.URL_SIGNATURE_REQUEST + "/create_embedded_with_template";
        this.URL_EMBEDDED_SIGN_URL = this.URL_API + "/embedded/sign_url";
        this.URL_EMBEDDED_EDIT_URL = this.URL_API + "/embedded/edit_url";
        this.URL_UNCLAIMED_DRAFT_CREATE = this.URL_API + "/unclaimed_draft/create";
        this.URL_UNCLAIMED_DRAFT_CREATE_EMBEDDED = this.URL_API + "/unclaimed_draft/create_embedded";
        this.URL_UNCLAIMED_DRAFT_CREATE_EMBEDDED_WITH_TEMPLATE = this.URL_API + "/unclaimed_draft/create_embedded_with_template";
        this.URL_API_APP = this.URL_API + "/api_app";
        this.URL_API_APP_LIST = this.URL_API_APP + "/list";
    }

    public HelloSignClient(String apiKey) {
        this();
        this.auth.setApiKey(apiKey);
    }

    public HelloSignClient(String email, String password) throws HelloSignException {
        this();
        this.auth.setWebsiteCredentials(email, password);
    }

    public HelloSignClient(Authentication auth) throws HelloSignException {
        this();
        this.auth = new Authentication(auth);
    }

    public Account getAccount() throws HelloSignException {
        HttpGetRequest request = new HttpGetRequest(this.URL_ACCOUNT, this.auth);
        JSONObject json = request.getJsonResponse();
        return new Account(json);
    }

    public boolean isAccountValid(String email) throws HelloSignException {
        if (email == null) {
            return false;
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("email_address", (Serializable)((Object)email));
        HttpPostRequest request = new HttpPostRequest(this.URL_VALIDATE_ACCOUNT, params, this.auth);
        JSONObject response = request.getJsonResponse();
        if (response.has("account")) {
            try {
                JSONObject account = response.getJSONObject("account");
                if (account.has("email_address")) {
                    return email.equalsIgnoreCase(account.getString("email_address"));
                }
            }
            catch (JSONException ex) {
                throw new HelloSignException((Exception)((Object)ex));
            }
        }
        return false;
    }

    public Account setCallback(String callback) throws HelloSignException {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("callback_url", (Serializable)((Object)callback));
        HttpPostRequest request = new HttpPostRequest(this.URL_ACCOUNT, properties, this.auth);
        JSONObject json = request.getJsonResponse();
        return new Account(json);
    }

    public Account createAccount(String email) throws HelloSignException {
        return this.createAccount(email, null, null);
    }

    public Account createAccount(String email, String password) throws HelloSignException {
        return this.createAccount(email, password, null, null);
    }

    public Account createAccount(String email, String clientId, String clientSecret) throws HelloSignException {
        HashMap<String, Serializable> fields = new HashMap<String, Serializable>();
        fields.put("email_address", (Serializable)((Object)email));
        if (clientId != null && clientSecret != null) {
            fields.put(CLIENT_ID, (Serializable)((Object)clientId));
            fields.put(CLIENT_SECRET, (Serializable)((Object)clientSecret));
        }
        HttpPostRequest request = new HttpPostRequest(this.URL_ACCOUNT_CREATE, fields, this.auth);
        JSONObject json = request.getJsonResponse();
        return new Account(json);
    }

    public Account createAccount(String email, String password, String clientId, String clientSecret) throws HelloSignException {
        HashMap<String, Serializable> fields = new HashMap<String, Serializable>();
        fields.put("email_address", (Serializable)((Object)email));
        fields.put("password", (Serializable)((Object)password));
        if (clientId != null && clientSecret != null) {
            fields.put(CLIENT_ID, (Serializable)((Object)clientId));
            fields.put(CLIENT_SECRET, (Serializable)((Object)clientSecret));
        }
        HttpPostRequest request = new HttpPostRequest(this.URL_ACCOUNT_CREATE, fields, this.auth);
        JSONObject json = request.getJsonResponse();
        return new Account(json);
    }

    public OauthData getOauthData(String code, String clientId, String secret) throws HelloSignException {
        return this.getOauthData(code, clientId, secret, true);
    }

    public OauthData getOauthData(String code, String clientId, String secret, boolean autoSetRequestToken) throws HelloSignException {
        HashMap<String, Serializable> fields = new HashMap<String, Serializable>();
        fields.put(OAUTH_STATE, (Serializable)((Object)"demo"));
        fields.put(OAUTH_CODE, (Serializable)((Object)code));
        fields.put(CLIENT_ID, (Serializable)((Object)clientId));
        fields.put(OAUTH_GRANT_TYPE, (Serializable)((Object)OAUTH_GRANT_TYPE_AUTHORIZE_CODE));
        fields.put(CLIENT_SECRET, (Serializable)((Object)secret));
        HttpPostRequest request = new HttpPostRequest(this.URL_OAUTH_TOKEN, fields, this.auth);
        JSONObject json = request.getJsonResponse();
        OauthData data = new OauthData(json);
        if (data != null && autoSetRequestToken) {
            this.setAccessToken(data.getAccessToken(), data.getTokenType());
        }
        return data;
    }

    public OauthData refreshOauthData(String refreshToken) throws HelloSignException {
        HashMap<String, Serializable> fields = new HashMap<String, Serializable>();
        fields.put(OAUTH_GRANT_TYPE, (Serializable)((Object)"refresh_token"));
        fields.put("refresh_token", (Serializable)((Object)refreshToken));
        HttpPostRequest request = new HttpPostRequest(this.URL_OAUTH_TOKEN, fields, this.auth);
        JSONObject json = request.getJsonResponse();
        OauthData data = new OauthData(json);
        if (data != null) {
            this.setAccessToken(data.getAccessToken(), data.getTokenType());
        }
        return data;
    }

    public Team getTeam() throws HelloSignException {
        HttpGetRequest request = new HttpGetRequest(this.URL_TEAM, this.auth);
        return new Team(request.getJsonResponse());
    }

    public Team createTeam(String teamName) throws HelloSignException {
        HashMap<String, Serializable> fields = new HashMap<String, Serializable>();
        fields.put("name", (Serializable)((Object)teamName));
        HttpPostRequest request = new HttpPostRequest(this.URL_TEAM_CREATE, fields, this.auth);
        JSONObject json = request.getJsonResponse();
        return new Team(json);
    }

    public int destroyTeam() throws HelloSignException {
        HttpPostRequest request = new HttpPostRequest(this.URL_TEAM_DESTROY, this.auth);
        return request.getHttpResponseCode();
    }

    public Team updateTeamName(String teamName) throws HelloSignException {
        HashMap<String, Serializable> fields = new HashMap<String, Serializable>();
        fields.put("name", (Serializable)((Object)teamName));
        HttpPostRequest request = new HttpPostRequest(this.URL_TEAM, fields, this.auth);
        JSONObject json = request.getJsonResponse();
        return new Team(json);
    }

    public Team inviteTeamMember(String idOrEmail) throws HelloSignException {
        HashMap<String, Serializable> fields = new HashMap<String, Serializable>();
        if (idOrEmail.contains("@")) {
            fields.put("email_address", (Serializable)((Object)idOrEmail));
        } else {
            fields.put("account_id", (Serializable)((Object)idOrEmail));
        }
        HttpPostRequest request = new HttpPostRequest(this.URL_TEAM_ADD_MEMBER, fields, this.auth);
        JSONObject json = request.getJsonResponse();
        return new Team(json);
    }

    public Team removeTeamMember(String idOrEmail) throws HelloSignException {
        HashMap<String, Serializable> fields = new HashMap<String, Serializable>();
        if (idOrEmail.contains("@")) {
            fields.put("email_address", (Serializable)((Object)idOrEmail));
        } else {
            fields.put("account_id", (Serializable)((Object)idOrEmail));
        }
        HttpPostRequest request = new HttpPostRequest(this.URL_TEAM_REMOVE_MEMBER, fields, this.auth);
        JSONObject json = request.getJsonResponse();
        return new Team(json);
    }

    public SignatureRequest getSignatureRequest(String id) throws HelloSignException {
        HttpGetRequest request = new HttpGetRequest(this.URL_SIGNATURE_REQUEST + "/" + id, this.auth);
        return new SignatureRequest(request.getJsonResponse());
    }

    public SignatureRequestList getSignatureRequests() throws HelloSignException {
        HttpGetRequest request = new HttpGetRequest(this.URL_SIGNATURE_REQUEST_LIST, this.auth);
        return new SignatureRequestList(request.getJsonResponse());
    }

    public SignatureRequestList getSignatureRequests(int page) throws HelloSignException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("page", Integer.toString(page));
        HttpGetRequest request = new HttpGetRequest(this.URL_SIGNATURE_REQUEST_LIST, params, this.auth);
        return new SignatureRequestList(request.getJsonResponse());
    }

    public SignatureRequest sendSignatureRequest(SignatureRequest req) throws HelloSignException {
        if (req.hasId()) {
            throw new HelloSignException("Sending an existing signature request is not supported");
        }
        HttpPostRequest request = new HttpPostRequest(this.URL_SIGNATURE_REQUEST_SEND, req.getPostFields(), this.auth);
        JSONObject json = request.getJsonResponse();
        return new SignatureRequest(json);
    }

    public SignatureRequest updateSignatureRequest(String signature_request_id, String signature_id, String new_email_address) throws HelloSignException {
        String url = this.URL_SIGNATURE_REQUEST_UPDATE + "/" + signature_request_id;
        HashMap<String, Serializable> fields = new HashMap<String, Serializable>();
        fields.put("signature_id", (Serializable)((Object)signature_id));
        fields.put("email_address", (Serializable)((Object)new_email_address));
        HttpPostRequest request = new HttpPostRequest(url, fields, this.auth);
        JSONObject json = request.getJsonResponse();
        return new SignatureRequest(json);
    }

    public TemplateList getTemplates() throws HelloSignException {
        HttpGetRequest request = new HttpGetRequest(this.URL_TEMPLATE_LIST, this.auth);
        return new TemplateList(request.getJsonResponse());
    }

    public TemplateList getTemplates(int page) throws HelloSignException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("page", Integer.toString(page));
        HttpGetRequest request = new HttpGetRequest(this.URL_TEMPLATE_LIST, params, this.auth);
        return new TemplateList(request.getJsonResponse());
    }

    public File getTemplateFile(String templateId) throws HelloSignException {
        String url = this.URL_TEMPLATE_FILE + "/" + templateId;
        HttpGetRequest request = new HttpGetRequest(url, this.auth);
        return request.getFileResponse("template.pdf");
    }

    public Template getTemplate(String templateId) throws HelloSignException {
        String url = this.URL_TEMPLATE + "/" + templateId;
        HttpGetRequest request = new HttpGetRequest(url, this.auth);
        return new Template(request.getJsonResponse());
    }

    public Template addTemplateUser(String templateId, String idOrEmail) throws HelloSignException {
        String url = this.URL_TEMPLATE_ADD_USER + "/" + templateId;
        HashMap<String, Serializable> fields = new HashMap<String, Serializable>();
        if (idOrEmail.contains("@")) {
            fields.put("email_address", (Serializable)((Object)idOrEmail));
        } else {
            fields.put("account_id", (Serializable)((Object)idOrEmail));
        }
        HttpPostRequest request = new HttpPostRequest(url, fields, this.auth);
        JSONObject json = request.getJsonResponse();
        return new Template(json);
    }

    public boolean deleteTemplate(String templateId) throws HelloSignException {
        String url = this.URL_TEMPLATE_DELETE + "/" + templateId;
        HttpPostRequest request = new HttpPostRequest(url, this.auth);
        int response = request.getHttpResponseCode();
        if (response == 200) {
            return true;
        }
        throw new HelloSignException("Unable to delete template with ID " + templateId + ". Server returned: " + response);
    }

    public Template removeTemplateUser(String templateId, String idOrEmail) throws HelloSignException {
        String url = this.URL_TEMPLATE_REMOVE_USER + "/" + templateId;
        HashMap<String, Serializable> fields = new HashMap<String, Serializable>();
        if (idOrEmail.contains("@")) {
            fields.put("email_address", (Serializable)((Object)idOrEmail));
        } else {
            fields.put("account_id", (Serializable)((Object)idOrEmail));
        }
        HttpPostRequest request = new HttpPostRequest(url, fields, this.auth);
        JSONObject json = request.getJsonResponse();
        return new Template(json);
    }

    public SignatureRequest sendTemplateSignatureRequest(TemplateSignatureRequest req) throws HelloSignException {
        HttpPostRequest request = new HttpPostRequest(this.URL_TEMPLATE_SIGNATURE_REQUEST, req.getPostFields(), this.auth);
        JSONObject json = request.getJsonResponse();
        return new SignatureRequest(json);
    }

    public int cancelSignatureRequest(String id) throws HelloSignException {
        String cancelUrl = this.URL_SIGNATURE_REQUEST_CANCEL + "/" + id;
        HttpPostRequest request = new HttpPostRequest(cancelUrl, this.auth);
        return request.getHttpResponseCode();
    }

    public SignatureRequest requestEmailReminder(String requestId, String email) throws HelloSignException {
        HashMap<String, Serializable> fields = new HashMap<String, Serializable>();
        fields.put("email_address", (Serializable)((Object)email));
        String remindUrl = this.URL_SIGNATURE_REQUEST_REMIND + "/" + requestId;
        HttpPostRequest request = new HttpPostRequest(remindUrl, fields, this.auth);
        JSONObject json = request.getJsonResponse();
        return new SignatureRequest(json);
    }

    public File getFinalCopy(String requestId) throws HelloSignException {
        String finalCopyUrl = this.URL_SIGNATURE_REQUEST_FINAL_COPY + "/" + requestId;
        String filename = "final-copy.pdf";
        HttpGetRequest request = new HttpGetRequest(finalCopyUrl, this.auth);
        return request.getFileResponse(filename);
    }

    public File getFiles(String requestId) throws HelloSignException {
        return this.getFiles(requestId, "pdf");
    }

    public File getFiles(String requestId, String format) throws HelloSignException {
        if (format == null || format.isEmpty()) {
            format = "pdf";
        }
        String filesUrl = this.URL_SIGNATURE_REQUEST_FILES + "/" + requestId + "?" + this.URL_PARAM_FILE_TYPE + "=" + format;
        HttpGetRequest request = new HttpGetRequest(filesUrl, null, this.auth);
        String filename = "files." + format;
        return request.getFileResponse(filename);
    }

    public AbstractRequest createEmbeddedRequest(EmbeddedRequest embeddedReq) throws HelloSignException {
        String url = this.URL_SIGNATURE_REQUEST_EMBEDDED;
        Class returnType = SignatureRequest.class;
        AbstractRequest req = embeddedReq.getRequest();
        if (req instanceof TemplateSignatureRequest) {
            url = this.URL_SIGNATURE_REQUEST_EMBEDDED_TEMPLATE;
        } else if (req instanceof UnclaimedDraft) {
            url = ((UnclaimedDraft)req).getRequest() instanceof TemplateSignatureRequest ? this.URL_UNCLAIMED_DRAFT_CREATE_EMBEDDED_WITH_TEMPLATE : this.URL_UNCLAIMED_DRAFT_CREATE_EMBEDDED;
            returnType = UnclaimedDraft.class;
        }
        HttpPostRequest request = new HttpPostRequest(url, embeddedReq.getPostFields(), this.auth);
        JSONObject json = request.getJsonResponse();
        try {
            Constructor constructor = returnType.getConstructor(JSONObject.class);
            return (AbstractRequest)constructor.newInstance(json);
        }
        catch (Exception ex) {
            throw new HelloSignException(ex);
        }
    }

    public EmbeddedResponse getEmbeddedSignUrl(String signatureId) throws HelloSignException {
        String url = this.URL_EMBEDDED_SIGN_URL + "/" + signatureId;
        HttpGetRequest request = new HttpGetRequest(url, this.auth);
        JSONObject json = request.getJsonResponse();
        return new EmbeddedResponse(json);
    }

    public EmbeddedResponse getEmbeddedTemplateEditUrl(String templateId) throws HelloSignException {
        return this.getEmbeddedTemplateEditUrl(templateId, false, false);
    }

    public EmbeddedResponse getEmbeddedTemplateEditUrl(String templateId, boolean skipSignerRoles, boolean skipSubjectMessage) throws HelloSignException {
        String url = this.URL_EMBEDDED_EDIT_URL + "/" + templateId;
        if (skipSignerRoles || skipSubjectMessage) {
            url = url + '?';
            if (skipSignerRoles) {
                url = url + "skip_signer_roles=1";
            }
            if (skipSubjectMessage) {
                url = url + "skip_subject_message=1";
            }
        }
        HttpPostRequest request = new HttpPostRequest(url, this.auth);
        JSONObject json = request.getJsonResponse();
        return new EmbeddedResponse(json);
    }

    public UnclaimedDraft createUnclaimedDraft(UnclaimedDraft draft) throws HelloSignException {
        String url = this.URL_UNCLAIMED_DRAFT_CREATE;
        if (draft.isForEmbeddedSigning()) {
            url = this.URL_UNCLAIMED_DRAFT_CREATE_EMBEDDED;
        }
        HttpPostRequest request = new HttpPostRequest(url, draft.getPostFields(), this.auth);
        JSONObject json = request.getJsonResponse();
        return new UnclaimedDraft(json);
    }

    public TemplateDraft createEmbeddedTemplateDraft(EmbeddedRequest req) throws HelloSignException {
        String url = this.URL_TEMPLATE_CREATE_EMBEDDED_DRAFT;
        Class<TemplateDraft> returnType = TemplateDraft.class;
        HttpPostRequest request = new HttpPostRequest(url, req.getPostFields(), this.auth);
        JSONObject json = request.getJsonResponse();
        try {
            Constructor constructor = returnType.getConstructor(JSONObject.class);
            return (TemplateDraft)constructor.newInstance(json);
        }
        catch (Exception ex) {
            throw new HelloSignException(ex);
        }
    }

    public ApiApp getApiApp(String clientId) throws HelloSignException {
        HttpGetRequest request = new HttpGetRequest(this.URL_API_APP + "/" + clientId, this.auth);
        return new ApiApp(request.getJsonResponse());
    }

    public ApiAppList getApiApps() throws HelloSignException {
        HttpGetRequest request = new HttpGetRequest(this.URL_API_APP_LIST, this.auth);
        return new ApiAppList(request.getJsonResponse());
    }

    public ApiApp createApiApp(ApiApp app) throws HelloSignException {
        HttpPostRequest request = new HttpPostRequest(this.URL_API_APP, app.getPostFields(), this.auth);
        return new ApiApp(request.getJsonResponse());
    }

    public boolean deleteApiApp(String clientId) throws HelloSignException {
        HttpDeleteRequest request = new HttpDeleteRequest(this.URL_API_APP + "/" + clientId, this.auth);
        return 204 == request.getHttpResponseCode();
    }

    public ApiApp updateApiApp(ApiApp app) throws HelloSignException {
        if (!app.hasClientId()) {
            throw new HelloSignException("Cannot update an ApiApp without a client ID. Create one first!");
        }
        HttpPutRequest request = new HttpPutRequest(this.URL_API_APP + "/" + app.getClientId(), app.getPostFields(), this.auth);
        return new ApiApp(request.getJsonResponse());
    }

    public boolean isOnline() {
        HttpURLConnection connection = null;
        try {
            connection = AbstractHttpRequest.getConnection(this.URL_API);
            connection.setRequestMethod("OPTIONS");
            return 200 == connection.getResponseCode();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setAccessToken(String accessToken, String tokenType) throws HelloSignException {
        this.auth.setAccessToken(accessToken, tokenType);
    }

    public String getApiUrl() {
        return this.URL_API;
    }

    public String getSignatureRequestUrl() {
        return this.URL_SIGNATURE_REQUEST;
    }

    public String getSignatureRequestSendUrl() {
        return this.URL_SIGNATURE_REQUEST_SEND;
    }

    public String getSignatureRequestCancelUrl() {
        return this.URL_SIGNATURE_REQUEST_CANCEL;
    }

    public String getTemplateSignatureRequestUrl() {
        return this.URL_TEMPLATE_SIGNATURE_REQUEST;
    }

    private static void disableStrictSSL() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

