/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.handler.specific;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectToServletXServletHandler
implements IXServletSimpleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedirectToServletXServletHandler.class);
    private final String m_sServletPath;

    public RedirectToServletXServletHandler(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ServletPath");
        ValueEnforcer.isTrue((boolean)string.startsWith("/"), (String)"Path must start with '/'!");
        this.m_sServletPath = string;
    }

    @Nonnull
    @Nonempty
    public final String getServletPath() {
        return this.m_sServletPath;
    }

    @Nonnull
    @OverridingMethodsMustInvokeSuper
    protected String getRedirectURL(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        String string = iRequestWebScopeWithoutResponse.getContextPath() + this.m_sServletPath;
        String string2 = iRequestWebScopeWithoutResponse.getQueryString();
        if (StringHelper.hasText((String)string2)) {
            string = string + "?" + string2;
        }
        return string;
    }

    @Override
    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        String string = this.getRedirectURL(iRequestWebScopeWithoutResponse);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending redirect to '" + string + "'");
        }
        unifiedResponse.setRedirect(string);
    }
}

