/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.handler.specific;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import java.util.Map;
import javax.annotation.Nonnull;

public class RedirectAbsoluteXServletHandler
implements IXServletSimpleHandler {
    private final ISimpleURL m_aTargetURL;

    public RedirectAbsoluteXServletHandler(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"TargetURL");
        this.m_aTargetURL = iSimpleURL;
    }

    @Nonnull
    @Nonempty
    public final ISimpleURL getTargetURL() {
        return this.m_aTargetURL;
    }

    @Override
    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        SimpleURL simpleURL = new SimpleURL(this.m_aTargetURL);
        for (Map.Entry entry : iRequestWebScopeWithoutResponse.params().entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof String) {
                simpleURL.add(string, (String)v);
                continue;
            }
            if (!(v instanceof String[])) continue;
            for (String string2 : (String[])v) {
                simpleURL.add(string, string2);
            }
        }
        unifiedResponse.setRedirect(simpleURL.getAsStringWithEncodedParameters());
    }
}

