/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.write;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsTreeMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.CXML;
import com.helger.xml.EXMLVersion;
import com.helger.xml.microdom.IMicroDocumentType;
import com.helger.xml.serialize.write.EXMLCharMode;
import com.helger.xml.serialize.write.EXMLIncorrectCharacterHandling;
import com.helger.xml.serialize.write.EXMLSerializeBracketMode;
import com.helger.xml.serialize.write.EXMLSerializeVersion;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLMaskHelper;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;

@NotThreadSafe
public class XMLEmitter
implements AutoCloseable,
Flushable {
    public static final boolean DEFAULT_THROW_EXCEPTION_ON_NESTED_COMMENTS = true;
    public static final String CDATA_START = "<![CDATA[";
    public static final String CDATA_END = "]]>";
    public static final String COMMENT_START = "<!--";
    public static final String COMMENT_END = "-->";
    public static final char ER_START = '&';
    public static final char ER_END = ';';
    public static final String PI_START = "<?";
    public static final String PI_END = "?>";
    private static boolean s_bThrowExceptionOnNestedComments = true;
    private final Writer m_aWriter;
    private final IXMLWriterSettings m_aXMLWriterSettings;
    private EXMLSerializeVersion m_eXMLVersion;
    private final char m_cAttrValueBoundary;
    private final EXMLCharMode m_eAttrValueCharMode;
    private final boolean m_bOrderAttributesAndNamespaces;

    public static void setThrowExceptionOnNestedComments(boolean bl) {
        s_bThrowExceptionOnNestedComments = bl;
    }

    public static boolean isThrowExceptionOnNestedComments() {
        return s_bThrowExceptionOnNestedComments;
    }

    public XMLEmitter(@Nonnull @WillNotClose Writer writer, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        this.m_aWriter = (Writer)ValueEnforcer.notNull((Object)writer, (String)"Writer");
        this.m_aXMLWriterSettings = (IXMLWriterSettings)ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Settings");
        this.m_eXMLVersion = iXMLWriterSettings.getSerializeVersion();
        this.m_cAttrValueBoundary = (char)(iXMLWriterSettings.isUseDoubleQuotesForAttributes() ? 34 : 39);
        this.m_eAttrValueCharMode = iXMLWriterSettings.isUseDoubleQuotesForAttributes() ? EXMLCharMode.ATTRIBUTE_VALUE_DOUBLE_QUOTES : EXMLCharMode.ATTRIBUTE_VALUE_SINGLE_QUOTES;
        this.m_bOrderAttributesAndNamespaces = iXMLWriterSettings.isOrderAttributesAndNamespaces();
    }

    @Nonnull
    public IXMLWriterSettings getXMLWriterSettings() {
        return this.m_aXMLWriterSettings;
    }

    @Nonnull
    private XMLEmitter _append(@Nonnull String string) {
        try {
            this.m_aWriter.write(string);
            return this;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to append string '" + string + "'", iOException);
        }
    }

    @Nonnull
    private XMLEmitter _append(char c) {
        try {
            this.m_aWriter.write(c);
            return this;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to append character '" + c + "'", iOException);
        }
    }

    @Nonnull
    private XMLEmitter _append(char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        try {
            this.m_aWriter.write(cArray, n, n2);
            return this;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to append character '" + new String(cArray, n, n2) + "'", iOException);
        }
    }

    @Nonnull
    private XMLEmitter _appendMasked(@Nonnull EXMLCharMode eXMLCharMode, @Nullable String string) {
        try {
            XMLMaskHelper.maskXMLTextTo(this.m_eXMLVersion, eXMLCharMode, this.m_aXMLWriterSettings.getIncorrectCharacterHandling(), string, this.m_aWriter);
            return this;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to append masked string '" + string + "'", iOException);
        }
    }

    @Nonnull
    private XMLEmitter _appendMasked(@Nonnull EXMLCharMode eXMLCharMode, @Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        try {
            XMLMaskHelper.maskXMLTextTo(this.m_eXMLVersion, eXMLCharMode, this.m_aXMLWriterSettings.getIncorrectCharacterHandling(), cArray, n, n2, this.m_aWriter);
            return this;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to append masked char[] '" + new String(cArray, n, n2) + "'", iOException);
        }
    }

    @Nonnull
    private XMLEmitter _appendAttrValue(@Nullable String string) {
        return this._append(this.m_cAttrValueBoundary)._appendMasked(this.m_eAttrValueCharMode, string)._append(this.m_cAttrValueBoundary);
    }

    @Nonnull
    public XMLEmitter newLine() {
        if (this.m_aXMLWriterSettings.getIndent().isAlign()) {
            this._append(this.m_aXMLWriterSettings.getNewLineString());
        }
        return this;
    }

    public void onXMLDeclaration(@Nullable EXMLVersion eXMLVersion, @Nullable String string, boolean bl) {
        if (eXMLVersion != null) {
            this.m_eXMLVersion = EXMLSerializeVersion.getFromXMLVersionOrThrow(eXMLVersion);
        }
        this._append(PI_START)._append("xml version=")._appendAttrValue(this.m_eXMLVersion.getXMLVersionString());
        if (StringHelper.hasText((String)string)) {
            this._append(" encoding=")._appendAttrValue(string);
        }
        if (bl) {
            this._append(" standalone=")._appendAttrValue("yes");
        }
        this._append(PI_END);
        this.newLine();
    }

    public void onDTD(@Nonnull String string) {
        this._append(string);
        this.newLine();
    }

    @Nonnull
    public static String getDocTypeHTMLRepresentation(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling, @Nonnull IMicroDocumentType iMicroDocumentType) {
        return XMLEmitter.getDocTypeXMLRepresentation(eXMLSerializeVersion, eXMLIncorrectCharacterHandling, iMicroDocumentType.getQualifiedName(), iMicroDocumentType.getPublicID(), iMicroDocumentType.getSystemID());
    }

    @Nonnull
    public static String getDocTypeXMLRepresentation(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling, @Nonnull String string, @Nullable String string2, @Nullable String string3) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("<!DOCTYPE ").append(string);
        if (string2 != null && string3 != null) {
            stringBuilder.append(" PUBLIC \"").append(XMLMaskHelper.getMaskedXMLText(eXMLSerializeVersion, EXMLCharMode.ATTRIBUTE_VALUE_DOUBLE_QUOTES, eXMLIncorrectCharacterHandling, string2)).append("\" \"").append(XMLMaskHelper.getMaskedXMLText(eXMLSerializeVersion, EXMLCharMode.ATTRIBUTE_VALUE_DOUBLE_QUOTES, eXMLIncorrectCharacterHandling, string3)).append('\"');
        } else if (string3 != null) {
            stringBuilder.append(" SYSTEM \"").append(XMLMaskHelper.getMaskedXMLText(eXMLSerializeVersion, EXMLCharMode.ATTRIBUTE_VALUE_DOUBLE_QUOTES, eXMLIncorrectCharacterHandling, string3)).append('\"');
        }
        return stringBuilder.append('>').toString();
    }

    public void onDocumentType(@Nonnull String string, @Nullable String string2, @Nullable String string3) {
        ValueEnforcer.notNull((Object)string, (String)"QualifiedElementName");
        String string4 = XMLEmitter.getDocTypeXMLRepresentation(this.m_eXMLVersion, this.m_aXMLWriterSettings.getIncorrectCharacterHandling(), string, string2, string3);
        this._append(string4);
        this.newLine();
    }

    public void onProcessingInstruction(@Nonnull String string, @Nullable String string2) {
        this._append(PI_START)._append(string);
        if (StringHelper.hasText((String)string2)) {
            this._append(' ')._append(string2);
        }
        this._append(PI_END);
        this.newLine();
    }

    public void onEntityReference(@Nonnull String string) {
        this._append('&')._append(string)._append(';');
    }

    public void onContentElementWhitespace(@Nullable CharSequence charSequence) {
        if (StringHelper.hasText((CharSequence)charSequence)) {
            this._append(charSequence.toString());
        }
    }

    public void onComment(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            if (XMLEmitter.isThrowExceptionOnNestedComments() && (string.contains(COMMENT_START) || string.contains(COMMENT_END))) {
                throw new IllegalArgumentException("XML comment contains nested XML comment: " + string);
            }
            this._append(COMMENT_START)._append(string)._append(COMMENT_END);
        }
    }

    public void onText(@Nullable String string) {
        this.onText(string, true);
    }

    public void onText(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this.onText(cArray, n, n2, true);
    }

    public void onText(@Nullable String string, boolean bl) {
        if (bl) {
            this._appendMasked(EXMLCharMode.TEXT, string);
        } else {
            this._append(string);
        }
    }

    public void onText(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        if (bl) {
            this._appendMasked(EXMLCharMode.TEXT, cArray, n, n2);
        } else {
            this._append(cArray, n, n2);
        }
    }

    public void onCDATA(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            if (string.indexOf(CDATA_END) >= 0) {
                ICommonsList iCommonsList = StringHelper.getExploded((String)CDATA_END, (String)string);
                int n = iCommonsList.size();
                for (int i = 0; i < n; ++i) {
                    this._append(CDATA_START);
                    if (i > 0) {
                        this._append('>');
                    }
                    this._appendMasked(EXMLCharMode.CDATA, (String)iCommonsList.get(i));
                    if (i < n - 1) {
                        this._append("]]");
                    }
                    this._append(CDATA_END);
                }
            } else {
                this._append(CDATA_START)._appendMasked(EXMLCharMode.CDATA, string)._append(CDATA_END);
            }
        }
    }

    public void elementStartOpen(@Nullable String string, @Nonnull String string2) {
        this._append('<');
        if (StringHelper.hasText((String)string)) {
            this._appendMasked(EXMLCharMode.ELEMENT_NAME, string)._append(':');
        }
        this._appendMasked(EXMLCharMode.ELEMENT_NAME, string2);
    }

    public void elementAttr(@Nullable String string, @Nonnull String string2, @Nonnull String string3) {
        this._append(' ');
        if (StringHelper.hasText((String)string)) {
            this._append(string)._append(':');
        }
        this._appendMasked(EXMLCharMode.ATTRIBUTE_NAME, string2)._append('=')._appendAttrValue(string3);
    }

    public void elementStartClose(@Nonnull EXMLSerializeBracketMode eXMLSerializeBracketMode) {
        if (eXMLSerializeBracketMode.isSelfClosed()) {
            this._append(this.m_aXMLWriterSettings.isSpaceOnSelfClosedElement() ? " />" : "/>");
        } else {
            this._append('>');
        }
    }

    public void onElementStart(@Nullable String string, @Nonnull String string2, @Nullable Map<QName, String> map, @Nonnull EXMLSerializeBracketMode eXMLSerializeBracketMode) {
        this.elementStartOpen(string, string2);
        if (map != null && !map.isEmpty()) {
            if (this.m_bOrderAttributesAndNamespaces) {
                QName qName;
                CommonsTreeMap commonsTreeMap = new CommonsTreeMap(CXML.getComparatorQNameForNamespacePrefix());
                CommonsTreeMap commonsTreeMap2 = new CommonsTreeMap(CXML.getComparatorQNameNamespaceURIBeforeLocalPart());
                for (Map.Entry<QName, String> entry : map.entrySet()) {
                    qName = entry.getKey();
                    if ("http://www.w3.org/2000/xmlns/".equals(qName.getNamespaceURI())) {
                        commonsTreeMap.put((Object)qName, (Object)entry.getValue());
                        continue;
                    }
                    commonsTreeMap2.put((Object)qName, (Object)entry.getValue());
                }
                for (Map.Entry<QName, String> entry : commonsTreeMap.entrySet()) {
                    qName = entry.getKey();
                    this.elementAttr(qName.getPrefix(), qName.getLocalPart(), entry.getValue());
                }
                for (Map.Entry<QName, String> entry : commonsTreeMap2.entrySet()) {
                    qName = entry.getKey();
                    this.elementAttr(qName.getPrefix(), qName.getLocalPart(), entry.getValue());
                }
            } else {
                for (Map.Entry<QName, String> entry : map.entrySet()) {
                    QName qName = entry.getKey();
                    this.elementAttr(qName.getPrefix(), qName.getLocalPart(), entry.getValue());
                }
            }
        }
        this.elementStartClose(eXMLSerializeBracketMode);
    }

    public void onElementEnd(@Nullable String string, @Nonnull String string2, @Nonnull EXMLSerializeBracketMode eXMLSerializeBracketMode) {
        if (eXMLSerializeBracketMode.isOpenClose()) {
            this._append("</");
            if (StringHelper.hasText((String)string)) {
                this._appendMasked(EXMLCharMode.ELEMENT_NAME, string)._append(':');
            }
            this._appendMasked(EXMLCharMode.ELEMENT_NAME, string2)._append('>');
        }
    }

    @Override
    public void flush() throws IOException {
        this.m_aWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.m_aWriter.close();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Writer", (Object)this.m_aWriter).append("XMLWriterSettings", (Object)this.m_aXMLWriterSettings).append("XMLVersion", (Enum)this.m_eXMLVersion).append("AttrValueBoundary", this.m_cAttrValueBoundary).append("AttrValueCharMode", (Enum)this.m_eAttrValueCharMode).getToString();
    }
}

