/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.commons.annotation.MustImplementComparable;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.compare.IComparable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;

@MustImplementEqualsAndHashcode
@MustImplementComparable
public interface IMicroQName
extends IComparable<IMicroQName> {
    @Nullable
    public String getNamespaceURI();

    public boolean hasNamespaceURI();

    public boolean hasNoNamespaceURI();

    public boolean hasNamespaceURI(@Nullable String var1);

    @Nonnull
    @Nonempty
    public String getName();

    default public int compareTo(@Nonnull IMicroQName iMicroQName) {
        int n = CompareHelper.compare((Comparable)((Object)this.getNamespaceURI()), (Comparable)((Object)iMicroQName.getNamespaceURI()));
        if (n == 0) {
            n = this.getName().compareTo(iMicroQName.getName());
        }
        return n;
    }

    @Nonnull
    default public QName getAsXMLQName() {
        return new QName(this.getNamespaceURI(), this.getName());
    }

    @Nonnull
    default public QName getAsXMLQName(@Nonnull String string) {
        return new QName(this.getNamespaceURI(), this.getName(), string);
    }
}

