/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.ls;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resourceresolver.DefaultResourceResolver;
import com.helger.commons.lang.IHasClassLoader;
import com.helger.xml.ls.AbstractLSResourceResolver;
import com.helger.xml.ls.ResourceLSInput;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;

public class SimpleLSResourceResolver
extends AbstractLSResourceResolver
implements IHasClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleLSResourceResolver.class);
    private final WeakReference<ClassLoader> m_aClassLoader;

    public SimpleLSResourceResolver() {
        this(null);
    }

    public SimpleLSResourceResolver(@Nullable ClassLoader classLoader) {
        this.m_aClassLoader = new WeakReference<ClassLoader>(classLoader);
    }

    @Nullable
    public ClassLoader getClassLoader() {
        return (ClassLoader)this.m_aClassLoader.get();
    }

    @Nullable
    @OverrideOnDemand
    protected IReadableResource internalResolveResource(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5) throws Exception {
        return DefaultResourceResolver.getResolvedResource((String)string4, (String)string5, (ClassLoader)this.getClassLoader());
    }

    @Override
    @Nullable
    public final LSInput mainResolveResource(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5) {
        try {
            IReadableResource iReadableResource = this.internalResolveResource(string, string2, string3, string4, string5);
            if (iReadableResource != null) {
                return new ResourceLSInput(iReadableResource);
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to resolve resource '" + string + "', '" + string2 + "', '" + string3 + "', '" + string4 + "', '" + string5 + "'", exception);
        }
        return null;
    }
}

