/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.xml.EXMLParserFeature;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;

@NotThreadSafe
public final class XPathHelper {
    private static final XPathFactory s_aXPathFactory = XPathFactory.newInstance();
    private static final XPathHelper s_aInstance;

    private XPathHelper() {
    }

    @Nonnull
    public static XPathFactory getDefaultXPathFactory() {
        return s_aXPathFactory;
    }

    @Nonnull
    public static XPathFactory createXPathFactorySaxonFirst() {
        XPathFactory xPathFactory;
        try {
            xPathFactory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom", "net.sf.saxon.xpath.XPathFactoryImpl", ClassLoaderHelper.getContextClassLoader());
        }
        catch (Exception exception) {
            try {
                xPathFactory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
            }
            catch (Exception exception2) {
                throw new IllegalStateException("Failed to create JAXP XPathFactory", exception2);
            }
        }
        EXMLParserFeature.SECURE_PROCESSING.applyTo(xPathFactory, true);
        return xPathFactory;
    }

    @Nonnull
    public static XPath createNewXPath() {
        return XPathHelper.createNewXPath(s_aXPathFactory, null, null, null);
    }

    @Nonnull
    public static XPath createNewXPath(@Nonnull XPathFactory xPathFactory) {
        return XPathHelper.createNewXPath(xPathFactory, null, null, null);
    }

    @Nonnull
    public static XPath createNewXPath(@Nullable XPathVariableResolver xPathVariableResolver) {
        return XPathHelper.createNewXPath(s_aXPathFactory, xPathVariableResolver, null, null);
    }

    @Nonnull
    public static XPath createNewXPath(@Nonnull XPathFactory xPathFactory, @Nullable XPathVariableResolver xPathVariableResolver) {
        return XPathHelper.createNewXPath(xPathFactory, xPathVariableResolver, null, null);
    }

    @Nonnull
    public static XPath createNewXPath(@Nullable XPathFunctionResolver xPathFunctionResolver) {
        return XPathHelper.createNewXPath(s_aXPathFactory, null, xPathFunctionResolver, null);
    }

    @Nonnull
    public static XPath createNewXPath(@Nonnull XPathFactory xPathFactory, @Nullable XPathFunctionResolver xPathFunctionResolver) {
        return XPathHelper.createNewXPath(xPathFactory, null, xPathFunctionResolver, null);
    }

    @Nonnull
    public static XPath createNewXPath(@Nullable NamespaceContext namespaceContext) {
        return XPathHelper.createNewXPath(s_aXPathFactory, null, null, namespaceContext);
    }

    @Nonnull
    public static XPath createNewXPath(@Nonnull XPathFactory xPathFactory, @Nullable NamespaceContext namespaceContext) {
        return XPathHelper.createNewXPath(xPathFactory, null, null, namespaceContext);
    }

    @Nonnull
    public static XPath createNewXPath(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable NamespaceContext namespaceContext) {
        return XPathHelper.createNewXPath(s_aXPathFactory, xPathVariableResolver, null, namespaceContext);
    }

    @Nonnull
    public static XPath createNewXPath(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext) {
        return XPathHelper.createNewXPath(s_aXPathFactory, xPathVariableResolver, xPathFunctionResolver, namespaceContext);
    }

    @Nonnull
    public static XPath createNewXPath(@Nonnull XPathFactory xPathFactory, @Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext) {
        ValueEnforcer.notNull((Object)xPathFactory, (String)"XPathFactory");
        XPath xPath = xPathFactory.newXPath();
        if (xPathVariableResolver != null) {
            xPath.setXPathVariableResolver(xPathVariableResolver);
        }
        if (xPathFunctionResolver != null) {
            xPath.setXPathFunctionResolver(xPathFunctionResolver);
        }
        if (namespaceContext != null) {
            xPath.setNamespaceContext(namespaceContext);
        }
        return xPath;
    }

    @Nonnull
    public static XPathExpression createNewXPathExpression(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext, @Nonnull @Nonempty String string) {
        return XPathHelper.createNewXPathExpression(XPathHelper.createNewXPath(xPathVariableResolver, xPathFunctionResolver, namespaceContext), string);
    }

    @Nonnull
    @Deprecated
    @DevelopersNote(value="Typo in name")
    public static XPathExpression createNewXPathExpresion(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext, @Nonnull @Nonempty String string) {
        return XPathHelper.createNewXPathExpression(xPathVariableResolver, xPathFunctionResolver, namespaceContext, string);
    }

    @Nonnull
    public static XPathExpression createNewXPathExpression(@Nullable XPathVariableResolver xPathVariableResolver, @Nonnull @Nonempty String string) {
        return XPathHelper.createNewXPathExpression(XPathHelper.createNewXPath(xPathVariableResolver), string);
    }

    @Nonnull
    @Deprecated
    @DevelopersNote(value="Typo in name")
    public static XPathExpression createNewXPathExpresion(@Nullable XPathVariableResolver xPathVariableResolver, @Nonnull @Nonempty String string) {
        return XPathHelper.createNewXPathExpression(xPathVariableResolver, string);
    }

    @Nonnull
    public static XPathExpression createNewXPathExpression(@Nullable XPathFunctionResolver xPathFunctionResolver, @Nonnull @Nonempty String string) {
        return XPathHelper.createNewXPathExpression(XPathHelper.createNewXPath(xPathFunctionResolver), string);
    }

    @Nonnull
    @Deprecated
    @DevelopersNote(value="Typo in name")
    public static XPathExpression createNewXPathExpresion(@Nullable XPathFunctionResolver xPathFunctionResolver, @Nonnull @Nonempty String string) {
        return XPathHelper.createNewXPathExpression(xPathFunctionResolver, string);
    }

    @Nonnull
    public static XPathExpression createNewXPathExpression(@Nullable NamespaceContext namespaceContext, @Nonnull @Nonempty String string) {
        return XPathHelper.createNewXPathExpression(XPathHelper.createNewXPath(namespaceContext), string);
    }

    @Nonnull
    @Deprecated
    @DevelopersNote(value="Typo in name")
    public static XPathExpression createNewXPathExpresion(@Nullable NamespaceContext namespaceContext, @Nonnull @Nonempty String string) {
        return XPathHelper.createNewXPathExpression(namespaceContext, string);
    }

    @Nonnull
    public static XPathExpression createNewXPathExpression(@Nonnull @Nonempty String string) {
        return XPathHelper.createNewXPathExpression(XPathHelper.createNewXPath(), string);
    }

    @Nonnull
    @Deprecated
    @DevelopersNote(value="Typo in name")
    public static XPathExpression createNewXPathExpresion(@Nonnull @Nonempty String string) {
        return XPathHelper.createNewXPathExpression(string);
    }

    @Nonnull
    public static XPathExpression createNewXPathExpression(@Nonnull XPath xPath, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull((Object)xPath, (String)"XPath");
        ValueEnforcer.notNull((Object)string, (String)"XPathExpression");
        try {
            return xPath.compile(string);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalArgumentException("Failed to compile XPath expression '" + string + "'", xPathExpressionException);
        }
    }

    @Nonnull
    @Deprecated
    @DevelopersNote(value="Typo in name")
    public static XPathExpression createNewXPathExpresion(@Nonnull XPath xPath, @Nonnull @Nonempty String string) {
        return XPathHelper.createNewXPathExpression(xPath, string);
    }

    static {
        EXMLParserFeature.SECURE_PROCESSING.applyTo(s_aXPathFactory, true);
        s_aInstance = new XPathHelper();
    }
}

