/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.util.changelog;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.changelog.AbstractChangeLogEntry;
import com.helger.commons.changelog.ChangeLog;
import com.helger.commons.changelog.ChangeLogEntry;
import com.helger.commons.changelog.ChangeLogRelease;
import com.helger.commons.changelog.EChangeLogAction;
import com.helger.commons.changelog.EChangeLogCategory;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.datetime.DateTimeFormatterCache;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.lang.IHasClassLoader;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.MultilingualText;
import com.helger.commons.version.Version;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.util.changelog.IChangeLogSerializerCallback;
import com.helger.xml.util.changelog.LoggingChangeLogSerializerCallback;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ChangeLogSerializer {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ChangeLogSerializer.class);
    private static final DateTimeFormatter DF = DateTimeFormatterCache.getDateTimeFormatterStrict((String)"uuuu-MM-dd");
    private static final String ELEMENT_CHANGELOG = "changelog";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_COMPONENT = "component";
    private static final String ELEMENT_ENTRY = "entry";
    private static final String ATTR_DATE = "date";
    private static final String ATTR_ACTION = "action";
    private static final String ATTR_CATEGORY = "category";
    private static final String ATTR_INCOMPATIBLE = "incompatible";
    private static final String ELEMENT_CHANGE = "change";
    private static final String ELEMENT_ISSUE = "issue";
    private static final String ELEMENT_RELEASE = "release";
    private static final IChangeLogSerializerCallback s_aDefaultCallback = new LoggingChangeLogSerializerCallback();
    private static final ChangeLogSerializer s_aInstance = new ChangeLogSerializer();

    private ChangeLogSerializer() {
    }

    @Nullable
    public static ChangeLog readChangeLog(@Nullable IHasInputStream iHasInputStream) {
        return ChangeLogSerializer.readChangeLog(iHasInputStream, s_aDefaultCallback);
    }

    @Nullable
    public static ChangeLog readChangeLog(@Nullable IHasInputStream iHasInputStream, @Nonnull IChangeLogSerializerCallback iChangeLogSerializerCallback) {
        ValueEnforcer.notNull((Object)iChangeLogSerializerCallback, (String)"ErrorCallback");
        IMicroDocument iMicroDocument = MicroReader.readMicroXML(iHasInputStream);
        if (iMicroDocument == null) {
            return null;
        }
        IMicroElement iMicroElement = iMicroDocument.getDocumentElement();
        if (iMicroElement == null) {
            return null;
        }
        ChangeLog changeLog = new ChangeLog(iMicroElement.getAttributeValue(ATTR_VERSION), iMicroElement.getAttributeValue(ATTR_COMPONENT));
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
            Object object;
            String string;
            String string2;
            if (!"http://www.helger.com/xsd/changelog/1.0".equals(iMicroElement2.getNamespaceURI())) {
                iChangeLogSerializerCallback.accept("Element '" + iMicroElement2.getTagName() + "' has the wrong namespace URI '" + iMicroElement2.getNamespaceURI() + "'");
                continue;
            }
            String string3 = iMicroElement2.getTagName();
            if (ELEMENT_ENTRY.equals(string3)) {
                LocalDate localDate;
                string2 = iMicroElement2.getAttributeValue(ATTR_DATE);
                string = iMicroElement2.getAttributeValue(ATTR_ACTION);
                object = iMicroElement2.getAttributeValue(ATTR_CATEGORY);
                String string4 = iMicroElement2.getAttributeValue(ATTR_INCOMPATIBLE);
                try {
                    localDate = DF.parse((CharSequence)string2, LocalDate::from);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    iChangeLogSerializerCallback.accept("Failed to parse entry date '" + string2 + "'");
                    continue;
                }
                EChangeLogAction eChangeLogAction = EChangeLogAction.getFromIDOrNull((String)string);
                if (eChangeLogAction == null) {
                    iChangeLogSerializerCallback.accept("Failed to parse change log action '" + string + "'");
                    continue;
                }
                EChangeLogCategory eChangeLogCategory = EChangeLogCategory.getFromIDOrNull((String)object);
                if (eChangeLogCategory == null) {
                    iChangeLogSerializerCallback.accept("Failed to parse change log category '" + (String)object + "'");
                    continue;
                }
                boolean bl = StringHelper.hasText((String)string4) && StringParser.parseBool((String)string4);
                ChangeLogEntry changeLogEntry = new ChangeLogEntry(changeLog, localDate, eChangeLogAction, eChangeLogCategory, bl);
                changeLog.entries().add((Object)changeLogEntry);
                IMicroElement iMicroElement3 = iMicroElement2.getFirstChildElement("http://www.helger.com/xsd/changelog/1.0", ELEMENT_CHANGE);
                if (iMicroElement3 == null) {
                    iChangeLogSerializerCallback.accept("No change element present!");
                    continue;
                }
                MultilingualText multilingualText = MicroTypeConverter.convertToNative(iMicroElement3, MultilingualText.class);
                if (multilingualText == null) {
                    iChangeLogSerializerCallback.accept("Failed to read multi lingual text in change element!");
                    continue;
                }
                changeLogEntry.setText((IMultilingualText)multilingualText);
                for (IMicroElement iMicroElement4 : iMicroElement2.getAllChildElements("http://www.helger.com/xsd/changelog/1.0", ELEMENT_ISSUE)) {
                    changeLogEntry.addIssue(iMicroElement4.getTextContent());
                }
                continue;
            }
            if (ELEMENT_RELEASE.equals(string3)) {
                string2 = iMicroElement2.getAttributeValue(ATTR_DATE);
                string = iMicroElement2.getAttributeValue(ATTR_VERSION);
                try {
                    object = DF.parse((CharSequence)string2, LocalDate::from);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    if (!s_aLogger.isWarnEnabled()) continue;
                    s_aLogger.warn("Failed to parse release date '" + string2 + "'");
                    continue;
                }
                changeLog.entries().add((Object)new ChangeLogRelease((LocalDate)object, Version.parse((String)string, (boolean)false)));
                continue;
            }
            iChangeLogSerializerCallback.accept("Changelog contains unsupported element '" + string3 + "!");
        }
        return changeLog;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<URI, ChangeLog> readAllChangeLogs() {
        return ChangeLogSerializer.readAllChangeLogs(s_aDefaultCallback);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<URI, ChangeLog> readAllChangeLogs(@Nullable ClassLoader classLoader) {
        return ChangeLogSerializer.readAllChangeLogs(s_aDefaultCallback, classLoader);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<URI, ChangeLog> readAllChangeLogs(@Nonnull IHasClassLoader iHasClassLoader) {
        return ChangeLogSerializer.readAllChangeLogs(s_aDefaultCallback, iHasClassLoader.getClassLoader());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<URI, ChangeLog> readAllChangeLogs(@Nonnull IChangeLogSerializerCallback iChangeLogSerializerCallback) {
        return ChangeLogSerializer.readAllChangeLogs(iChangeLogSerializerCallback, null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<URI, ChangeLog> readAllChangeLogs(@Nonnull IChangeLogSerializerCallback iChangeLogSerializerCallback, @Nullable ClassLoader classLoader) {
        ValueEnforcer.notNull((Object)iChangeLogSerializerCallback, (String)"ErrorCallback");
        try {
            ClassLoader classLoader2 = classLoader != null ? classLoader : ClassLoaderHelper.getDefaultClassLoader();
            CommonsHashMap commonsHashMap = new CommonsHashMap();
            for (URL uRL : CollectionHelper.newList((Enumeration)ClassLoaderHelper.getResources((ClassLoader)classLoader2, (String)"changelog.xml"))) {
                URLResource uRLResource = new URLResource(uRL);
                ChangeLog changeLog = ChangeLogSerializer.readChangeLog((IHasInputStream)uRLResource, iChangeLogSerializerCallback);
                if (changeLog != null) {
                    commonsHashMap.put((Object)uRLResource.getAsURI(), (Object)changeLog);
                    continue;
                }
                if (!s_aLogger.isWarnEnabled()) continue;
                s_aLogger.warn("Failed to read changelog from URL " + uRL.toExternalForm());
            }
            return commonsHashMap;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to resolved changelogs", iOException);
        }
    }

    @Nonnull
    public static IMicroDocument writeChangeLog(@Nonnull ChangeLog changeLog) {
        ValueEnforcer.notNull((Object)changeLog, (String)"ChangeLog");
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement("http://www.helger.com/xsd/changelog/1.0", ELEMENT_CHANGELOG);
        iMicroElement.setAttribute("http://www.w3.org/2000/xmlns/", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        iMicroElement.setAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://www.helger.com/xsd/changelog/1.0 schemas/changelog-1.0.xsd");
        iMicroElement.setAttribute(ATTR_VERSION, changeLog.getOriginalVersion());
        if (StringHelper.hasText((String)changeLog.getComponent())) {
            iMicroElement.setAttribute(ATTR_COMPONENT, changeLog.getComponent());
        }
        for (AbstractChangeLogEntry abstractChangeLogEntry : changeLog.entries()) {
            IMicroElement iMicroElement2;
            ChangeLogEntry changeLogEntry;
            if (abstractChangeLogEntry instanceof ChangeLogEntry) {
                changeLogEntry = (ChangeLogEntry)abstractChangeLogEntry;
                iMicroElement2 = iMicroElement.appendElement("http://www.helger.com/xsd/changelog/1.0", ELEMENT_ENTRY);
                iMicroElement2.setAttribute(ATTR_DATE, DF.format(changeLogEntry.getDate()));
                iMicroElement2.setAttribute(ATTR_ACTION, changeLogEntry.getAction().getID());
                iMicroElement2.setAttribute(ATTR_CATEGORY, changeLogEntry.getCategory().getID());
                if (changeLogEntry.isIncompatible()) {
                    iMicroElement2.setAttribute(ATTR_INCOMPATIBLE, Boolean.TRUE.toString());
                }
                iMicroElement2.appendChild(MicroTypeConverter.convertToMicroElement(changeLogEntry.getAllTexts(), "http://www.helger.com/xsd/changelog/1.0", ELEMENT_CHANGE));
                for (String string : changeLogEntry.getAllIssues()) {
                    iMicroElement2.appendElement("http://www.helger.com/xsd/changelog/1.0", ELEMENT_ISSUE).appendText(string);
                }
                continue;
            }
            changeLogEntry = (ChangeLogRelease)abstractChangeLogEntry;
            iMicroElement2 = iMicroElement.appendElement("http://www.helger.com/xsd/changelog/1.0", ELEMENT_RELEASE);
            iMicroElement2.setAttribute(ATTR_DATE, DF.format(changeLogEntry.getDate()));
            iMicroElement2.setAttribute(ATTR_VERSION, changeLogEntry.getVersion().getAsString());
        }
        return microDocument;
    }
}

