/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.sax.AbstractSAXErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.xml.sax.SAXParseException;

@ThreadSafe
public class WrappedCollectingSAXErrorHandler
extends AbstractSAXErrorHandler {
    private final ErrorList m_aErrorList;

    public WrappedCollectingSAXErrorHandler(@Nonnull ErrorList errorList) {
        this.m_aErrorList = (ErrorList)ValueEnforcer.notNull((Object)errorList, (String)"ErrorList");
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public ErrorList wrappedErrorList() {
        return this.m_aErrorList;
    }

    @Override
    protected void internalLog(@Nonnull IErrorLevel iErrorLevel, SAXParseException sAXParseException) {
        this.m_aErrorList.add((Object)WrappedCollectingSAXErrorHandler.getSaxParseError(iErrorLevel, sAXParseException));
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("ErrorList", (Object)this.m_aErrorList).getToString();
    }
}

