/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.xml.XMLHelper;
import com.helger.xml.microdom.AbstractMicroNode;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroCDATA;
import com.helger.xml.microdom.MicroComment;
import com.helger.xml.microdom.MicroContainer;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.MicroDocumentType;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroEntityReference;
import com.helger.xml.microdom.MicroProcessingInstruction;
import com.helger.xml.microdom.MicroText;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

@Immutable
public final class MicroHelper {
    private static final MicroHelper s_aInstance = new MicroHelper();

    private MicroHelper() {
    }

    @Nonnull
    public static IMicroNode append(@Nonnull IMicroNode iMicroNode, @Nullable Object object) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"SrcNode");
        if (object != null) {
            if (object instanceof IMicroNode) {
                iMicroNode.appendChild((IMicroNode)object);
            } else if (object instanceof String) {
                iMicroNode.appendText((String)object);
            } else if (object instanceof Iterable) {
                for (Object t : (Iterable)object) {
                    MicroHelper.append(iMicroNode, t);
                }
            } else if (ArrayHelper.isArray((Object)object)) {
                for (Object object2 : (Object[])object) {
                    MicroHelper.append(iMicroNode, object2);
                }
            } else {
                throw new IllegalArgumentException("Passed object cannot be appended to an IMicroNode (type=" + object.getClass().getName() + ".");
            }
        }
        return iMicroNode;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public static String getPath(@Nullable IMicroNode iMicroNode, @Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Separator");
        StringBuilder stringBuilder = new StringBuilder();
        for (IMicroNode iMicroNode2 = iMicroNode; iMicroNode2 != null; iMicroNode2 = iMicroNode2.getParent()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, string);
            }
            stringBuilder.insert(0, iMicroNode2.getNodeName());
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static String getDocumentRootElementTagName(@Nullable IMicroDocument iMicroDocument) {
        IMicroElement iMicroElement;
        if (iMicroDocument != null && (iMicroElement = iMicroDocument.getDocumentElement()) != null) {
            return iMicroElement.getTagName();
        }
        return null;
    }

    @Nonnull
    public static IMicroNode convertToMicroNode(@Nonnull Node node) {
        Object object;
        AbstractMicroNode abstractMicroNode;
        ValueEnforcer.notNull((Object)node, (String)"Node");
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                abstractMicroNode = new MicroDocument();
                break;
            }
            case 10: {
                object = (DocumentType)node;
                abstractMicroNode = new MicroDocumentType(object.getName(), object.getPublicId(), object.getSystemId());
                break;
            }
            case 1: {
                object = (Element)node;
                String string = object.getNamespaceURI();
                MicroElement microElement = string != null ? new MicroElement(string, object.getLocalName()) : new MicroElement(object.getTagName());
                XMLHelper.forAllAttributes((Element)object, attr -> {
                    String string = attr.getNamespaceURI();
                    if (string != null) {
                        if (!"http://www.w3.org/2000/xmlns/".equals(string)) {
                            microElement.setAttribute(string, attr.getLocalName(), attr.getValue());
                        }
                    } else {
                        microElement.setAttribute(attr.getName(), attr.getValue());
                    }
                });
                abstractMicroNode = microElement;
                break;
            }
            case 4: {
                abstractMicroNode = new MicroCDATA(node.getNodeValue());
                break;
            }
            case 3: {
                abstractMicroNode = new MicroText(node.getNodeValue());
                break;
            }
            case 8: {
                abstractMicroNode = new MicroComment(node.getNodeValue());
                break;
            }
            case 5: {
                abstractMicroNode = new MicroEntityReference(node.getNodeValue());
                break;
            }
            case 7: {
                object = (ProcessingInstruction)node;
                abstractMicroNode = new MicroProcessingInstruction(object.getTarget(), object.getData());
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Unknown/unsupported node type: ATTRIBUTE_NODE");
            }
            case 6: {
                throw new IllegalArgumentException("Unknown/unsupported node type: ENTITY_NODE");
            }
            case 11: {
                throw new IllegalArgumentException("Unknown/unsupported node type: DOCUMENT_FRAGMENT_NODE");
            }
            case 12: {
                throw new IllegalArgumentException("Unknown/unsupported node type: NOTATION_NODE");
            }
            default: {
                throw new IllegalArgumentException("Unknown/unsupported node type: " + s);
            }
        }
        object = node.getChildNodes();
        if (object != null) {
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = object.item(i);
                abstractMicroNode.appendChild(MicroHelper.convertToMicroNode(node2));
            }
        }
        return abstractMicroNode;
    }

    @Nullable
    public static String getChildTextContent(@Nonnull IMicroElement iMicroElement, @Nonnull String string) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string);
        return iMicroElement2 != null ? iMicroElement2.getTextContent() : null;
    }

    @Nullable
    public static String getChildTextContentTrimmed(@Nonnull IMicroElement iMicroElement, @Nonnull String string) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string);
        return iMicroElement2 != null ? iMicroElement2.getTextContentTrimmed() : null;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE getChildTextContentWithConversion(@Nonnull IMicroElement iMicroElement, @Nonnull String string, @Nonnull Class<DSTTYPE> clazz) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string);
        return iMicroElement2 != null ? (DSTTYPE)iMicroElement2.getTextContentWithConversion(clazz) : null;
    }

    @Nullable
    public static String getChildTextContent(@Nonnull IMicroElement iMicroElement, @Nonnull String string, @Nonnull String string2) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string, string2);
        return iMicroElement2 != null ? iMicroElement2.getTextContent() : null;
    }

    @Nullable
    public static String getChildTextContentTrimmed(@Nonnull IMicroElement iMicroElement, @Nonnull String string, @Nonnull String string2) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string, string2);
        return iMicroElement2 != null ? iMicroElement2.getTextContentTrimmed() : null;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE getChildTextContentWithConversion(@Nonnull IMicroElement iMicroElement, @Nonnull String string, @Nonnull String string2, @Nonnull Class<DSTTYPE> clazz) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string, string2);
        return iMicroElement2 != null ? (DSTTYPE)iMicroElement2.getTextContentWithConversion(clazz) : null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static IMicroContainer getAllChildrenAsContainer(@Nonnull IMicroNode iMicroNode2) {
        MicroContainer microContainer = new MicroContainer();
        iMicroNode2.forAllChildren(iMicroNode -> microContainer.appendChild((IMicroNode)iMicroNode.getClone()));
        return microContainer;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static IMicroContainer getAllOriginalChildrenAsContainer(@Nonnull IMicroNode iMicroNode2) {
        MicroContainer microContainer = new MicroContainer();
        iMicroNode2.forAllChildren(iMicroNode -> microContainer.appendChild(iMicroNode.detachFromParent()));
        return microContainer;
    }
}

