/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsEnumMap;
import com.helger.commons.collection.ext.CommonsLinkedHashSet;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.collection.ext.ICommonsOrderedSet;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.xml.microdom.AbstractMicroNodeWithChildren;
import com.helger.xml.microdom.EMicroEvent;
import com.helger.xml.microdom.IMicroCDATA;
import com.helger.xml.microdom.IMicroComment;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroDocumentType;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroEntityReference;
import com.helger.xml.microdom.IMicroEvent;
import com.helger.xml.microdom.IMicroEventTarget;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroProcessingInstruction;
import com.helger.xml.microdom.IMicroText;
import com.helger.xml.microdom.MicroCDATA;
import com.helger.xml.microdom.MicroComment;
import com.helger.xml.microdom.MicroContainer;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroEntityReference;
import com.helger.xml.microdom.MicroEvent;
import com.helger.xml.microdom.MicroException;
import com.helger.xml.microdom.MicroProcessingInstruction;
import com.helger.xml.microdom.MicroText;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractMicroNode
implements IMicroNode {
    private AbstractMicroNodeWithChildren m_aParentNode;
    private CommonsEnumMap<EMicroEvent, ICommonsOrderedSet<IMicroEventTarget>> m_aEventTargets;

    @OverrideOnDemand
    protected void onAppendChild(@Nonnull AbstractMicroNode abstractMicroNode) {
        throw new MicroException("Cannot append children in class " + this.getClass().getName());
    }

    @OverrideOnDemand
    protected void onInsertBefore(@Nonnull AbstractMicroNode abstractMicroNode, @Nonnull IMicroNode iMicroNode) {
        throw new MicroException("Cannot insert children in class " + this.getClass().getName());
    }

    @OverrideOnDemand
    protected void onInsertAfter(@Nonnull AbstractMicroNode abstractMicroNode, @Nonnull IMicroNode iMicroNode) {
        throw new MicroException("Cannot insert children in class " + this.getClass().getName());
    }

    @OverrideOnDemand
    protected void onInsertAtIndex(@Nonnegative int n, @Nonnull AbstractMicroNode abstractMicroNode) {
        throw new MicroException("Cannot insert children in class " + this.getClass().getName());
    }

    @Override
    @Nullable
    public final <NODETYPE extends IMicroNode> NODETYPE appendChild(@Nullable NODETYPE NODETYPE) {
        if (NODETYPE != null) {
            this.onAppendChild((AbstractMicroNode)NODETYPE);
        }
        return NODETYPE;
    }

    @Override
    @Nullable
    public final <NODETYPE extends IMicroNode> NODETYPE insertBefore(@Nullable NODETYPE NODETYPE, @Nonnull IMicroNode iMicroNode) {
        if (NODETYPE != null) {
            this.onInsertBefore((AbstractMicroNode)NODETYPE, iMicroNode);
        }
        return NODETYPE;
    }

    @Override
    @Nullable
    public final <NODETYPE extends IMicroNode> NODETYPE insertAfter(@Nullable NODETYPE NODETYPE, @Nonnull IMicroNode iMicroNode) {
        if (NODETYPE != null) {
            this.onInsertAfter((AbstractMicroNode)NODETYPE, iMicroNode);
        }
        return NODETYPE;
    }

    @Override
    @Nullable
    public final <NODETYPE extends IMicroNode> NODETYPE insertAtIndex(@Nonnegative int n, @Nullable NODETYPE NODETYPE) {
        if (NODETYPE != null) {
            this.onInsertAtIndex(n, (AbstractMicroNode)NODETYPE);
        }
        return NODETYPE;
    }

    @Override
    @Nonnull
    public final IMicroText appendText(@Nullable CharSequence charSequence) {
        MicroText microText = new MicroText(charSequence, false);
        this.onAppendChild(microText);
        return microText;
    }

    @Override
    @Nonnull
    public final IMicroText appendText(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        MicroText microText = new MicroText(cArray, n, n2, false);
        this.onAppendChild(microText);
        return microText;
    }

    @Override
    @Nonnull
    public final IMicroText appendTextWithConversion(@Nullable Object object) {
        String string = (String)TypeConverter.convertIfNecessary((Object)object, String.class);
        return this.appendText(string);
    }

    @Override
    @Nonnull
    public final IMicroText appendIgnorableWhitespaceText(@Nullable CharSequence charSequence) {
        MicroText microText = new MicroText(charSequence, true);
        this.onAppendChild(microText);
        return microText;
    }

    @Override
    @Nonnull
    public final IMicroText appendIgnorableWhitespaceText(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        MicroText microText = new MicroText(cArray, n, n2, true);
        this.onAppendChild(microText);
        return microText;
    }

    @Override
    @Nonnull
    public final IMicroCDATA appendCDATA(@Nullable CharSequence charSequence) {
        MicroCDATA microCDATA = new MicroCDATA(charSequence);
        this.onAppendChild(microCDATA);
        return microCDATA;
    }

    @Override
    @Nonnull
    public final IMicroCDATA appendCDATA(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        MicroCDATA microCDATA = new MicroCDATA(cArray, n, n2);
        this.onAppendChild(microCDATA);
        return microCDATA;
    }

    @Override
    @Nonnull
    public final IMicroCDATA appendCDATAWithConversion(@Nullable Object object) {
        String string = (String)TypeConverter.convertIfNecessary((Object)object, String.class);
        return this.appendCDATA(string);
    }

    @Override
    @Nonnull
    public final IMicroComment appendComment(@Nullable CharSequence charSequence) {
        MicroComment microComment = new MicroComment(charSequence);
        this.onAppendChild(microComment);
        return microComment;
    }

    @Override
    @Nonnull
    public final IMicroComment appendComment(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        MicroComment microComment = new MicroComment(cArray, n, n2);
        this.onAppendChild(microComment);
        return microComment;
    }

    @Override
    @Nonnull
    public final IMicroComment appendCommentWithConversion(@Nullable Object object) {
        String string = (String)TypeConverter.convertIfNecessary((Object)object, String.class);
        return this.appendComment(string);
    }

    @Override
    @Nonnull
    public final IMicroEntityReference appendEntityReference(@Nonnull @Nonempty String string) {
        MicroEntityReference microEntityReference = new MicroEntityReference(string);
        this.onAppendChild(microEntityReference);
        return microEntityReference;
    }

    @Override
    @Nonnull
    public final IMicroElement appendElement(@Nonnull @Nonempty String string) {
        return this.appendElement(null, string);
    }

    @Override
    @Nonnull
    public final IMicroElement appendElement(@Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        this.onAppendChild(microElement);
        return microElement;
    }

    @Override
    @Nonnull
    public final IMicroProcessingInstruction appendProcessingInstruction(@Nonnull @Nonempty String string, @Nullable String string2) {
        MicroProcessingInstruction microProcessingInstruction = new MicroProcessingInstruction(string, string2);
        this.onAppendChild(microProcessingInstruction);
        return microProcessingInstruction;
    }

    @Override
    @Nonnull
    public final IMicroContainer appendContainer() {
        MicroContainer microContainer = new MicroContainer();
        this.onAppendChild(microContainer);
        return microContainer;
    }

    @Nonnull
    @OverrideOnDemand
    protected EChange onRemoveChild(IMicroNode iMicroNode) {
        throw new MicroException("Cannot remove child from this node: " + this.getClass().getName());
    }

    @Override
    @Nonnull
    public final EChange removeChild(@Nonnull IMicroNode iMicroNode) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"Child");
        return this.onRemoveChild(iMicroNode);
    }

    @Nonnull
    @OverrideOnDemand
    protected EChange onRemoveChildAtIndex(int n) {
        throw new MicroException("Cannot remove child from this node: " + this.getClass().getName());
    }

    @Override
    @Nonnull
    public final EChange removeChildAtIndex(@Nonnegative int n) {
        return this.onRemoveChildAtIndex(n);
    }

    @Nonnull
    @OverrideOnDemand
    protected EChange onRemoveAllChildren() {
        throw new MicroException("Cannot remove all children from this node: " + this.getClass().getName());
    }

    @Override
    @Nonnull
    public final EChange removeAllChildren() {
        return this.onRemoveAllChildren();
    }

    @Override
    @Nonnull
    public final EChange replaceChild(@Nonnull IMicroNode iMicroNode, @Nonnull IMicroNode iMicroNode2) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"OldChild");
        ValueEnforcer.notNull((Object)iMicroNode2, (String)"NewChild");
        if (iMicroNode.equals(iMicroNode2)) {
            return EChange.UNCHANGED;
        }
        this.insertBefore(iMicroNode2, iMicroNode);
        this.removeChild(iMicroNode);
        return EChange.CHANGED;
    }

    @OverrideOnDemand
    public boolean hasChildren() {
        return false;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public ICommonsList<IMicroNode> getAllChildren() {
        return null;
    }

    public void forAllChildren(@Nonnull Consumer<? super IMicroNode> consumer) {
    }

    @Nonnull
    public EContinue forAllChildrenBreakable(@Nonnull Function<? super IMicroNode, EContinue> function) {
        return EContinue.CONTINUE;
    }

    public void forAllChildren(@Nonnull Predicate<? super IMicroNode> predicate, @Nonnull Consumer<? super IMicroNode> consumer) {
    }

    public <DSTTYPE> void forAllChildrenMapped(@Nonnull Predicate<? super IMicroNode> predicate, @Nonnull Function<? super IMicroNode, ? extends DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
    }

    @Nullable
    @OverrideOnDemand
    public IMicroNode getChildAtIndex(@Nonnegative int n) {
        return null;
    }

    @Nonnegative
    @OverrideOnDemand
    public int getChildCount() {
        return 0;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public IMicroNode getFirstChild() {
        return null;
    }

    @Nullable
    public IMicroNode findFirstChild(@Nonnull Predicate<? super IMicroNode> predicate) {
        return null;
    }

    @Nullable
    public <DSTTYPE> DSTTYPE findFirstChildMapped(@Nonnull Predicate<? super IMicroNode> predicate, @Nonnull Function<? super IMicroNode, ? extends DSTTYPE> function) {
        return null;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public IMicroNode getLastChild() {
        return null;
    }

    @Override
    @Nullable
    public final IMicroNode getPreviousSibling() {
        if (this.m_aParentNode == null) {
            return null;
        }
        ICommonsList<IMicroNode> iCommonsList = this.m_aParentNode.directGetAllChildren();
        int n = iCommonsList.indexOf((Object)this);
        if (n == -1) {
            throw new IllegalStateException("this is no part of it's parents children");
        }
        return (IMicroNode)iCommonsList.getAtIndex(n - 1);
    }

    @Override
    @Nullable
    public final IMicroNode getNextSibling() {
        if (this.m_aParentNode == null) {
            return null;
        }
        ICommonsList<IMicroNode> iCommonsList = this.m_aParentNode.directGetAllChildren();
        int n = iCommonsList.indexOf((Object)this);
        if (n == -1) {
            throw new IllegalStateException("this is no part of it's parents children");
        }
        return (IMicroNode)iCommonsList.getAtIndex(n + 1);
    }

    @Override
    public final boolean hasParent() {
        return this.m_aParentNode != null;
    }

    @Override
    @Nullable
    public final IMicroNode getParent() {
        return this.m_aParentNode;
    }

    protected final void internalResetParentNode() {
        this.m_aParentNode = null;
    }

    protected final void internalSetParentNode(@Nonnull AbstractMicroNodeWithChildren abstractMicroNodeWithChildren) {
        if (abstractMicroNodeWithChildren == null) {
            throw new MicroException("No parent node passed!");
        }
        if (abstractMicroNodeWithChildren == this) {
            throw new MicroException("Node cannot have itself as parent: " + this.toString());
        }
        if (this.m_aParentNode != null) {
            throw new MicroException("Node already has a parent: " + this.toString());
        }
        this.m_aParentNode = abstractMicroNodeWithChildren;
    }

    @Override
    @Nonnull
    public final IMicroNode detachFromParent() {
        if (this.m_aParentNode != null) {
            if (this.m_aParentNode.removeChild(this).isUnchanged()) {
                throw new IllegalStateException("Failed to remove this from parents child list");
            }
            this.internalResetParentNode();
        }
        return this;
    }

    @Override
    @Nullable
    public final IMicroElement getParentElementWithName(@Nullable String string) {
        for (IMicroNode iMicroNode = this.m_aParentNode; iMicroNode != null && iMicroNode.isElement(); iMicroNode = iMicroNode.getParent()) {
            IMicroElement iMicroElement = (IMicroElement)iMicroNode;
            if (!iMicroElement.getTagName().equals(string)) continue;
            return iMicroElement;
        }
        return null;
    }

    @Override
    @Nullable
    public final IMicroElement getParentElementWithName(@Nullable String string, @Nullable String string2) {
        for (IMicroNode iMicroNode = this.m_aParentNode; iMicroNode != null && iMicroNode.isElement(); iMicroNode = iMicroNode.getParent()) {
            IMicroElement iMicroElement = (IMicroElement)iMicroNode;
            if (!iMicroElement.hasNamespaceURI(string) || !iMicroElement.getTagName().equals(string2)) continue;
            return iMicroElement;
        }
        return null;
    }

    @Override
    public final boolean isDocument() {
        return this instanceof IMicroDocument;
    }

    @Override
    public final boolean isDocumentType() {
        return this instanceof IMicroDocumentType;
    }

    @Override
    public final boolean isText() {
        return this instanceof IMicroText;
    }

    @Override
    public final boolean isCDATA() {
        return this instanceof IMicroCDATA;
    }

    @Override
    public final boolean isComment() {
        return this instanceof IMicroComment;
    }

    @Override
    public final boolean isEntityReference() {
        return this instanceof IMicroEntityReference;
    }

    @Override
    public final boolean isElement() {
        return this instanceof IMicroElement;
    }

    @Override
    public final boolean isProcessingInstruction() {
        return this instanceof IMicroProcessingInstruction;
    }

    @Override
    public final boolean isContainer() {
        return this instanceof IMicroContainer;
    }

    protected final void internalTriggerEvent(@Nonnull EMicroEvent eMicroEvent, @Nonnull IMicroEvent iMicroEvent) {
        ICommonsSet iCommonsSet;
        if (this.m_aEventTargets != null && this.m_aEventTargets.isNotEmpty() && (iCommonsSet = (ICommonsSet)this.m_aEventTargets.get((Object)eMicroEvent)) != null && iCommonsSet.isNotEmpty()) {
            for (IMicroEventTarget iMicroEventTarget : iCommonsSet) {
                iMicroEventTarget.handleEvent(iMicroEvent);
            }
        }
        if (this.m_aParentNode != null) {
            this.m_aParentNode.internalTriggerEvent(eMicroEvent, iMicroEvent);
        }
    }

    protected final void onEvent(@Nonnull EMicroEvent eMicroEvent, @Nonnull IMicroNode iMicroNode, @Nonnull IMicroNode iMicroNode2) {
        this.internalTriggerEvent(eMicroEvent, new MicroEvent(eMicroEvent, iMicroNode, iMicroNode2));
    }

    @Override
    @Nonnull
    public EChange registerEventTarget(@Nonnull EMicroEvent eMicroEvent2, @Nonnull IMicroEventTarget iMicroEventTarget) {
        ValueEnforcer.notNull((Object)((Object)eMicroEvent2), (String)"EventType");
        ValueEnforcer.notNull((Object)iMicroEventTarget, (String)"EventTarget");
        if (this.m_aEventTargets == null) {
            this.m_aEventTargets = new CommonsEnumMap(EMicroEvent.class);
        }
        ICommonsOrderedSet iCommonsOrderedSet = (ICommonsOrderedSet)this.m_aEventTargets.computeIfAbsent((Object)eMicroEvent2, eMicroEvent -> new CommonsLinkedHashSet());
        return iCommonsOrderedSet.addObject((Object)iMicroEventTarget);
    }

    @Override
    @Nonnull
    public EChange unregisterEventTarget(@Nonnull EMicroEvent eMicroEvent, @Nonnull IMicroEventTarget iMicroEventTarget) {
        ICommonsSet iCommonsSet;
        ValueEnforcer.notNull((Object)((Object)eMicroEvent), (String)"EventType");
        ValueEnforcer.notNull((Object)iMicroEventTarget, (String)"EventTarget");
        if (this.m_aEventTargets != null && this.m_aEventTargets.isNotEmpty() && (iCommonsSet = (ICommonsSet)this.m_aEventTargets.get((Object)eMicroEvent)) != null && !iCommonsSet.isEmpty()) {
            return iCommonsSet.removeObject((Object)iMicroEventTarget);
        }
        return EChange.UNCHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<EMicroEvent, ICommonsSet<IMicroEventTarget>> getAllEventTargets() {
        return new CommonsEnumMap(this.m_aEventTargets);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<IMicroEventTarget> getAllEventTargets(@Nullable EMicroEvent eMicroEvent) {
        return new CommonsLinkedHashSet(this.m_aEventTargets == null ? null : (Collection)this.m_aEventTargets.get((Object)eMicroEvent));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("parentNodeName", this.m_aParentNode == null ? null : this.m_aParentNode.getNodeName()).appendIfNotNull("eventTargets", this.m_aEventTargets).getToString();
    }
}

