/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.serialize;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.NonBlockingStringWriter;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.serialize.MicroSerializer;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class MicroWriter {
    private static final Logger s_aLogger = LoggerFactory.getLogger(MicroWriter.class);
    private static final MicroWriter s_aInstance = new MicroWriter();

    private MicroWriter() {
    }

    @Nonnull
    public static ESuccess writeToFile(@Nonnull IMicroNode iMicroNode, @Nonnull File file) {
        return MicroWriter.writeToFile(iMicroNode, file, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    @Nonnull
    public static ESuccess writeToFile(@Nonnull IMicroNode iMicroNode, @Nonnull File file, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        OutputStream outputStream = FileHelper.getOutputStream((File)file);
        if (outputStream == null) {
            return ESuccess.FAILURE;
        }
        return MicroWriter.writeToStream(iMicroNode, outputStream, iXMLWriterSettings);
    }

    @Nonnull
    public static ESuccess writeToStream(@Nonnull IMicroNode iMicroNode, @Nonnull @WillClose OutputStream outputStream) {
        return MicroWriter.writeToStream(iMicroNode, outputStream, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeToStream(@Nonnull IMicroNode iMicroNode, @Nonnull @WillClose OutputStream outputStream, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"Node");
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Settings");
        try {
            MicroSerializer microSerializer = new MicroSerializer(iXMLWriterSettings);
            microSerializer.write(iMicroNode, outputStream);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeToWriter(@Nonnull IMicroNode iMicroNode, @Nonnull @WillClose Writer writer, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"Node");
        ValueEnforcer.notNull((Object)writer, (String)"Writer");
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Settings");
        try {
            MicroSerializer microSerializer = new MicroSerializer(iXMLWriterSettings);
            microSerializer.write(iMicroNode, writer);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)writer);
        }
    }

    @Nonnull
    public static ESuccess writeToWriter(@Nonnull IMicroNode iMicroNode, @Nonnull @WillClose Writer writer) {
        return MicroWriter.writeToWriter(iMicroNode, writer, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getNodeAsString(@Nonnull IMicroNode iMicroNode, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"Node");
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Settings");
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(51200);){
            if (!MicroWriter.writeToWriter(iMicroNode, (Writer)nonBlockingStringWriter, iXMLWriterSettings).isSuccess()) return null;
            String string = nonBlockingStringWriter.getAsString();
            return string;
        }
        catch (Throwable throwable7) {
            s_aLogger.error("Error serializing MicroDOM with settings " + iXMLWriterSettings.toString(), throwable7);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static String getXMLString(@Nonnull IMicroNode iMicroNode) {
        return MicroWriter.getNodeAsString(iMicroNode);
    }

    @Nullable
    public static String getNodeAsString(@Nonnull IMicroNode iMicroNode) {
        return MicroWriter.getNodeAsString(iMicroNode, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static byte[] getNodeAsBytes(@Nonnull IMicroNode iMicroNode, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"Node");
        ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Settings");
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(51200);){
            if (!MicroWriter.writeToStream(iMicroNode, (OutputStream)nonBlockingByteArrayOutputStream, iXMLWriterSettings).isSuccess()) return null;
            byte[] byArray = nonBlockingByteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Throwable throwable7) {
            s_aLogger.error("Error serializing MicroDOM with settings " + iXMLWriterSettings.toString(), throwable7);
        }
        return null;
    }

    @Nullable
    public static byte[] getNodeAsBytes(@Nonnull IMicroNode iMicroNode) {
        return MicroWriter.getNodeAsBytes(iMicroNode, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }
}

