/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.microdom.AbstractMicroNode;
import com.helger.xml.microdom.AbstractMicroNodeWithChildren;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroDocumentType;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MicroDocument
extends AbstractMicroNodeWithChildren
implements IMicroDocument {
    public static final boolean DEFAULT_STANDALONE = false;
    private boolean m_bIsStandalone = false;

    public MicroDocument() {
    }

    public MicroDocument(@Nullable IMicroDocumentType iMicroDocumentType) {
        if (iMicroDocumentType != null) {
            this.appendChild(iMicroDocumentType);
        }
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.DOCUMENT;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    private static boolean _canBeAppendedToDocumentRoot(@Nonnull IMicroNode iMicroNode) {
        return iMicroNode.isDocumentType() || iMicroNode.isProcessingInstruction() || iMicroNode.isComment() || iMicroNode.isElement();
    }

    @Override
    protected void onAppendChild(@Nonnull AbstractMicroNode abstractMicroNode) {
        ICommonsList<IMicroNode> iCommonsList;
        if (!MicroDocument._canBeAppendedToDocumentRoot(abstractMicroNode)) {
            throw new MicroException("Cannot add nodes of type " + abstractMicroNode + " to a document");
        }
        if (abstractMicroNode.isElement() && (iCommonsList = this.directGetAllChildren()) != null && iCommonsList.isNotEmpty()) {
            for (IMicroNode iMicroNode : iCommonsList) {
                if (!iMicroNode.isElement()) continue;
                throw new MicroException("A document can only have one document element! Already has " + iMicroNode + " and wants to add " + abstractMicroNode);
            }
        }
        super.onAppendChild(abstractMicroNode);
    }

    @Override
    public boolean isStandalone() {
        return this.m_bIsStandalone;
    }

    @Override
    public void setStandalone(boolean bl) {
        this.m_bIsStandalone = bl;
    }

    @Override
    @Nullable
    public IMicroDocumentType getDocType() {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetAllChildren()) {
                if (!iMicroNode.isDocumentType()) continue;
                return (IMicroDocumentType)iMicroNode;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IMicroElement getDocumentElement() {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetAllChildren()) {
                if (!iMicroNode.isElement()) continue;
                return (IMicroElement)iMicroNode;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public IMicroDocument getClone() {
        MicroDocument microDocument = new MicroDocument();
        microDocument.setStandalone(this.m_bIsStandalone);
        this.forAllChildren(iMicroNode -> microDocument.appendChild((IMicroNode)iMicroNode.getClone()));
        return microDocument;
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (!super.isEqualContent(iMicroNode)) {
            return false;
        }
        MicroDocument microDocument = (MicroDocument)iMicroNode;
        return this.m_bIsStandalone == microDocument.m_bIsStandalone;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("isStandalone", this.m_bIsStandalone).getToString();
    }
}

