/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.sax.AbstractSAXErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.xml.sax.SAXParseException;

@ThreadSafe
public class CollectingSAXErrorHandler
extends AbstractSAXErrorHandler {
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ErrorList m_aErrors = new ErrorList();

    @Override
    protected void internalLog(@Nonnull IErrorLevel iErrorLevel, SAXParseException sAXParseException) {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.add(CollectingSAXErrorHandler.getSaxParseError(iErrorLevel, sAXParseException)));
    }

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getErrorList() {
        return (IErrorList)this.m_aRWLock.readLocked(() -> this.m_aErrors.getClone());
    }

    public boolean containsAtLeastOneError() {
        return this.m_aRWLock.readLocked(() -> this.m_aErrors.containsAtLeastOneError());
    }

    @Nonnull
    public EChange clearResourceErrors() {
        return (EChange)this.m_aRWLock.writeLocked(() -> this.m_aErrors.clear());
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("errors", (Object)this.m_aErrors).toString();
    }
}

