/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.stream.StreamSource;

@NotThreadSafe
public class CachingTransformStreamSource
extends StreamSource {
    public CachingTransformStreamSource(@Nonnull IReadableResource iReadableResource) {
        this(iReadableResource.getInputStream(), iReadableResource.getResourceID());
    }

    public CachingTransformStreamSource(@Nonnull IHasInputStream iHasInputStream) {
        this(iHasInputStream, null);
    }

    public CachingTransformStreamSource(@Nonnull IHasInputStream iHasInputStream, @Nullable String string) {
        this(iHasInputStream.getInputStream(), string);
    }

    public CachingTransformStreamSource(@Nonnull @WillClose InputStream inputStream) {
        this(inputStream, null);
    }

    public CachingTransformStreamSource(@Nonnull @WillClose InputStream inputStream, @Nullable String string) {
        super((InputStream)new NonBlockingByteArrayInputStream(StreamHelper.getAllBytes((InputStream)inputStream)), string);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("systemID", (Object)this.getSystemId()).toString();
    }
}

