/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.IHasOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class XMLListHandler {
    public static final String ELEMENT_LIST = "list";
    public static final String ELEMENT_ITEM = "item";
    public static final String ATTR_VALUE = "value";
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLListHandler.class);
    private static final XMLListHandler s_aInstance = new XMLListHandler();

    private XMLListHandler() {
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsList<String> readList(@Nonnull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        return XMLListHandler.readList(iHasInputStream.getInputStream());
    }

    @Nonnull
    public static ESuccess readList(@Nonnull IHasInputStream iHasInputStream, @Nonnull Collection<String> collection) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        return XMLListHandler.readList(iHasInputStream.getInputStream(), collection);
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsList<String> readList(@Nonnull @WillClose InputStream inputStream) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (XMLListHandler.readList(inputStream, (Collection<String>)commonsArrayList).isFailure()) {
            return null;
        }
        return commonsArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess readList(@Nonnull @WillClose InputStream inputStream, @Nonnull Collection<String> collection) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        ValueEnforcer.notNull(collection, (String)"TargetList");
        try {
            IMicroDocument iMicroDocument = MicroReader.readMicroXML(inputStream);
            if (iMicroDocument != null) {
                XMLListHandler.readList(iMicroDocument.getDocumentElement(), collection);
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
        }
        catch (Throwable throwable) {
            s_aLogger.warn("Failed to read list resource '" + inputStream + "'", throwable);
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess readList(@Nonnull IMicroElement iMicroElement, @Nonnull Collection<String> collection) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ParentElement");
        ValueEnforcer.notNull(collection, (String)"TargetList");
        try {
            for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_ITEM)) {
                String string = iMicroElement2.getAttributeValue(ATTR_VALUE);
                if (string == null) {
                    s_aLogger.warn("Ignoring list item because value is null");
                    continue;
                }
                if (collection.add(string)) continue;
                s_aLogger.warn("Ignoring list item '" + string + "' because value is already contained");
            }
            return ESuccess.SUCCESS;
        }
        catch (Throwable throwable) {
            s_aLogger.warn("Failed to read list document", throwable);
            return ESuccess.FAILURE;
        }
    }

    @Nonnull
    public static IMicroDocument createListDocument(@Nonnull Collection<String> collection) {
        ValueEnforcer.notNull(collection, (String)"Collection");
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement(ELEMENT_LIST);
        for (String string : collection) {
            IMicroElement iMicroElement2 = iMicroElement.appendElement(ELEMENT_ITEM);
            iMicroElement2.setAttribute(ATTR_VALUE, string);
        }
        return microDocument;
    }

    @Nonnull
    public static ESuccess writeList(@Nonnull Collection<String> collection, @Nonnull IHasOutputStream iHasOutputStream) {
        ValueEnforcer.notNull((Object)iHasOutputStream, (String)"OutputStreamProvider");
        return XMLListHandler.writeList(collection, iHasOutputStream.getOutputStream(EAppend.DEFAULT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeList(@Nonnull Collection<String> collection, @Nonnull @WillClose OutputStream outputStream) {
        ValueEnforcer.notNull(collection, (String)"Collection");
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        try {
            IMicroDocument iMicroDocument = XMLListHandler.createListDocument(collection);
            ESuccess eSuccess = MicroWriter.writeToStream(iMicroDocument, outputStream, XMLWriterSettings.DEFAULT_XML_SETTINGS);
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }
}

