/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.ls;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.lang.IHasClassLoader;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.URLHelper;
import com.helger.xml.ls.AbstractLSResourceResolver;
import com.helger.xml.ls.ResourceLSInput;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;

public class SimpleLSResourceResolver
extends AbstractLSResourceResolver
implements IHasClassLoader {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SimpleLSResourceResolver.class);
    private final ClassLoader m_aClassLoader;

    public SimpleLSResourceResolver() {
        this(null);
    }

    public SimpleLSResourceResolver(@Nullable ClassLoader classLoader) {
        this.m_aClassLoader = classLoader;
    }

    @Nullable
    public ClassLoader getClassLoader() {
        return this.m_aClassLoader;
    }

    @Nonnull
    public static IReadableResource doStandardResourceResolving(@Nullable String string, @Nullable String string2) throws IOException {
        return SimpleLSResourceResolver.doStandardResourceResolving(string, string2, null);
    }

    public static boolean isExplicitJarFileResource(@Nullable String string) {
        return StringHelper.startsWith((String)string, (String)"jar:file:") || StringHelper.startsWith((String)string, (String)"wsjar:file:") || StringHelper.startsWith((String)string, (String)"zip:file:");
    }

    @Nonnull
    private static ClassPathResource _resolveClassPathResource(String string, String string2, ClassLoader classLoader) {
        String string3 = ClassPathResource.getWithoutClassPathPrefix((String)string2);
        File file = new File(string3).getParentFile();
        String string4 = FilenameHelper.getCleanPath((String)(file == null ? string : file.getPath() + '/' + string));
        ClassPathResource classPathResource = new ClassPathResource(string4, classLoader);
        return classPathResource;
    }

    @Nonnull
    private static URLResource _resolveJarFileResource(@Nonnull String string, @Nonnull String string2) throws MalformedURLException {
        File file;
        String string3;
        String string4;
        int n = string2.indexOf("!/");
        if (n < 0) {
            string4 = "";
            string3 = string2;
        } else {
            string4 = string2.substring(0, n + 2);
            string3 = string2.substring(n + 2);
        }
        if (FilenameHelper.startsWithPathSeparatorChar((CharSequence)string3)) {
            string3 = string3.substring(1);
        }
        String string5 = FilenameHelper.getCleanPath((String)((file = new File(string3).getParentFile()) == null ? string : file.getPath() + '/' + string));
        URLResource uRLResource = new URLResource(string4 + string5);
        return uRLResource;
    }

    @Nonnull
    private static URLResource _resolveURLResource(String string, URL uRL) throws MalformedURLException {
        String string2 = uRL.getPath();
        String string3 = FilenameHelper.getWithoutPath((String)string2);
        if (string3 != null && string3.indexOf(46) >= 0) {
            string2 = FilenameHelper.getPath((String)string2);
        }
        String string4 = FilenameHelper.getCleanConcatenatedUrlPath((String)string2, (String)string);
        URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), URLHelper.getURLString((String)string4, (String)uRL.getQuery(), (String)uRL.getRef()));
        URLResource uRLResource = new URLResource(uRL2);
        return uRLResource;
    }

    @Nonnull
    public static IReadableResource doStandardResourceResolving(@Nullable String string, @Nullable String string2, @Nullable ClassLoader classLoader) throws IOException {
        URL uRL;
        if (string == null && string2 == null) {
            throw new IllegalArgumentException("Both systemID and baseURI are null!");
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Trying to resolve resource " + string + " from base " + string2 + (classLoader == null ? "" : " with ClassLoader " + classLoader));
        }
        if ((uRL = URLHelper.getAsURL((String)string)) != null && !uRL.getProtocol().equals("file")) {
            URLResource uRLResource = new URLResource(uRL);
            return uRLResource;
        }
        if (ClassPathResource.isExplicitClassPathResource((String)string2)) {
            return SimpleLSResourceResolver._resolveClassPathResource(string, string2, classLoader);
        }
        if (SimpleLSResourceResolver.isExplicitJarFileResource(string2)) {
            return SimpleLSResourceResolver._resolveJarFileResource(string, string2);
        }
        URL uRL2 = URLHelper.getAsURL((String)string2);
        if (uRL2 != null && !uRL2.getProtocol().equals("file")) {
            return SimpleLSResourceResolver._resolveURLResource(string, uRL2);
        }
        File file = uRL2 != null ? URLHelper.getAsFile((URL)uRL2) : new File(string2);
        if (StringHelper.hasNoText((String)string)) {
            FileSystemResource fileSystemResource = new FileSystemResource(file);
            return fileSystemResource;
        }
        File file2 = uRL != null ? URLHelper.getAsFile((URL)uRL) : new File(string);
        if (file2.isAbsolute()) {
            FileSystemResource fileSystemResource = new FileSystemResource(file2);
            return fileSystemResource;
        }
        File file3 = file.getParentFile();
        File file4 = new File(file3, file2.getPath());
        FileSystemResource fileSystemResource = new FileSystemResource(file4);
        return fileSystemResource;
    }

    @Nullable
    @OverrideOnDemand
    protected IReadableResource internalResolveResource(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5) throws Exception {
        return SimpleLSResourceResolver.doStandardResourceResolving(string4, string5, this.m_aClassLoader);
    }

    @Override
    @Nullable
    public final LSInput mainResolveResource(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5) {
        try {
            IReadableResource iReadableResource = this.internalResolveResource(string, string2, string3, string4, string5);
            if (iReadableResource != null) {
                return new ResourceLSInput(iReadableResource);
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to resolve resource '" + string + "', '" + string2 + "', '" + string3 + "', '" + string4 + "', '" + string5 + "'", exception);
        }
        return null;
    }
}

