/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.string.ToStringGenerator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListIterator
implements IIterableIterator<Node> {
    private final NodeList m_aNL;
    private int m_nIndex = 0;
    private final int m_nMax;

    public NodeListIterator(@Nullable NodeList nodeList) {
        this.m_aNL = nodeList;
        this.m_nMax = nodeList == null ? 0 : nodeList.getLength();
    }

    public boolean hasNext() {
        return this.m_nIndex < this.m_nMax;
    }

    @Nullable
    public Node next() {
        if (this.m_nIndex >= this.m_nMax) {
            throw new NoSuchElementException();
        }
        Node node = this.m_aNL.item(this.m_nIndex);
        ++this.m_nIndex;
        return node;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("NodeList", (Object)this.m_aNL).append("Max", this.m_nMax).append("Index", this.m_nIndex).toString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NodeListIterator createChildNodeIterator(@Nullable Node node) {
        return new NodeListIterator(node == null ? null : node.getChildNodes());
    }
}

