/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.location.ErrorLocation;
import com.helger.commons.error.location.IErrorLocation;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.IMultilingualText;
import com.helger.xml.transform.EXMLTransformTexts;
import com.helger.xml.transform.ITransformErrorListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;

public abstract class AbstractTransformErrorListener
implements ITransformErrorListener {
    private final ErrorListener m_aWrappedErrorListener;

    public AbstractTransformErrorListener() {
        this.m_aWrappedErrorListener = null;
    }

    @Deprecated
    public AbstractTransformErrorListener(@Nullable ErrorListener errorListener) {
        this.m_aWrappedErrorListener = errorListener;
    }

    @Nullable
    @Deprecated
    public ErrorListener getWrappedErrorListener() {
        return this.m_aWrappedErrorListener;
    }

    @Nonnull
    private static IError _buildError(@Nonnull TransformerException transformerException, @Nonnull IErrorLevel iErrorLevel, @Nonnull IMultilingualText iMultilingualText) {
        SourceLocator sourceLocator = transformerException.getLocator();
        ErrorLocation errorLocation = sourceLocator != null ? new ErrorLocation(StringHelper.getConcatenatedOnDemand((String)sourceLocator.getPublicId(), (String)"/", (String)sourceLocator.getSystemId()), sourceLocator.getLineNumber(), sourceLocator.getColumnNumber()) : null;
        return ((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builder().setErrorLevel(iErrorLevel)).setErrorLocation((IErrorLocation)errorLocation)).setErrorText(iMultilingualText)).setLinkedException((Throwable)transformerException)).build();
    }

    protected abstract void internalLog(@Nonnull IError var1);

    @Override
    public final void warning(@Nonnull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, (IErrorLevel)EErrorLevel.WARN, EXMLTransformTexts.TRANSFORMATION_WARNING.getAsMLT()));
        ErrorListener errorListener = this.getWrappedErrorListener();
        if (errorListener != null) {
            errorListener.warning(transformerException);
        }
    }

    @Override
    public final void error(@Nonnull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, (IErrorLevel)EErrorLevel.ERROR, EXMLTransformTexts.TRANSFORMATION_ERROR.getAsMLT()));
        ErrorListener errorListener = this.getWrappedErrorListener();
        if (errorListener != null) {
            errorListener.error(transformerException);
        }
    }

    @Override
    public final void fatalError(@Nonnull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, (IErrorLevel)EErrorLevel.FATAL_ERROR, EXMLTransformTexts.TRANSFORMATION_FATAL_ERROR.getAsMLT()));
        ErrorListener errorListener = this.getWrappedErrorListener();
        if (errorListener != null) {
            errorListener.fatalError(transformerException);
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("wrappedErrorListener", (Object)this.m_aWrappedErrorListener).toString();
    }
}

