/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.namespace;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.CommonsLinkedHashMap;
import com.helger.commons.collection.ext.ICommonsOrderedMap;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.collection.multimap.MultiHashMapHashSetBased;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.namespace.AbstractNamespaceContext;
import com.helger.xml.namespace.IIterableNamespaceContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MapBasedNamespaceContext
extends AbstractNamespaceContext
implements ICloneable<MapBasedNamespaceContext> {
    private String m_sDefaultNamespaceURI;
    private final ICommonsOrderedMap<String, String> m_aPrefix2NS = new CommonsLinkedHashMap();
    private final MultiHashMapHashSetBased<String, String> m_aNS2Prefix = new MultiHashMapHashSetBased();

    public MapBasedNamespaceContext() {
    }

    public MapBasedNamespaceContext(@Nullable MapBasedNamespaceContext mapBasedNamespaceContext) {
        if (mapBasedNamespaceContext != null) {
            this.m_sDefaultNamespaceURI = mapBasedNamespaceContext.m_sDefaultNamespaceURI;
            this.m_aPrefix2NS.putAll(mapBasedNamespaceContext.m_aPrefix2NS);
            this.m_aNS2Prefix.putAll(mapBasedNamespaceContext.m_aNS2Prefix);
        }
    }

    public MapBasedNamespaceContext(@Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        this.addMappings(iIterableNamespaceContext);
    }

    @Override
    @Nullable
    public String getDefaultNamespaceURI() {
        return this.m_sDefaultNamespaceURI;
    }

    @Nonnull
    public MapBasedNamespaceContext setDefaultNamespaceURI(@Nonnull String string) {
        return this.addMapping("", string);
    }

    @Nonnull
    private MapBasedNamespaceContext _addMapping(@Nonnull String string, @Nonnull String string2, boolean bl) {
        ValueEnforcer.notNull((Object)string, (String)"Prefix");
        ValueEnforcer.notNull((Object)string2, (String)"NamespaceURI");
        if (!bl && this.m_aPrefix2NS.containsKey((Object)string)) {
            throw new IllegalArgumentException("The prefix '" + string + "' is already registered!");
        }
        if (string.equals("")) {
            this.m_sDefaultNamespaceURI = string2;
        }
        this.m_aPrefix2NS.put((Object)string, (Object)string2);
        this.m_aNS2Prefix.putSingle((Object)string2, (Object)string);
        return this;
    }

    @Nonnull
    public final MapBasedNamespaceContext addMapping(@Nonnull String string, @Nonnull String string2) {
        return this._addMapping(string, string2, false);
    }

    @Nonnull
    public final MapBasedNamespaceContext setMapping(@Nonnull String string, @Nonnull String string2) {
        return this._addMapping(string, string2, true);
    }

    @Nonnull
    public final MapBasedNamespaceContext addMappings(@Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        if (iIterableNamespaceContext != null) {
            for (Map.Entry entry : iIterableNamespaceContext.getPrefixToNamespaceURIMap().entrySet()) {
                this.addMapping((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return this;
    }

    @Nonnull
    public final MapBasedNamespaceContext setMappings(@Nullable IIterableNamespaceContext iIterableNamespaceContext) {
        if (iIterableNamespaceContext != null) {
            for (Map.Entry entry : iIterableNamespaceContext.getPrefixToNamespaceURIMap().entrySet()) {
                this.setMapping((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return this;
    }

    @Nonnull
    public EChange removeMapping(@Nullable String string) {
        String string2 = (String)this.m_aPrefix2NS.remove((Object)string);
        if (string2 == null) {
            return EChange.UNCHANGED;
        }
        if (this.m_aNS2Prefix.removeSingle((Object)string2, (Object)string).isUnchanged()) {
            throw new IllegalStateException("Internal inconsistency removing '" + string + "' and '" + string2 + "'");
        }
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange clear() {
        if (this.m_aPrefix2NS.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aPrefix2NS.clear();
        this.m_aNS2Prefix.clear();
        this.m_sDefaultNamespaceURI = null;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public Iterator<String> getCustomPrefixes(@Nonnull String string) {
        ICommonsSet iCommonsSet = (ICommonsSet)this.m_aNS2Prefix.get((Object)string);
        return iCommonsSet == null ? null : iCommonsSet.iterator();
    }

    @Override
    @Nullable
    public String getCustomPrefix(@Nonnull String string) {
        ICommonsSet iCommonsSet = (ICommonsSet)this.m_aNS2Prefix.get((Object)string);
        return (String)CollectionHelper.getFirstElement((Collection)iCommonsSet);
    }

    @Override
    @Nullable
    public String getCustomNamespaceURI(@Nonnull String string) {
        return (String)this.m_aPrefix2NS.get((Object)string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getPrefixToNamespaceURIMap() {
        return this.m_aPrefix2NS.getClone();
    }

    public boolean hasAnyMapping() {
        return this.m_aPrefix2NS.isNotEmpty();
    }

    @Nonnegative
    public int getMappingCount() {
        return this.m_aPrefix2NS.size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public MapBasedNamespaceContext getClone() {
        return new MapBasedNamespaceContext(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedNamespaceContext mapBasedNamespaceContext = (MapBasedNamespaceContext)object;
        return EqualsHelper.equals((Object)this.m_sDefaultNamespaceURI, (Object)mapBasedNamespaceContext.m_sDefaultNamespaceURI) && this.m_aPrefix2NS.equals(mapBasedNamespaceContext.m_aPrefix2NS) && this.m_aNS2Prefix.equals(mapBasedNamespaceContext.m_aNS2Prefix);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sDefaultNamespaceURI).append(this.m_aPrefix2NS).append(this.m_aNS2Prefix).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("defaultNS", (Object)this.m_sDefaultNamespaceURI).append("prefix2NS", this.m_aPrefix2NS).append("ns2Prefix2", this.m_aNS2Prefix).toString();
    }
}

