/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.CommonsLinkedHashMap;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsOrderedMap;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.filter.IFilter;
import com.helger.commons.string.StringHelper;
import com.helger.xml.CXML;
import com.helger.xml.ChildElementIterator;
import com.helger.xml.NamedNodeMapIterator;
import com.helger.xml.NodeListIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Immutable
public final class XMLHelper {
    private static final XMLHelper s_aInstance = new XMLHelper();

    private XMLHelper() {
    }

    @Nullable
    public static Document getOwnerDocument(@Nullable Node node) {
        return node == null ? null : (node instanceof Document ? (Document)node : node.getOwnerDocument());
    }

    @Nullable
    public static Element getDocumentElement(@Nullable Node node) {
        Document document = XMLHelper.getOwnerDocument(node);
        return document == null ? null : document.getDocumentElement();
    }

    @Nullable
    public static String getNamespaceURI(@Nullable Node node) {
        if (node instanceof Document) {
            return XMLHelper.getNamespaceURI(((Document)node).getDocumentElement());
        }
        if (node != null) {
            return node.getNamespaceURI();
        }
        return null;
    }

    @Nullable
    public static String getElementName(@Nullable Node node) {
        if (node instanceof Document) {
            return XMLHelper.getElementName(((Document)node).getDocumentElement());
        }
        if (node instanceof Element) {
            String string = node.getLocalName();
            if (string == null) {
                string = ((Element)node).getTagName();
            }
            return string;
        }
        return null;
    }

    public static boolean hasNoNamespaceURI(@Nonnull Node node) {
        return StringHelper.hasNoText((String)node.getNamespaceURI());
    }

    public static boolean hasNamespaceURI(@Nullable Node node, @Nullable String string) {
        String string2 = node == null ? null : node.getNamespaceURI();
        return string2 != null && string2.equals(string);
    }

    public static boolean isInlineNode(@Nullable Node node) {
        return node instanceof Text || node instanceof EntityReference;
    }

    @Nonnegative
    public static int getLength(@Nullable NodeList nodeList) {
        return nodeList == null ? 0 : nodeList.getLength();
    }

    public static boolean isEmpty(@Nullable NodeList nodeList) {
        return nodeList == null ? true : nodeList.getLength() == 0;
    }

    @Nonnull
    public static IFilter<Node> filterNodeIsElement() {
        return (IFilter & Serializable)node -> node != null && node.getNodeType() == 1;
    }

    @Nonnull
    public static IFilter<Element> filterElementWithNamespace() {
        return (IFilter & Serializable)element -> element != null && StringHelper.hasText((String)element.getNamespaceURI());
    }

    @Nonnull
    public static IFilter<Element> filterElementWithoutNamespace() {
        return (IFilter & Serializable)element -> element != null && XMLHelper.hasNoNamespaceURI(element);
    }

    @Nonnull
    public static IFilter<Element> filterElementWithNamespace(@Nullable String string) {
        return (IFilter & Serializable)element -> element != null && XMLHelper.hasNamespaceURI(element, string);
    }

    @Nonnull
    public static IFilter<Element> filterElementWithNamespaceAndLocalName(@Nullable String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"LocalName");
        return (IFilter & Serializable)element -> element != null && XMLHelper.hasNamespaceURI(element, string) && element.getLocalName().equals(string2);
    }

    @Nonnull
    public static IFilter<Element> filterElementWithTagName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"TagName");
        return (IFilter & Serializable)element -> EqualsHelper.equals((Object)XMLHelper.getElementName(element), (Object)string);
    }

    @Nonnull
    public static IFilter<Element> filterElementWithTagNameNoNS(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"TagName");
        return (IFilter & Serializable)element -> XMLHelper.hasNoNamespaceURI(element) && element.getTagName().equals(string);
    }

    @Nullable
    public static Element getFirstChildElement(@Nullable Node node2) {
        if (node2 == null) {
            return null;
        }
        return (Element)NodeListIterator.createChildNodeIterator(node2).findFirstMapped((Predicate)XMLHelper.filterNodeIsElement(), node -> (Element)node);
    }

    public static boolean hasChildElementNodes(@Nullable Node node) {
        if (node == null) {
            return false;
        }
        return NodeListIterator.createChildNodeIterator(node).containsAny((Predicate)XMLHelper.filterNodeIsElement());
    }

    @Nullable
    public static Element getFirstChildElementOfName(@Nullable Node node, @Nonnull @Nonempty String string) {
        if (node == null) {
            return null;
        }
        return (Element)new ChildElementIterator(node).findFirst((Predicate)XMLHelper.filterElementWithTagName(string));
    }

    @Nullable
    public static Element getFirstChildElementOfName(@Nullable Node node, @Nullable String string, @Nonnull @Nonempty String string2) {
        if (node == null) {
            return null;
        }
        return (Element)new ChildElementIterator(node).findFirst((Predicate)XMLHelper.filterElementWithNamespaceAndLocalName(string, string2));
    }

    @Nonnull
    public static Node append(@Nonnull Node node, @Nullable Object object) {
        ValueEnforcer.notNull((Object)node, (String)"ParentNode");
        if (object != null) {
            if (object instanceof Document) {
                XMLHelper.append(node, ((Document)object).getDocumentElement());
            } else if (object instanceof Node) {
                Node node2 = (Node)object;
                Document document = XMLHelper.getOwnerDocument(node);
                if (XMLHelper.getOwnerDocument(node2).equals(document)) {
                    node.appendChild(node2);
                } else {
                    node.appendChild(document.adoptNode(node2.cloneNode(true)));
                }
            } else if (object instanceof String) {
                node.appendChild(XMLHelper.getOwnerDocument(node).createTextNode((String)object));
            } else if (object instanceof Iterable) {
                for (Object t : (Iterable)object) {
                    XMLHelper.append(node, t);
                }
            } else if (ArrayHelper.isArray((Object)object)) {
                for (Object object2 : (Object[])object) {
                    XMLHelper.append(node, object2);
                }
            } else {
                throw new IllegalArgumentException("Passed object cannot be appended to a DOMNode (type=" + object.getClass().getName() + ".");
            }
        }
        return node;
    }

    public static void append(@Nonnull Node node, @Nonnull Iterable<?> iterable) {
        ValueEnforcer.notNull((Object)node, (String)"ParentNode");
        for (Object obj : iterable) {
            XMLHelper.append(node, obj);
        }
    }

    @Nonnegative
    public static int getDirectChildElementCount(@Nullable Element element) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIterator(element));
    }

    @Nonnegative
    public static int getDirectChildElementCountNoNS(@Nullable Element element) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIteratorNoNS(element));
    }

    @Nonnegative
    public static int getDirectChildElementCount(@Nullable Element element, @Nonnull @Nonempty String string) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIterator(element, string));
    }

    @Nonnegative
    public static int getDirectChildElementCountNoNS(@Nullable Element element, @Nonnull @Nonempty String string) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIteratorNoNS(element, string));
    }

    @Nonnegative
    public static int getDirectChildElementCountNS(@Nullable Element element, @Nullable String string) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIteratorNS(element, string));
    }

    @Nonnegative
    public static int getDirectChildElementCountNS(@Nullable Element element, @Nullable String string, @Nonnull @Nonempty String string2) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIteratorNS(element, string, string2));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIterator(@Nullable Node node) {
        return new ChildElementIterator(node);
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNoNS(@Nullable Node node) {
        return new ChildElementIterator(node).withFilter(XMLHelper.filterElementWithoutNamespace());
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNoNS(@Nullable Node node, @Nonnull @Nonempty String string) {
        return new ChildElementIterator(node).withFilter(XMLHelper.filterElementWithTagNameNoNS(string));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIterator(@Nullable Node node, @Nonnull @Nonempty String string) {
        return new ChildElementIterator(node).withFilter(XMLHelper.filterElementWithTagName(string));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNS(@Nullable Node node, @Nullable String string) {
        return new ChildElementIterator(node).withFilter(XMLHelper.filterElementWithNamespace(string));
    }

    @Nonnull
    public static IIterableIterator<Element> getChildElementIteratorNS(@Nullable Node node, @Nullable String string, @Nonnull @Nonempty String string2) {
        return new ChildElementIterator(node).withFilter(XMLHelper.filterElementWithNamespaceAndLocalName(string, string2));
    }

    @Nonnull
    public static String getPathToNode(@Nonnull Node node) {
        return XMLHelper.getPathToNode(node, "/");
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public static String getPathToNode(@Nonnull Node node, @Nonnull String string) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        ValueEnforcer.notNull((Object)string, (String)"Separator");
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            StringBuilder stringBuilder2 = new StringBuilder(node2.getNodeName());
            if (node2.getNodeType() == 1 && node2.getParentNode() != null) {
                Element element;
                Element element2 = (Element)node2;
                int n = 0;
                Iterator iterator = new ChildElementIterator(node2.getParentNode()).iterator();
                while (iterator.hasNext() && !EqualsHelper.identityEqual((Object)(element = (Element)iterator.next()), (Object)node2)) {
                    if (!element.getTagName().equals(element2.getTagName())) continue;
                    ++n;
                }
                stringBuilder2.append('[').append(n).append(']');
            }
            stringBuilder.insert(0, string).insert(0, stringBuilder2);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getPathToNode2(@Nonnull Node node) {
        return XMLHelper.getPathToNode2(node, "/");
    }

    @Nonnull
    public static String getPathToNode2(@Nonnull Node node, @Nonnull String string) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        ValueEnforcer.notNull((Object)string, (String)"Separator");
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            if (node2.getNodeType() == 9 && stringBuilder.length() > 0) {
                stringBuilder.insert(0, string);
                break;
            }
            StringBuilder stringBuilder2 = new StringBuilder(node2.getNodeName());
            if (node2.getNodeType() == 1 && node2.getParentNode() != null && node2.getParentNode().getNodeType() == 1) {
                Element element = (Element)node2;
                int n = 0;
                int n2 = -1;
                Iterator iterator = new ChildElementIterator(node2.getParentNode()).iterator();
                while (iterator.hasNext()) {
                    Element element2 = (Element)iterator.next();
                    if (EqualsHelper.identityEqual((Object)element2, (Object)node2)) {
                        n2 = n;
                    }
                    if (!element2.getTagName().equals(element.getTagName())) continue;
                    ++n;
                }
                if (n2 < 0) {
                    throw new IllegalStateException("Failed to find Node at parent");
                }
                if (n > 1) {
                    stringBuilder2.append('[').append(n2).append(']');
                }
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, string);
            }
            stringBuilder.insert(0, stringBuilder2);
        }
        return stringBuilder.toString();
    }

    public static void removeAllChildElements(@Nonnull Element element) {
        ValueEnforcer.notNull((Object)element, (String)"Element");
        while (element.getChildNodes().getLength() > 0) {
            element.removeChild(element.getChildNodes().item(0));
        }
    }

    @Nullable
    public static String getFirstChildText(@Nullable Node node2) {
        return (String)NodeListIterator.createChildNodeIterator(node2).findFirstMapped(node -> node instanceof Text && !((Text)node).isElementContentWhitespace(), node -> ((Text)node).getData());
    }

    @Nullable
    public static String getAttributeValue(@Nonnull Element element, @Nonnull String string) {
        return XMLHelper.getAttributeValue(element, string, null);
    }

    @Nullable
    public static String getAttributeValue(@Nonnull Element element, @Nonnull String string, @Nullable String string2) {
        Attr attr = element.getAttributeNode(string);
        return attr == null ? string2 : attr.getValue();
    }

    @Nullable
    public static String getAttributeValueNS(@Nonnull Element element, @Nullable String string, @Nonnull String string2) {
        return XMLHelper.getAttributeValueNS(element, string, string2, null);
    }

    @Nullable
    public static String getAttributeValueNS(@Nonnull Element element, @Nullable String string, @Nonnull String string2, @Nullable String string3) {
        Attr attr = element.getAttributeNodeNS(string, string2);
        return attr == null ? string3 : attr.getValue();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<Attr> getAllAttributesAsList(@Nullable Element element) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        NamedNodeMapIterator.createAttributeIterator(element).forEach(arg_0 -> XMLHelper.lambda$getAllAttributesAsList$3((ICommonsList)commonsArrayList, arg_0));
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedMap<String, String> getAllAttributesAsMap(@Nullable Element element) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        XMLHelper.forAllAttributes(element, (arg_0, arg_1) -> XMLHelper.lambda$getAllAttributesAsMap$4((ICommonsOrderedMap)commonsLinkedHashMap, arg_0, arg_1));
        return commonsLinkedHashMap;
    }

    public static void forAllAttributes(@Nullable Element element, @Nonnull Consumer<Attr> consumer) {
        NamedNodeMapIterator.createAttributeIterator(element).forEach(node -> consumer.accept((Attr)node));
    }

    public static void forAllAttributes(@Nullable Element element, @Nonnull BiConsumer<String, String> biConsumer) {
        XMLHelper.forAllAttributes(element, (Attr attr) -> biConsumer.accept(attr.getName(), attr.getValue()));
    }

    @Nonnull
    public static QName getXMLNSAttrQName(@Nullable String string) {
        if (string != null && string.contains(CXML.XML_PREFIX_NAMESPACE_SEP_STR)) {
            throw new IllegalArgumentException("prefix is invalid: " + string);
        }
        if (string == null || string.equals("")) {
            return new QName("http://www.w3.org/2000/xmlns/", "xmlns");
        }
        return new QName("http://www.w3.org/2000/xmlns/", string, "xmlns");
    }

    @Nonnull
    public static String getPrefix(@Nullable Element element) {
        String string = element == null ? null : element.getPrefix();
        return string == null ? "" : string;
    }

    @Nonnull
    public static QName getQName(@Nonnull Element element) {
        String string = element.getNamespaceURI();
        if (string == null) {
            return new QName(element.getTagName());
        }
        return new QName(string, element.getLocalName(), XMLHelper.getPrefix(element));
    }

    private static /* synthetic */ void lambda$getAllAttributesAsMap$4(ICommonsOrderedMap iCommonsOrderedMap, String string, String string2) {
        String cfr_ignored_0 = (String)iCommonsOrderedMap.put((Object)string, (Object)string2);
    }

    private static /* synthetic */ void lambda$getAllAttributesAsList$3(ICommonsList iCommonsList, Node node) {
        iCommonsList.add((Object)((Attr)node));
    }
}

