/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.util.mime;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.collection.ext.CommonsLinkedHashSet;
import com.helger.commons.collection.ext.ICommonsOrderedSet;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.string.StringHelper;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.IMicroTypeConverterRegistrarSPI;
import com.helger.xml.microdom.convert.IMicroTypeConverterRegistry;
import com.helger.xml.microdom.util.MicroHelper;
import com.helger.xml.util.mime.MimeTypeInfo;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@IsSPIImplementation
@Immutable
public final class MimeTypeInfoMicroTypeConverterRegistrar
implements IMicroTypeConverterRegistrarSPI {
    @Override
    public void registerMicroTypeConverter(@Nonnull IMicroTypeConverterRegistry iMicroTypeConverterRegistry) {
        iMicroTypeConverterRegistry.registerMicroElementTypeConverter(MimeTypeInfo.class, new MimeTypeInfoMicroTypeConverter());
    }

    static final class MimeTypeInfoMicroTypeConverter
    implements IMicroTypeConverter {
        private static final String ELEMENT_MIMETYPE = "mime-type";
        private static final String ELEMENT_COMMENT = "comment";
        private static final String ELEMENT_PARENT_TYPE = "parent-type";
        private static final String ELEMENT_GLOB = "glob";
        private static final String ELEMENT_EXTENSION = "extension";
        private static final String ATTR_SOURCE = "source";

        MimeTypeInfoMicroTypeConverter() {
        }

        @Override
        @Nullable
        public MimeTypeInfo convertToNative(@Nonnull IMicroElement iMicroElement) {
            Object object4;
            Object object22;
            Object object3;
            IMicroElement iMicroElement22;
            CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
            for (IMicroElement iMicroElement22 : iMicroElement.getAllChildElements(ELEMENT_MIMETYPE)) {
                object3 = MimeTypeParser.parseMimeType((String)iMicroElement22.getTextContentTrimmed());
                object22 = iMicroElement22.getAttributeValue(ATTR_SOURCE);
                commonsLinkedHashSet.add((Object)new MimeTypeInfo.MimeTypeWithSource((IMimeType)object3, (String)object22));
            }
            String string = MicroHelper.getChildTextContent(iMicroElement, ELEMENT_COMMENT);
            iMicroElement22 = new CommonsLinkedHashSet();
            for (Object object22 : iMicroElement.getAllChildElements(ELEMENT_PARENT_TYPE)) {
                iMicroElement22.add(object22.getTextContentTrimmed());
            }
            object3 = new CommonsLinkedHashSet();
            for (Object object4 : iMicroElement.getAllChildElements(ELEMENT_GLOB)) {
                object3.add((Object)object4.getTextContentTrimmed());
            }
            object22 = new CommonsLinkedHashSet();
            for (IMicroElement iMicroElement3 : iMicroElement.getAllChildElements(ELEMENT_EXTENSION)) {
                String string2 = StringHelper.getNotNull((String)iMicroElement3.getTextContentTrimmed());
                String string3 = iMicroElement3.getAttributeValue(ATTR_SOURCE);
                object22.add((Object)new MimeTypeInfo.ExtensionWithSource(string2, string3));
            }
            object4 = iMicroElement.getAttributeValue(ATTR_SOURCE);
            return new MimeTypeInfo((ICommonsOrderedSet<MimeTypeInfo.MimeTypeWithSource>)commonsLinkedHashSet, string, (ICommonsOrderedSet<String>)iMicroElement22, (ICommonsOrderedSet<String>)object3, (ICommonsOrderedSet<MimeTypeInfo.ExtensionWithSource>)object22, (String)object4);
        }

        @Override
        @Nullable
        public IMicroElement convertToMicroElement(@Nonnull Object object, @Nullable String string, @Nonnull String string2) {
            MimeTypeInfo mimeTypeInfo = (MimeTypeInfo)object;
            MicroElement microElement = new MicroElement(string, string2);
            for (Object object2 : mimeTypeInfo.getAllMimeTypesWithSource()) {
                microElement.appendElement(string, ELEMENT_MIMETYPE).setAttribute(ATTR_SOURCE, ((MimeTypeInfo.MimeTypeWithSource)object2).getSource()).appendText(((MimeTypeInfo.MimeTypeWithSource)object2).getMimeTypeAsString());
            }
            if (mimeTypeInfo.hasComment()) {
                microElement.appendElement(string, ELEMENT_COMMENT).appendText(mimeTypeInfo.getComment());
            }
            for (Object object2 : mimeTypeInfo.getAllParentTypes()) {
                microElement.appendElement(string, ELEMENT_PARENT_TYPE).appendText((CharSequence)object2);
            }
            for (Object object2 : mimeTypeInfo.getAllGlobs()) {
                microElement.appendElement(string, ELEMENT_GLOB).appendText((CharSequence)object2);
            }
            for (Object object2 : mimeTypeInfo.getAllExtensionsWithSource()) {
                microElement.appendElement(string, ELEMENT_EXTENSION).setAttribute(ATTR_SOURCE, ((MimeTypeInfo.ExtensionWithSource)object2).getSource()).appendText(((MimeTypeInfo.ExtensionWithSource)object2).getExtension());
            }
            microElement.setAttribute(ATTR_SOURCE, mimeTypeInfo.getSource());
            return microElement;
        }
    }
}

