/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.xpath.MapBasedXPathVariableResolverQName;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;

@NotThreadSafe
public class MapBasedXPathVariableResolver
implements XPathVariableResolver,
ICloneable<MapBasedXPathVariableResolver> {
    private final ICommonsMap<String, Object> m_aMap;

    public MapBasedXPathVariableResolver() {
        this((Map)null);
    }

    public MapBasedXPathVariableResolver(@Nullable Map<String, ?> map) {
        this.m_aMap = new CommonsHashMap(map);
    }

    public MapBasedXPathVariableResolver(@Nonnull MapBasedXPathVariableResolver mapBasedXPathVariableResolver) {
        ValueEnforcer.notNull((Object)mapBasedXPathVariableResolver, (String)"Other");
        this.m_aMap = (ICommonsMap)mapBasedXPathVariableResolver.m_aMap.getClone();
    }

    @Nonnull
    public EChange addUniqueVariable(@Nonnull String string, @Nonnull Object object) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        ValueEnforcer.notNull((Object)object, (String)"Value");
        if (this.m_aMap.containsKey((Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_aMap.put((Object)string, object);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange addAllFrom(@Nonnull MapBasedXPathVariableResolver mapBasedXPathVariableResolver, boolean bl) {
        ValueEnforcer.notNull((Object)mapBasedXPathVariableResolver, (String)"Other");
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry entry : mapBasedXPathVariableResolver.m_aMap.entrySet()) {
            if (!bl && this.m_aMap.containsKey(entry.getKey())) continue;
            this.m_aMap.put(entry.getKey(), entry.getValue());
            eChange = EChange.CHANGED;
        }
        return eChange;
    }

    @Nonnull
    public EChange addAllFrom(@Nonnull MapBasedXPathVariableResolverQName mapBasedXPathVariableResolverQName, boolean bl) {
        ValueEnforcer.notNull((Object)mapBasedXPathVariableResolverQName, (String)"Other");
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry entry : mapBasedXPathVariableResolverQName.getAllVariables().entrySet()) {
            String string = ((QName)entry.getKey()).getLocalPart();
            if (!bl && this.m_aMap.containsKey((Object)string)) continue;
            this.m_aMap.put((Object)string, entry.getValue());
            eChange = EChange.CHANGED;
        }
        return eChange;
    }

    @Nonnull
    public EChange removeVariable(@Nullable String string) {
        if (string == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aMap.removeObject((Object)string);
    }

    @Nonnull
    public EChange removeVariables(@Nullable Iterable<String> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (String string : iterable) {
                eChange = eChange.or((IChangeIndicator)this.removeVariable(string));
            }
        }
        return eChange;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, ?> getAllVariables() {
        return (ICommonsMap)this.m_aMap.getClone();
    }

    @Nonnegative
    public int getVariableCount() {
        return this.m_aMap.size();
    }

    @Nonnull
    public EChange clear() {
        return this.m_aMap.removeAll();
    }

    public void setAllVariables(@Nullable Map<String, ?> map) {
        this.m_aMap.setAll(map);
    }

    @Override
    @Nullable
    public Object resolveVariable(@Nonnull QName qName) {
        ValueEnforcer.notNull((Object)qName, (String)"VariableName");
        String string = qName.getLocalPart();
        return this.m_aMap.get((Object)string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public MapBasedXPathVariableResolver getClone() {
        return new MapBasedXPathVariableResolver(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedXPathVariableResolver mapBasedXPathVariableResolver = (MapBasedXPathVariableResolver)object;
        return EqualsHelper.equals(this.m_aMap, mapBasedXPathVariableResolver.m_aMap);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMap).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("map", this.m_aMap).toString();
    }
}

