/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.stream.StreamSource;

@NotThreadSafe
public class ResourceStreamSource
extends StreamSource {
    private final IHasInputStream m_aISP;

    public ResourceStreamSource(@Nonnull IReadableResource iReadableResource) {
        this((IHasInputStream)iReadableResource, iReadableResource.getResourceID());
    }

    public ResourceStreamSource(@Nonnull IHasInputStream iHasInputStream, @Nullable String string) {
        this.m_aISP = (IHasInputStream)ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        this.setSystemId(string);
    }

    @Nonnull
    public IHasInputStream getInputStreamProvider() {
        return this.m_aISP;
    }

    @Override
    public InputStream getInputStream() {
        InputStream inputStream = this.m_aISP.getInputStream();
        if (inputStream == null) {
            throw new IllegalStateException("Failed to open input stream for " + this.m_aISP);
        }
        return inputStream;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ISP", (Object)this.m_aISP).append("systemID", (Object)this.getSystemId()).toString();
    }
}

