/**
 * Copyright (C) 2014-2016 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.xml.dom;

import static org.junit.Assert.assertSame;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import com.helger.xml.dom.EXMLDOMNodeType;

/**
 * Test class for class {@link EXMLDOMNodeType}.
 *
 * @author Philip Helger
 */
public final class EXMLDOMNodeTypeTest
{
  @Test
  public void testAll ()
  {
    for (final EXMLDOMNodeType e : EXMLDOMNodeType.values ())
    {
      assertTrue (e.getID () >= 0);
      assertSame (e, EXMLDOMNodeType.getFromIDOrNull (e.getID ()));
      assertSame (e, EXMLDOMNodeType.valueOf (e.name ()));
    }
  }
}
