/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.writer;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.system.ENewLineMode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.ICSSWriterSettings;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class CSSWriterSettings
implements ICSSWriterSettings,
ICloneable<CSSWriterSettings> {
    public static final boolean DEFAULT_OPTIMIZED_OUTPUT = false;
    public static final boolean DEFAULT_REMOVE_UNNECESSARY_CODE = false;
    public static final ENewLineMode DEFAULT_NEW_LINE_MODE = ENewLineMode.UNIX;
    public static final String DEFAULT_INDENT = "  ";
    public static final boolean DEFAULT_QUOTE_URLS = false;
    public static final boolean DEFAULT_WRITE_NAMESPACE_RULES = true;
    public static final boolean DEFAULT_WRITE_FONT_FACE_RULES = true;
    public static final boolean DEFAULT_WRITE_KEYFRAMES_RULES = true;
    public static final boolean DEFAULT_WRITE_MEDIA_RULES = true;
    public static final boolean DEFAULT_WRITE_PAGE_RULES = true;
    public static final boolean DEFAULT_WRITE_VIEWPORT_RULES = true;
    public static final boolean DEFAULT_WRITE_SUPPORTS_RULES = true;
    public static final boolean DEFAULT_WRITE_UNKNOWN_RULES = true;
    public static final ICSSWriterSettings DEFAULT_SETTINGS = new CSSWriterSettings();
    private boolean m_bOptimizedOutput;
    private boolean m_bRemoveUnnecessaryCode = false;
    private ENewLineMode m_eNewLineMode = DEFAULT_NEW_LINE_MODE;
    private String m_sIndent = "  ";
    private boolean m_bQuoteURLs = false;
    private boolean m_bWriteNamespaceRules = true;
    private boolean m_bWriteFontFaceRules = true;
    private boolean m_bWriteKeyframesRules = true;
    private boolean m_bWriteMediaRules = true;
    private boolean m_bWritePageRules = true;
    private boolean m_bWriteViewportRules = true;
    private boolean m_bWriteSupportsRules = true;
    private boolean m_bWriteUnknownRules = true;

    public CSSWriterSettings() {
        this(false);
    }

    public CSSWriterSettings(boolean bl) {
        this.setOptimizedOutput(bl);
    }

    public CSSWriterSettings(@NonNull ICSSWriterSettings iCSSWriterSettings) {
        ValueEnforcer.notNull((Object)iCSSWriterSettings, (String)"Base");
        this.setOptimizedOutput(iCSSWriterSettings.isOptimizedOutput());
        this.setRemoveUnnecessaryCode(iCSSWriterSettings.isRemoveUnnecessaryCode());
        this.setNewLineMode(iCSSWriterSettings.getNewLineMode());
        this.setIndent(iCSSWriterSettings.getIndent(1));
        this.setQuoteURLs(iCSSWriterSettings.isQuoteURLs());
        this.setWriteNamespaceRules(iCSSWriterSettings.isWriteNamespaceRules());
        this.setWriteFontFaceRules(iCSSWriterSettings.isWriteFontFaceRules());
        this.setWriteKeyframesRules(iCSSWriterSettings.isWriteKeyframesRules());
        this.setWriteMediaRules(iCSSWriterSettings.isWriteMediaRules());
        this.setWritePageRules(iCSSWriterSettings.isWritePageRules());
        this.setWriteViewportRules(iCSSWriterSettings.isWriteViewportRules());
        this.setWriteSupportsRules(iCSSWriterSettings.isWriteSupportsRules());
        this.setWriteUnknownRules(iCSSWriterSettings.isWriteUnknownRules());
    }

    @Override
    public final boolean isOptimizedOutput() {
        return this.m_bOptimizedOutput;
    }

    public final @NonNull CSSWriterSettings setOptimizedOutput(boolean bl) {
        this.m_bOptimizedOutput = bl;
        return this;
    }

    @Override
    public final boolean isRemoveUnnecessaryCode() {
        return this.m_bRemoveUnnecessaryCode;
    }

    public final @NonNull CSSWriterSettings setRemoveUnnecessaryCode(boolean bl) {
        this.m_bRemoveUnnecessaryCode = bl;
        return this;
    }

    @Override
    public final @NonNull ENewLineMode getNewLineMode() {
        return this.m_eNewLineMode;
    }

    @Override
    @Nonempty
    public final @NonNull String getNewLineString() {
        return this.m_eNewLineMode.getText();
    }

    public final @NonNull CSSWriterSettings setNewLineMode(@NonNull ENewLineMode eNewLineMode) {
        this.m_eNewLineMode = (ENewLineMode)ValueEnforcer.notNull((Object)eNewLineMode, (String)"NewLineMode");
        return this;
    }

    @Override
    public final @NonNull String getIndent(@Nonnegative int n) {
        return StringHelper.getRepeated((String)this.m_sIndent, (int)n);
    }

    public final @NonNull CSSWriterSettings setIndent(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Indent");
        this.m_sIndent = string;
        return this;
    }

    @Override
    public final boolean isQuoteURLs() {
        return this.m_bQuoteURLs;
    }

    public final @NonNull CSSWriterSettings setQuoteURLs(boolean bl) {
        this.m_bQuoteURLs = bl;
        return this;
    }

    @Override
    public final boolean isWriteNamespaceRules() {
        return this.m_bWriteNamespaceRules;
    }

    public final @NonNull CSSWriterSettings setWriteNamespaceRules(boolean bl) {
        this.m_bWriteNamespaceRules = bl;
        return this;
    }

    @Override
    public final boolean isWriteFontFaceRules() {
        return this.m_bWriteFontFaceRules;
    }

    public final @NonNull CSSWriterSettings setWriteFontFaceRules(boolean bl) {
        this.m_bWriteFontFaceRules = bl;
        return this;
    }

    @Override
    public final boolean isWriteKeyframesRules() {
        return this.m_bWriteKeyframesRules;
    }

    public final @NonNull CSSWriterSettings setWriteKeyframesRules(boolean bl) {
        this.m_bWriteKeyframesRules = bl;
        return this;
    }

    @Override
    public final boolean isWriteMediaRules() {
        return this.m_bWriteMediaRules;
    }

    public final @NonNull CSSWriterSettings setWriteMediaRules(boolean bl) {
        this.m_bWriteMediaRules = bl;
        return this;
    }

    @Override
    public final boolean isWritePageRules() {
        return this.m_bWritePageRules;
    }

    public final @NonNull CSSWriterSettings setWritePageRules(boolean bl) {
        this.m_bWritePageRules = bl;
        return this;
    }

    @Override
    public final boolean isWriteViewportRules() {
        return this.m_bWriteViewportRules;
    }

    public final @NonNull CSSWriterSettings setWriteViewportRules(boolean bl) {
        this.m_bWriteViewportRules = bl;
        return this;
    }

    @Override
    public final boolean isWriteSupportsRules() {
        return this.m_bWriteSupportsRules;
    }

    public final @NonNull CSSWriterSettings setWriteSupportsRules(boolean bl) {
        this.m_bWriteSupportsRules = bl;
        return this;
    }

    @Override
    public final boolean isWriteUnknownRules() {
        return this.m_bWriteUnknownRules;
    }

    public final @NonNull CSSWriterSettings setWriteUnknownRules(boolean bl) {
        this.m_bWriteUnknownRules = bl;
        return this;
    }

    @ReturnsMutableCopy
    public @NonNull CSSWriterSettings getClone() {
        return new CSSWriterSettings(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSWriterSettings cSSWriterSettings = (CSSWriterSettings)object;
        return this.m_bOptimizedOutput == cSSWriterSettings.m_bOptimizedOutput && this.m_bRemoveUnnecessaryCode == cSSWriterSettings.m_bRemoveUnnecessaryCode && this.m_eNewLineMode.equals((Object)cSSWriterSettings.m_eNewLineMode) && this.m_sIndent.equals(cSSWriterSettings.m_sIndent) && this.m_bQuoteURLs == cSSWriterSettings.m_bQuoteURLs && this.m_bWriteNamespaceRules == cSSWriterSettings.m_bWriteNamespaceRules && this.m_bWriteFontFaceRules == cSSWriterSettings.m_bWriteFontFaceRules && this.m_bWriteKeyframesRules == cSSWriterSettings.m_bWriteKeyframesRules && this.m_bWriteMediaRules == cSSWriterSettings.m_bWriteMediaRules && this.m_bWritePageRules == cSSWriterSettings.m_bWritePageRules && this.m_bWriteViewportRules == cSSWriterSettings.m_bWriteViewportRules && this.m_bWriteSupportsRules == cSSWriterSettings.m_bWriteSupportsRules && this.m_bWriteUnknownRules == cSSWriterSettings.m_bWriteUnknownRules;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_bOptimizedOutput).append(this.m_bRemoveUnnecessaryCode).append((Object)this.m_eNewLineMode).append((Object)this.m_sIndent).append(this.m_bQuoteURLs).append(this.m_bWriteNamespaceRules).append(this.m_bWriteFontFaceRules).append(this.m_bWriteKeyframesRules).append(this.m_bWriteMediaRules).append(this.m_bWritePageRules).append(this.m_bWriteViewportRules).append(this.m_bWriteSupportsRules).append(this.m_bWriteUnknownRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("OptimizedOutput", this.m_bOptimizedOutput).append("RemoveUnnecessaryCode", this.m_bRemoveUnnecessaryCode).append("NewLineMode", (Enum)this.m_eNewLineMode).append("Indent", (Object)this.m_sIndent).append("QuoteURLs", this.m_bQuoteURLs).append("WriteNamespaceRules", this.m_bWriteNamespaceRules).append("WriteFontFaceRules", this.m_bWriteFontFaceRules).append("WriteKeyframesRules", this.m_bWriteKeyframesRules).append("WriteMediaRules", this.m_bWriteMediaRules).append("WritePageRules", this.m_bWritePageRules).append("WriteViewportRules", this.m_bWriteViewportRules).append("WriteSupportsRules", this.m_bWriteSupportsRules).append("WriteUnknownRules", this.m_bWriteUnknownRules).getToString();
    }
}

