/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSMediaExpression;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSMediaQuery
implements ICSSWriteable,
ICSSSourceLocationAware {
    private final EModifier m_eModifier;
    private final String m_sMedium;
    private final ICommonsList<CSSMediaExpression> m_aMediaExpressions = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public CSSMediaQuery(@Nullable String string) {
        this(EModifier.NONE, string);
    }

    public CSSMediaQuery(@NonNull EModifier eModifier, @Nullable String string) {
        ValueEnforcer.notNull((Object)((Object)eModifier), (String)"Modifier");
        this.m_eModifier = eModifier;
        this.m_sMedium = string;
    }

    public final @NonNull EModifier getModifier() {
        return this.m_eModifier;
    }

    public final boolean isNot() {
        return this.m_eModifier == EModifier.NOT;
    }

    public final boolean isOnly() {
        return this.m_eModifier == EModifier.ONLY;
    }

    public final @Nullable String getMedium() {
        return this.m_sMedium;
    }

    public boolean hasMediaExpressions() {
        return this.m_aMediaExpressions.isNotEmpty();
    }

    @Nonnegative
    public int getMediaExpressionCount() {
        return this.m_aMediaExpressions.size();
    }

    public @NonNull CSSMediaQuery addMediaExpression(@NonNull CSSMediaExpression cSSMediaExpression) {
        ValueEnforcer.notNull((Object)cSSMediaExpression, (String)"MediaExpression");
        this.m_aMediaExpressions.add((Object)cSSMediaExpression);
        return this;
    }

    public @NonNull CSSMediaQuery addMediaExpression(@Nonnegative int n, @NonNull CSSMediaExpression cSSMediaExpression) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSMediaExpression, (String)"MediaExpression");
        if (n >= this.getMediaExpressionCount()) {
            this.m_aMediaExpressions.add((Object)cSSMediaExpression);
        } else {
            this.m_aMediaExpressions.add(n, (Object)cSSMediaExpression);
        }
        return this;
    }

    public @NonNull EChange removeMediaExpression(@Nullable CSSMediaExpression cSSMediaExpression) {
        return this.m_aMediaExpressions.removeObject((Object)cSSMediaExpression);
    }

    public @NonNull EChange removeMediaExpression(int n) {
        return this.m_aMediaExpressions.removeAtIndex(n);
    }

    public @NonNull EChange removeAllMediaExpressions() {
        return this.m_aMediaExpressions.removeAll();
    }

    public @Nullable CSSMediaExpression getMediaExpression(@Nonnegative int n) {
        return (CSSMediaExpression)this.m_aMediaExpressions.getAtIndex(n);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSMediaExpression> getAllMediaExpressions() {
        return (ICommonsList)this.m_aMediaExpressions.getClone();
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_eModifier.getCSSText());
        boolean bl = true;
        if (this.m_sMedium != null) {
            stringBuilder.append(this.m_sMedium);
            bl = false;
        }
        if (this.m_aMediaExpressions.isNotEmpty()) {
            for (CSSMediaExpression cSSMediaExpression : this.m_aMediaExpressions) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(" and ");
                }
                stringBuilder.append(cSSMediaExpression.getAsCSSString(iCSSWriterSettings, n));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSMediaQuery cSSMediaQuery = (CSSMediaQuery)object;
        return this.m_eModifier.equals((Object)cSSMediaQuery.m_eModifier) && EqualsHelper.equals((Object)this.m_sMedium, (Object)cSSMediaQuery.m_sMedium) && this.m_aMediaExpressions.equals(cSSMediaQuery.m_aMediaExpressions);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_eModifier).append((Object)this.m_sMedium).append(this.m_aMediaExpressions).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Modifier", (Enum)this.m_eModifier).append("Medium", (Object)this.m_sMedium).append("Expressions", this.m_aMediaExpressions).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }

    public static enum EModifier {
        NONE(""),
        NOT("not "),
        ONLY("only ");

        private final String m_sText;

        private EModifier(String string2) {
            this.m_sText = string2;
        }

        public @NonNull String getCSSText() {
            return this.m_sText;
        }
    }
}

