/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl.visit;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.stack.NonBlockingStack;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.CSSExpressionMemberFunction;
import com.helger.css.decl.CSSExpressionMemberMath;
import com.helger.css.decl.CSSExpressionMemberMathProduct;
import com.helger.css.decl.CSSExpressionMemberMathUnitProduct;
import com.helger.css.decl.CSSExpressionMemberTermURI;
import com.helger.css.decl.CSSFontFaceRule;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSKeyframesBlock;
import com.helger.css.decl.CSSKeyframesRule;
import com.helger.css.decl.CSSLayerRule;
import com.helger.css.decl.CSSMediaRule;
import com.helger.css.decl.CSSNamespaceRule;
import com.helger.css.decl.CSSPageMarginBlock;
import com.helger.css.decl.CSSPageRule;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CSSSupportsRule;
import com.helger.css.decl.CSSUnknownRule;
import com.helger.css.decl.CSSViewportRule;
import com.helger.css.decl.ICSSExpressionMathMember;
import com.helger.css.decl.ICSSExpressionMember;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.decl.visit.ICSSUrlVisitor;
import com.helger.css.decl.visit.ICSSVisitor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSVisitorForUrl
implements ICSSVisitor {
    private final ICSSUrlVisitor m_aVisitor;
    private final NonBlockingStack<ICSSTopLevelRule> m_aTopLevelRule = new NonBlockingStack();

    public CSSVisitorForUrl(@NonNull ICSSUrlVisitor iCSSUrlVisitor) {
        this.m_aVisitor = (ICSSUrlVisitor)ValueEnforcer.notNull((Object)iCSSUrlVisitor, (String)"Visitor");
    }

    public @NonNull ICSSUrlVisitor getVisitor() {
        return this.m_aVisitor;
    }

    @Override
    public void begin() {
        this.m_aVisitor.begin();
    }

    @Override
    public void onImport(@NonNull CSSImportRule cSSImportRule) {
        this.m_aVisitor.onImport(cSSImportRule);
    }

    @Override
    public void onNamespace(@NonNull CSSNamespaceRule cSSNamespaceRule) {
    }

    private void _recursiveCheckMathMember(@Nullable ICSSTopLevelRule iCSSTopLevelRule, @NonNull CSSDeclaration cSSDeclaration, @NonNull ICSSExpressionMathMember iCSSExpressionMathMember) {
        if (iCSSExpressionMathMember instanceof CSSExpressionMemberFunction) {
            CSSExpressionMemberFunction cSSExpressionMemberFunction = (CSSExpressionMemberFunction)iCSSExpressionMathMember;
            this._recursiveCheckExpression(iCSSTopLevelRule, cSSDeclaration, cSSExpressionMemberFunction.getExpression());
        } else if (iCSSExpressionMathMember instanceof CSSExpressionMemberMath) {
            CSSExpressionMemberMath cSSExpressionMemberMath = (CSSExpressionMemberMath)iCSSExpressionMathMember;
            for (ICSSExpressionMathMember iCSSExpressionMathMember2 : cSSExpressionMemberMath.getAllMembers()) {
                this._recursiveCheckMathMember(iCSSTopLevelRule, cSSDeclaration, iCSSExpressionMathMember2);
            }
        } else if (iCSSExpressionMathMember instanceof CSSExpressionMemberMathProduct) {
            CSSExpressionMemberMathProduct cSSExpressionMemberMathProduct = (CSSExpressionMemberMathProduct)iCSSExpressionMathMember;
            for (ICSSExpressionMathMember iCSSExpressionMathMember3 : cSSExpressionMemberMathProduct.getAllMembers()) {
                this._recursiveCheckMathMember(iCSSTopLevelRule, cSSDeclaration, iCSSExpressionMathMember3);
            }
        } else if (iCSSExpressionMathMember instanceof CSSExpressionMemberMathUnitProduct) {
            CSSExpressionMemberMathUnitProduct cSSExpressionMemberMathUnitProduct = (CSSExpressionMemberMathUnitProduct)iCSSExpressionMathMember;
            this._recursiveCheckMathMember(iCSSTopLevelRule, cSSDeclaration, cSSExpressionMemberMathUnitProduct.getProduct());
        }
    }

    private void _recursiveCheckExpression(@Nullable ICSSTopLevelRule iCSSTopLevelRule, @NonNull CSSDeclaration cSSDeclaration, @Nullable CSSExpression cSSExpression) {
        if (cSSExpression != null) {
            for (ICSSExpressionMember iCSSExpressionMember : cSSExpression.getAllMembers()) {
                ICSSExpressionMember iCSSExpressionMember2;
                if (iCSSExpressionMember instanceof CSSExpressionMemberFunction) {
                    iCSSExpressionMember2 = (CSSExpressionMemberFunction)iCSSExpressionMember;
                    this._recursiveCheckExpression(iCSSTopLevelRule, cSSDeclaration, ((CSSExpressionMemberFunction)iCSSExpressionMember2).getExpression());
                    continue;
                }
                if (iCSSExpressionMember instanceof CSSExpressionMemberMath) {
                    iCSSExpressionMember2 = (CSSExpressionMemberMath)iCSSExpressionMember;
                    for (ICSSExpressionMathMember iCSSExpressionMathMember : ((CSSExpressionMemberMath)iCSSExpressionMember2).getAllMembers()) {
                        this._recursiveCheckMathMember(iCSSTopLevelRule, cSSDeclaration, iCSSExpressionMathMember);
                    }
                    continue;
                }
                if (!(iCSSExpressionMember instanceof CSSExpressionMemberTermURI)) continue;
                iCSSExpressionMember2 = (CSSExpressionMemberTermURI)iCSSExpressionMember;
                this.m_aVisitor.onUrlDeclaration(iCSSTopLevelRule, cSSDeclaration, (CSSExpressionMemberTermURI)iCSSExpressionMember2);
            }
        }
    }

    @Override
    public void onDeclaration(@NonNull CSSDeclaration cSSDeclaration) {
        ICSSTopLevelRule iCSSTopLevelRule = this.m_aTopLevelRule.isEmpty() ? null : (ICSSTopLevelRule)this.m_aTopLevelRule.peek();
        this._recursiveCheckExpression(iCSSTopLevelRule, cSSDeclaration, cSSDeclaration.getExpression());
    }

    @Override
    public void onBeginStyleRule(@NonNull CSSStyleRule cSSStyleRule) {
        this.m_aTopLevelRule.push((Object)cSSStyleRule);
    }

    @Override
    public void onStyleRuleSelector(@NonNull CSSSelector cSSSelector) {
    }

    @Override
    public void onEndStyleRule(@NonNull CSSStyleRule cSSStyleRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginPageRule(@NonNull CSSPageRule cSSPageRule) {
        this.m_aTopLevelRule.push((Object)cSSPageRule);
    }

    @Override
    public void onBeginPageMarginBlock(@NonNull CSSPageMarginBlock cSSPageMarginBlock) {
    }

    @Override
    public void onEndPageMarginBlock(@NonNull CSSPageMarginBlock cSSPageMarginBlock) {
    }

    @Override
    public void onEndPageRule(@NonNull CSSPageRule cSSPageRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginFontFaceRule(@NonNull CSSFontFaceRule cSSFontFaceRule) {
        this.m_aTopLevelRule.push((Object)cSSFontFaceRule);
    }

    @Override
    public void onEndFontFaceRule(@NonNull CSSFontFaceRule cSSFontFaceRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginMediaRule(@NonNull CSSMediaRule cSSMediaRule) {
        this.m_aTopLevelRule.push((Object)cSSMediaRule);
    }

    @Override
    public void onEndMediaRule(@NonNull CSSMediaRule cSSMediaRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginKeyframesRule(@NonNull CSSKeyframesRule cSSKeyframesRule) {
        this.m_aTopLevelRule.push((Object)cSSKeyframesRule);
    }

    @Override
    public void onBeginKeyframesBlock(@NonNull CSSKeyframesBlock cSSKeyframesBlock) {
    }

    @Override
    public void onEndKeyframesBlock(@NonNull CSSKeyframesBlock cSSKeyframesBlock) {
    }

    @Override
    public void onEndKeyframesRule(@NonNull CSSKeyframesRule cSSKeyframesRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginViewportRule(@NonNull CSSViewportRule cSSViewportRule) {
        this.m_aTopLevelRule.push((Object)cSSViewportRule);
    }

    @Override
    public void onEndViewportRule(@NonNull CSSViewportRule cSSViewportRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginSupportsRule(@NonNull CSSSupportsRule cSSSupportsRule) {
        this.m_aTopLevelRule.push((Object)cSSSupportsRule);
    }

    @Override
    public void onEndSupportsRule(@NonNull CSSSupportsRule cSSSupportsRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onBeginLayerRule(@NonNull CSSLayerRule cSSLayerRule) {
        this.m_aTopLevelRule.push((Object)cSSLayerRule);
    }

    @Override
    public void onEndLayerRule(@NonNull CSSLayerRule cSSLayerRule) {
        this.m_aTopLevelRule.pop();
    }

    @Override
    public void onUnknownRule(@NonNull CSSUnknownRule cSSUnknownRule) {
    }

    @Override
    public void end() {
        this.m_aVisitor.end();
    }
}

