/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSExpressionTermOptimizer;
import com.helger.css.decl.ICSSExpressionMember;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSExpressionMemberTermSimple
implements ICSSExpressionMember,
ICSSSourceLocationAware {
    private String m_sValue;
    private String m_sOptimizedValue;
    private CSSSourceLocation m_aSourceLocation;

    public CSSExpressionMemberTermSimple(int n) {
        this(Integer.toString(n));
    }

    public CSSExpressionMemberTermSimple(long l) {
        this(Long.toString(l));
    }

    public CSSExpressionMemberTermSimple(float f) {
        this(Float.toString(f));
    }

    public CSSExpressionMemberTermSimple(double d) {
        this(Double.toString(d));
    }

    public CSSExpressionMemberTermSimple(@Nonempty @NonNull String string) {
        this.setValue(string);
    }

    public final @NonNull CSSExpressionMemberTermSimple setValue(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Value");
        this.m_sValue = string;
        this.m_sOptimizedValue = CSSExpressionTermOptimizer.getOptimizedValue(string);
        return this;
    }

    @Nonempty
    public final @NonNull String getValue() {
        return this.m_sValue;
    }

    @Nonempty
    public final @NonNull String getOptimizedValue() {
        return this.m_sOptimizedValue;
    }

    public final boolean isStringLiteral() {
        char c = this.m_sValue.charAt(0);
        return (c == '\"' || c == '\'') && c == StringHelper.getLastChar((CharSequence)this.m_sValue);
    }

    public @NonNull CSSExpressionMemberTermSimple getClone() {
        return new CSSExpressionMemberTermSimple(this.m_sValue);
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return iCSSWriterSettings.isOptimizedOutput() ? this.m_sOptimizedValue : this.m_sValue;
    }

    @Override
    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberTermSimple cSSExpressionMemberTermSimple = (CSSExpressionMemberTermSimple)object;
        return this.m_sOptimizedValue.equals(cSSExpressionMemberTermSimple.m_sOptimizedValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sOptimizedValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("value", (Object)this.m_sValue).append("optimizedValue", (Object)this.m_sOptimizedValue).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

