/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css;

import com.helger.annotation.Nonempty;
import com.helger.base.lang.EnumHelper;
import com.helger.base.name.IHasName;
import com.helger.css.ECSSMetaUnit;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum ECSSUnit implements IHasName
{
    CAP("cap", ECSSMetaUnit.FONT_RELATIVE_LENGTH),
    CH("ch", ECSSMetaUnit.FONT_RELATIVE_LENGTH),
    EM("em", ECSSMetaUnit.FONT_RELATIVE_LENGTH),
    EX("ex", ECSSMetaUnit.FONT_RELATIVE_LENGTH),
    IC("ic", ECSSMetaUnit.FONT_RELATIVE_LENGTH),
    LH("lh", ECSSMetaUnit.FONT_RELATIVE_LENGTH),
    RCAP("rcap", ECSSMetaUnit.FONT_RELATIVE_LENGTH_ROOT_BASED),
    RCH("rch", ECSSMetaUnit.FONT_RELATIVE_LENGTH_ROOT_BASED),
    REM("rem", ECSSMetaUnit.FONT_RELATIVE_LENGTH_ROOT_BASED),
    REX("rex", ECSSMetaUnit.FONT_RELATIVE_LENGTH_ROOT_BASED),
    RIC("ric", ECSSMetaUnit.FONT_RELATIVE_LENGTH_ROOT_BASED),
    RLH("rlh", ECSSMetaUnit.FONT_RELATIVE_LENGTH_ROOT_BASED),
    VW("vw", ECSSMetaUnit.VIEWPORT_RELATIVE_LENGTH),
    VH("vh", ECSSMetaUnit.VIEWPORT_RELATIVE_LENGTH),
    VB("vb", ECSSMetaUnit.VIEWPORT_RELATIVE_LENGTH),
    VI("vi", ECSSMetaUnit.VIEWPORT_RELATIVE_LENGTH),
    VMIN("vmin", ECSSMetaUnit.VIEWPORT_RELATIVE_LENGTH),
    VMAX("vmax", ECSSMetaUnit.VIEWPORT_RELATIVE_LENGTH),
    CQW("cqw", ECSSMetaUnit.CONTAINER_RELATIVE_LENGTH),
    CQH("cqh", ECSSMetaUnit.CONTAINER_RELATIVE_LENGTH),
    CQI("cqi", ECSSMetaUnit.CONTAINER_RELATIVE_LENGTH),
    CQB("cqb", ECSSMetaUnit.CONTAINER_RELATIVE_LENGTH),
    CQMIN("cqmin", ECSSMetaUnit.CONTAINER_RELATIVE_LENGTH),
    CQMAX("cqmax", ECSSMetaUnit.CONTAINER_RELATIVE_LENGTH),
    PX("px", ECSSMetaUnit.ABSOLUTE_LENGTH),
    LENGTH_CM("cm", ECSSMetaUnit.ABSOLUTE_LENGTH),
    LENGTH_MM("mm", ECSSMetaUnit.ABSOLUTE_LENGTH),
    LENGTH_Q("q", ECSSMetaUnit.ABSOLUTE_LENGTH),
    LENGTH_IN("in", ECSSMetaUnit.ABSOLUTE_LENGTH),
    LENGTH_PC("pc", ECSSMetaUnit.ABSOLUTE_LENGTH),
    LENGTH_PT("pt", ECSSMetaUnit.ABSOLUTE_LENGTH),
    PERCENTAGE("%", ECSSMetaUnit.PERCENTAGE),
    ANGLE_DEG("deg", ECSSMetaUnit.ANGLE),
    ANGLE_RAD("rad", ECSSMetaUnit.ANGLE),
    ANGLE_GRAD("grad", ECSSMetaUnit.ANGLE),
    ANGLE_TURN("turn", ECSSMetaUnit.ANGLE),
    TIME_MS("ms", ECSSMetaUnit.TIME),
    TIME_S("s", ECSSMetaUnit.TIME),
    FREQ_HZ("hz", ECSSMetaUnit.FREQUENZY),
    FREQ_KHZ("khz", ECSSMetaUnit.FREQUENZY),
    DPI("dpi", ECSSMetaUnit.RESOLUTION),
    DPCM("dpcm", ECSSMetaUnit.RESOLUTION),
    DPPX("dppx", ECSSMetaUnit.RESOLUTION),
    FR("fr", ECSSMetaUnit.FLEX);

    public static final ECSSUnit LENGTH_PX;
    private final String m_sName;
    private final ECSSMetaUnit m_eMetaUnit;

    private ECSSUnit(String string2, ECSSMetaUnit eCSSMetaUnit) {
        this.m_sName = string2;
        this.m_eMetaUnit = eCSSMetaUnit;
    }

    @Nonempty
    public @NonNull String getName() {
        return this.m_sName;
    }

    public @NonNull ECSSMetaUnit getMetaUnit() {
        return this.m_eMetaUnit;
    }

    @Nonempty
    public @NonNull String format(int n) {
        return Integer.toString(n) + this.m_sName;
    }

    @Nonempty
    public @NonNull String format(long l) {
        return Long.toString(l) + this.m_sName;
    }

    @Nonempty
    public @NonNull String format(double d) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(16);
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(d) + this.m_sName;
    }

    @Nonempty
    public @NonNull String format(@NonNull BigDecimal bigDecimal) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(16);
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(bigDecimal) + this.m_sName;
    }

    public static @Nullable ECSSUnit getFromNameOrNull(@Nullable String string) {
        return (ECSSUnit)EnumHelper.getFromNameOrNull(ECSSUnit.class, (String)string);
    }

    public static @Nullable ECSSUnit getFromNameOrDefault(@Nullable String string, @Nullable ECSSUnit eCSSUnit) {
        return (ECSSUnit)EnumHelper.getFromNameOrDefault(ECSSUnit.class, (String)string, (Enum)eCSSUnit);
    }

    @Nonempty
    public static @NonNull String em(int n) {
        return EM.format(n);
    }

    @Nonempty
    public static @NonNull String em(double d) {
        return EM.format(d);
    }

    @Nonempty
    public static @NonNull String em(@NonNull BigDecimal bigDecimal) {
        return EM.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String ex(int n) {
        return EX.format(n);
    }

    @Nonempty
    public static @NonNull String ex(double d) {
        return EX.format(d);
    }

    @Nonempty
    public static @NonNull String ex(@NonNull BigDecimal bigDecimal) {
        return EX.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String px(int n) {
        return PX.format(n);
    }

    @Nonempty
    public static @NonNull String px(double d) {
        return PX.format(d);
    }

    @Nonempty
    public static @NonNull String px(@NonNull BigDecimal bigDecimal) {
        return PX.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String rem(int n) {
        return REM.format(n);
    }

    @Nonempty
    public static @NonNull String rem(double d) {
        return REM.format(d);
    }

    @Nonempty
    public static @NonNull String rem(@NonNull BigDecimal bigDecimal) {
        return REM.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String vw(int n) {
        return VW.format(n);
    }

    @Nonempty
    public static @NonNull String vw(double d) {
        return VW.format(d);
    }

    @Nonempty
    public static @NonNull String vw(@NonNull BigDecimal bigDecimal) {
        return VW.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String vh(int n) {
        return VH.format(n);
    }

    @Nonempty
    public static @NonNull String vh(double d) {
        return VH.format(d);
    }

    @Nonempty
    public static @NonNull String vh(@NonNull BigDecimal bigDecimal) {
        return VH.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String vmin(int n) {
        return VMIN.format(n);
    }

    @Nonempty
    public static @NonNull String vmin(double d) {
        return VMIN.format(d);
    }

    @Nonempty
    public static @NonNull String vmin(@NonNull BigDecimal bigDecimal) {
        return VMIN.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String vmax(int n) {
        return VMAX.format(n);
    }

    @Nonempty
    public static @NonNull String vmax(double d) {
        return VMAX.format(d);
    }

    @Nonempty
    public static @NonNull String vmax(@NonNull BigDecimal bigDecimal) {
        return VMAX.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String ch(int n) {
        return CH.format(n);
    }

    @Nonempty
    public static @NonNull String ch(double d) {
        return CH.format(d);
    }

    @Nonempty
    public static @NonNull String ch(@NonNull BigDecimal bigDecimal) {
        return CH.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String in(int n) {
        return LENGTH_IN.format(n);
    }

    @Nonempty
    public static @NonNull String in(double d) {
        return LENGTH_IN.format(d);
    }

    @Nonempty
    public static @NonNull String in(@NonNull BigDecimal bigDecimal) {
        return LENGTH_IN.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String cm(int n) {
        return LENGTH_CM.format(n);
    }

    @Nonempty
    public static @NonNull String cm(double d) {
        return LENGTH_CM.format(d);
    }

    @Nonempty
    public static @NonNull String cm(@NonNull BigDecimal bigDecimal) {
        return LENGTH_CM.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String mm(int n) {
        return LENGTH_MM.format(n);
    }

    @Nonempty
    public static @NonNull String mm(double d) {
        return LENGTH_MM.format(d);
    }

    @Nonempty
    public static @NonNull String mm(@NonNull BigDecimal bigDecimal) {
        return LENGTH_MM.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String q(int n) {
        return LENGTH_Q.format(n);
    }

    @Nonempty
    public static @NonNull String q(double d) {
        return LENGTH_Q.format(d);
    }

    @Nonempty
    public static @NonNull String q(@NonNull BigDecimal bigDecimal) {
        return LENGTH_Q.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String pt(int n) {
        return LENGTH_PT.format(n);
    }

    @Nonempty
    public static @NonNull String pt(double d) {
        return LENGTH_PT.format(d);
    }

    @Nonempty
    public static @NonNull String pt(@NonNull BigDecimal bigDecimal) {
        return LENGTH_PT.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String pc(int n) {
        return LENGTH_PC.format(n);
    }

    @Nonempty
    public static @NonNull String pc(double d) {
        return LENGTH_PC.format(d);
    }

    @Nonempty
    public static @NonNull String pc(@NonNull BigDecimal bigDecimal) {
        return LENGTH_PC.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String perc(int n) {
        return PERCENTAGE.format(n);
    }

    @Nonempty
    public static @NonNull String perc(double d) {
        return PERCENTAGE.format(d);
    }

    @Nonempty
    public static @NonNull String perc(@NonNull BigDecimal bigDecimal) {
        return PERCENTAGE.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String deg(int n) {
        return ANGLE_DEG.format(n);
    }

    @Nonempty
    public static @NonNull String deg(double d) {
        return ANGLE_DEG.format(d);
    }

    @Nonempty
    public static @NonNull String deg(@NonNull BigDecimal bigDecimal) {
        return ANGLE_DEG.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String rad(int n) {
        return ANGLE_RAD.format(n);
    }

    @Nonempty
    public static @NonNull String rad(double d) {
        return ANGLE_RAD.format(d);
    }

    @Nonempty
    public static @NonNull String rad(@NonNull BigDecimal bigDecimal) {
        return ANGLE_RAD.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String grad(int n) {
        return ANGLE_GRAD.format(n);
    }

    @Nonempty
    public static @NonNull String grad(double d) {
        return ANGLE_GRAD.format(d);
    }

    @Nonempty
    public static @NonNull String grad(@NonNull BigDecimal bigDecimal) {
        return ANGLE_GRAD.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String turn(int n) {
        return ANGLE_TURN.format(n);
    }

    @Nonempty
    public static @NonNull String turn(double d) {
        return ANGLE_TURN.format(d);
    }

    @Nonempty
    public static @NonNull String turn(@NonNull BigDecimal bigDecimal) {
        return ANGLE_TURN.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String ms(int n) {
        return TIME_MS.format(n);
    }

    @Nonempty
    public static @NonNull String ms(double d) {
        return TIME_MS.format(d);
    }

    @Nonempty
    public static @NonNull String ms(@NonNull BigDecimal bigDecimal) {
        return TIME_MS.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String s(int n) {
        return TIME_S.format(n);
    }

    @Nonempty
    public static @NonNull String s(double d) {
        return TIME_S.format(d);
    }

    @Nonempty
    public static @NonNull String s(@NonNull BigDecimal bigDecimal) {
        return TIME_S.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String hz(int n) {
        return FREQ_HZ.format(n);
    }

    @Nonempty
    public static @NonNull String hz(double d) {
        return FREQ_HZ.format(d);
    }

    @Nonempty
    public static @NonNull String hz(@NonNull BigDecimal bigDecimal) {
        return FREQ_HZ.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String khz(int n) {
        return FREQ_KHZ.format(n);
    }

    @Nonempty
    public static @NonNull String khz(double d) {
        return FREQ_KHZ.format(d);
    }

    @Nonempty
    public static @NonNull String khz(@NonNull BigDecimal bigDecimal) {
        return FREQ_KHZ.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String dpi(int n) {
        return DPI.format(n);
    }

    @Nonempty
    public static @NonNull String dpi(double d) {
        return DPI.format(d);
    }

    @Nonempty
    public static @NonNull String dpi(@NonNull BigDecimal bigDecimal) {
        return DPI.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String dpcm(int n) {
        return DPCM.format(n);
    }

    @Nonempty
    public static @NonNull String dpcm(double d) {
        return DPCM.format(d);
    }

    @Nonempty
    public static @NonNull String dpcm(@NonNull BigDecimal bigDecimal) {
        return DPCM.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String dppx(int n) {
        return DPPX.format(n);
    }

    @Nonempty
    public static @NonNull String dppx(double d) {
        return DPPX.format(d);
    }

    @Nonempty
    public static @NonNull String dppx(@NonNull BigDecimal bigDecimal) {
        return DPPX.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String fr(int n) {
        return FR.format(n);
    }

    @Nonempty
    public static @NonNull String fr(double d) {
        return FR.format(d);
    }

    @Nonempty
    public static @NonNull String fr(@NonNull BigDecimal bigDecimal) {
        return FR.format(bigDecimal);
    }

    @Nonempty
    public static @NonNull String zero() {
        return "0";
    }

    static {
        LENGTH_PX = PX;
    }
}

