/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSTopLevelRule;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class CSSUnknownRule
implements ICSSTopLevelRule,
ICSSSourceLocationAware {
    private final String m_sDeclaration;
    private String m_sParameterList;
    private String m_sBody;
    private CSSSourceLocation m_aSourceLocation;

    public static boolean isValidDeclaration(@Nonnull @Nonempty String string) {
        return StringHelper.startsWith((CharSequence)string, (char)'@');
    }

    public CSSUnknownRule(@Nonnull @Nonempty String string) {
        if (!CSSUnknownRule.isValidDeclaration(string)) {
            throw new IllegalArgumentException("declaration");
        }
        this.m_sDeclaration = string;
    }

    @Nonnull
    @Nonempty
    public String getDeclaration() {
        return this.m_sDeclaration;
    }

    @Nonnull
    public CSSUnknownRule setParameterList(@Nullable String string) {
        this.m_sParameterList = StringHelper.trim((String)string);
        return this;
    }

    @Nullable
    public String getParameterList() {
        return this.m_sParameterList;
    }

    @Nonnull
    public CSSUnknownRule setBody(@Nullable String string) {
        this.m_sBody = StringHelper.trim((String)string);
        return this;
    }

    @Nullable
    public String getBody() {
        return this.m_sBody;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (!iCSSWriterSettings.isWriteUnknownRules()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder(this.m_sDeclaration);
        if (StringHelper.isNotEmpty((String)this.m_sParameterList)) {
            stringBuilder.append(' ').append(this.m_sParameterList);
        }
        if (StringHelper.isEmpty((String)this.m_sBody)) {
            stringBuilder.append((String)(bl ? "{}" : " {}" + iCSSWriterSettings.getNewLineString()));
        } else {
            stringBuilder.append((String)(bl ? "{" : " {" + iCSSWriterSettings.getNewLineString()));
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n));
            }
            stringBuilder.append(this.m_sBody);
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n));
            }
            stringBuilder.append('}');
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getNewLineString());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSUnknownRule cSSUnknownRule = (CSSUnknownRule)object;
        return this.m_sDeclaration.equals(cSSUnknownRule.m_sDeclaration) && EqualsHelper.equals((Object)this.m_sParameterList, (Object)cSSUnknownRule.m_sParameterList) && EqualsHelper.equals((Object)this.m_sBody, (Object)cSSUnknownRule.m_sBody);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sDeclaration).append((Object)this.m_sParameterList).append((Object)this.m_sBody).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declaration", (Object)this.m_sDeclaration).appendIfNotNull("parameterList", (Object)this.m_sParameterList).appendIfNotNull("body", (Object)this.m_sBody).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

