/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.parser;

import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.string.StringHelper;
import com.helger.css.parser.AbstractParserCSS;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.CSSParseHelper;
import com.helger.css.parser.CharStream;
import com.helger.css.parser.JJTParserCSS30State;
import com.helger.css.parser.Node;
import com.helger.css.parser.ParseEOFException;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.ParserCSS30Constants;
import com.helger.css.parser.ParserCSS30TokenManager;
import com.helger.css.parser.ParserCSS30TreeConstants;
import com.helger.css.parser.Token;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserCSS30
extends AbstractParserCSS
implements ParserCSS30TreeConstants,
ParserCSS30Constants {
    protected JJTParserCSS30State jjtree = new JJTParserCSS30State();
    private static final Logger LOGGER = LoggerFactory.getLogger(ParserCSS30.class);
    public ParserCSS30TokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[206];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[19];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private void errorDeprecatedProperty(Token token) throws ParseException, ParseException {
        if (this.m_bBrowserCompliantMode) {
            if (this.m_aCustomErrorHandler != null) {
                this.m_aCustomErrorHandler.onCSSDeprecatedProperty(token, this.token);
            } else {
                LOGGER.warn("[" + token.beginLine + ":" + token.beginColumn + "] Deprecated property name '" + token.image + this.token.image + "'");
            }
        } else {
            ParseException parseException = new ParseException(token, new int[][]{{90}}, tokenImage, this.token_source == null ? null : ParserCSS30TokenManager.lexStateNames[this.token_source.curLexState]);
            throw parseException;
        }
    }

    private void errorUnexpectedRule(String string, String string2) throws ParseException {
        if (this.m_aCustomErrorHandler != null) {
            this.m_aCustomErrorHandler.onCSSUnexpectedRule(this.token, string, string2);
        } else {
            LOGGER.warn("[" + this.token.beginLine + ":" + this.token.beginColumn + "] Unexpected rule '" + string + "': " + string2);
        }
    }

    private Token errorSkipTo(ParseException parseException, int ... nArray) throws ParseException, ParseException {
        CSSNode cSSNode = new CSSNode(1);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            Token token;
            do {
                token = this.getNextToken();
                if (token.kind != 0) continue;
                throw parseException;
            } while (!ArrayHelper.contains((int[])nArray, (int)token.kind));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Skipped until token " + token.toString());
            }
            if (this.m_aCustomErrorHandler != null) {
                this.m_aCustomErrorHandler.onCSSParseError(parseException, token);
            } else {
                LOGGER.warn("CSS recoverable parse error", (Throwable)parseException);
            }
            Token token2 = token;
            return token2;
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    private String javaSkipToClosingParantheses() throws ParseException, ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        while (true) {
            Token token = this.getNextToken();
            stringBuilder.append(token.image);
            if (token.kind == 11) {
                ++n;
                continue;
            }
            if (token.kind == 12) {
                if (--n > 0) continue;
                break;
            }
            if (token.kind == 0) {
                throw new ParseEOFException("EOF while searching for matching closing ')'.");
            }
            n += StringHelper.getCharCount((String)token.image, (char)'(');
            n -= StringHelper.getCharCount((String)token.image, (char)')');
        }
        return stringBuilder.toString();
    }

    private String javaSkipToOpeningBrace() throws ParseException, ParseException {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            Token token = this.getNextToken();
            if (token.kind == 0) {
                throw new ParseEOFException("EOF while searching for opening '{'.");
            }
            if (token.kind == 32) break;
            stringBuilder.append(token.image);
        }
        return stringBuilder.toString();
    }

    private String javaSkipToClosingBrace(int n) throws ParseException, ParseEOFException {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n;
        while (true) {
            Token token = this.getNextToken();
            if (token.kind == 32) {
                ++n2;
            } else if (token.kind == 33) {
                if (--n2 <= 0) {
                    break;
                }
            } else if (token.kind == 0) {
                throw new ParseEOFException("EOF while searching for matching closing '}'.");
            }
            stringBuilder.append(token.image);
        }
        return stringBuilder.toString();
    }

    private String javaSkipToClosingBraceOrSemicolon(int n) throws ParseException, ParseEOFException {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n;
        while (true) {
            Token token = this.getNextToken();
            if (token.kind == 32) {
                ++n2;
            } else if (token.kind == 33) {
                if (--n2 <= 0) {
                    break;
                }
            } else if (token.kind == 38) {
                if (n2 == 1) {
                    break;
                }
            } else if (token.kind == 0) {
                throw new ParseEOFException("EOF while searching for matching closing '}' or ';'.");
            }
            stringBuilder.append(token.image);
        }
        return stringBuilder.toString();
    }

    private void browserCompliantSkipInRule(ParseException parseException) throws ParseException, ParseEOFException {
        this.javaSkipToClosingBrace(1);
        this.token_source.backup(1);
        if (this.m_aCustomErrorHandler != null) {
            this.m_aCustomErrorHandler.onCSSBrowserCompliantSkip(parseException, parseException.currentToken, this.token);
        }
    }

    private void browserCompliantSkipInSelector(ParseException parseException) throws ParseException, ParseEOFException {
        this.javaSkipToClosingBrace(0);
        this.token_source.backup(1);
        if (this.m_aCustomErrorHandler != null) {
            this.m_aCustomErrorHandler.onCSSBrowserCompliantSkip(parseException, parseException.currentToken, this.token);
        }
    }

    private void browserCompliantSkipStylesheet(ParseException parseException) throws ParseException, ParseEOFException {
        this.javaSkipToClosingBrace(0);
        if (this.m_aCustomErrorHandler != null) {
            this.m_aCustomErrorHandler.onCSSBrowserCompliantSkip(parseException, parseException.currentToken, this.token);
        }
    }

    private void browserCompliantSkipDecl(ParseException parseException) throws ParseException, ParseEOFException {
        this.javaSkipToClosingBraceOrSemicolon(1);
        this.token_source.backup(1);
        if (this.m_aCustomErrorHandler != null) {
            this.m_aCustomErrorHandler.onCSSBrowserCompliantSkip(parseException, parseException.currentToken, this.token);
        }
    }

    public final CSSNode styleSheet() throws ParseException {
        CSSNode cSSNode = new CSSNode(2);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            try {
                block103: {
                    block102: {
                        block84: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: 
                                case 53: 
                                case 54: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[0] = this.jj_gen;
                                    break block102;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    this.jj_consume_token(4);
                                    continue block84;
                                }
                                case 53: {
                                    this.jj_consume_token(53);
                                    continue block84;
                                }
                                case 54: {
                                    this.jj_consume_token(54);
                                    continue block84;
                                }
                            }
                            break;
                        }
                        this.jj_la1[1] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    if (this.jj_2_1(Integer.MAX_VALUE)) {
                        this.charsetRule();
                        block85: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: 
                                case 53: 
                                case 54: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[2] = this.jj_gen;
                                    break block103;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    this.jj_consume_token(4);
                                    continue block85;
                                }
                                case 53: {
                                    this.jj_consume_token(53);
                                    continue block85;
                                }
                                case 54: {
                                    this.jj_consume_token(54);
                                    continue block85;
                                }
                            }
                            break;
                        }
                        this.jj_la1[3] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block86: while (this.jj_2_2(Integer.MAX_VALUE)) {
                    this.importRule();
                    block87: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: 
                            case 53: 
                            case 54: {
                                break;
                            }
                            default: {
                                this.jj_la1[4] = this.jj_gen;
                                continue block86;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                this.jj_consume_token(4);
                                continue block87;
                            }
                            case 53: {
                                this.jj_consume_token(53);
                                continue block87;
                            }
                            case 54: {
                                this.jj_consume_token(54);
                                continue block87;
                            }
                        }
                        break;
                    }
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                block88: while (this.jj_2_3(Integer.MAX_VALUE)) {
                    this.namespaceRule();
                    block89: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: 
                            case 53: 
                            case 54: {
                                break;
                            }
                            default: {
                                this.jj_la1[6] = this.jj_gen;
                                continue block88;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                this.jj_consume_token(4);
                                continue block89;
                            }
                            case 53: {
                                this.jj_consume_token(53);
                                continue block89;
                            }
                            case 54: {
                                this.jj_consume_token(54);
                                continue block89;
                            }
                        }
                        break;
                    }
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                block90: while (true) {
                    block105: {
                        block104: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 34: 
                                case 36: 
                                case 39: 
                                case 40: 
                                case 43: 
                                case 47: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 58: 
                                case 59: 
                                case 60: 
                                case 61: 
                                case 62: 
                                case 63: 
                                case 64: 
                                case 65: 
                                case 66: 
                                case 67: 
                                case 68: 
                                case 69: 
                                case 70: 
                                case 71: 
                                case 72: 
                                case 73: 
                                case 74: 
                                case 75: 
                                case 76: 
                                case 77: 
                                case 78: 
                                case 79: 
                                case 80: 
                                case 81: 
                                case 90: 
                                case 91: 
                                case 96: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[8] = this.jj_gen;
                                    break block90;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 34: 
                                case 36: 
                                case 39: 
                                case 40: 
                                case 43: 
                                case 47: 
                                case 90: 
                                case 91: 
                                case 96: {
                                    this.styleRule();
                                    break;
                                }
                                case 76: {
                                    this.mediaRule();
                                    break;
                                }
                                case 58: {
                                    this.pageRule();
                                    break;
                                }
                                case 77: {
                                    this.fontfaceRule();
                                    break;
                                }
                                case 78: {
                                    this.keyframesRule();
                                    break;
                                }
                                case 79: {
                                    this.viewportRule();
                                    break;
                                }
                                case 80: {
                                    this.supportsRule();
                                    break;
                                }
                                case 59: 
                                case 60: 
                                case 61: 
                                case 62: 
                                case 63: 
                                case 64: 
                                case 65: 
                                case 66: 
                                case 67: 
                                case 68: 
                                case 69: 
                                case 70: 
                                case 71: 
                                case 72: 
                                case 73: 
                                case 74: 
                                case 75: 
                                case 81: {
                                    this.unknownRule();
                                    break;
                                }
                                case 55: {
                                    this.charsetRule();
                                    this.errorUnexpectedRule("@charset", "charset rule in the middle of the file is not allowed!");
                                    break;
                                }
                                case 56: {
                                    this.importRule();
                                    this.errorUnexpectedRule("@import", "import rule in the middle of the file is not allowed!");
                                    break;
                                }
                                case 57: {
                                    this.namespaceRule();
                                    this.errorUnexpectedRule("@namespace", "namespace rule in the middle of the file is not allowed!");
                                    break;
                                }
                                default: {
                                    this.jj_la1[9] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            block91: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 4: 
                                    case 53: 
                                    case 54: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[10] = this.jj_gen;
                                        break block104;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 4: {
                                        this.jj_consume_token(4);
                                        continue block91;
                                    }
                                    case 53: {
                                        this.jj_consume_token(53);
                                        continue block91;
                                    }
                                    case 54: {
                                        this.jj_consume_token(54);
                                        continue block91;
                                    }
                                }
                                break;
                            }
                            this.jj_la1[11] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        block92: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 33: 
                                case 38: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[12] = this.jj_gen;
                                    break block105;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 33: {
                                    this.jj_consume_token(33);
                                    break;
                                }
                                case 38: {
                                    this.jj_consume_token(38);
                                    break;
                                }
                                default: {
                                    this.jj_la1[13] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            block93: while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 4: 
                                    case 53: 
                                    case 54: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[14] = this.jj_gen;
                                        continue block92;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 4: {
                                        this.jj_consume_token(4);
                                        continue block93;
                                    }
                                    case 53: {
                                        this.jj_consume_token(53);
                                        continue block93;
                                    }
                                    case 54: {
                                        this.jj_consume_token(54);
                                        continue block93;
                                    }
                                }
                                break;
                            }
                            break;
                        }
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 108: {
                            this.syntaxCrap();
                            continue block90;
                        }
                    }
                    this.jj_la1[16] = this.jj_gen;
                }
                this.jj_consume_token(0);
            }
            catch (ParseEOFException parseEOFException) {
                if (!this.m_bBrowserCompliantMode) {
                    throw parseEOFException;
                }
            }
            catch (ParseException parseException) {
                if (this.m_bBrowserCompliantMode) {
                    try {
                        this.browserCompliantSkipStylesheet(parseException);
                        this.styleSheet();
                    }
                    catch (ParseEOFException parseEOFException) {}
                }
                throw parseException;
            }
            this.jjtree.closeNodeScope((Node)cSSNode, true);
            bl = false;
            cSSNode.jjtSetLastToken(this.getToken(0));
            CSSNode cSSNode2 = cSSNode;
            return cSSNode2;
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void syntaxCrap() throws ParseException {
        this.jj_consume_token(108);
    }

    public final String string() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final String anyIdentifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                break;
            }
            case 85: {
                this.jj_consume_token(85);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            case 88: {
                this.jj_consume_token(88);
                break;
            }
            case 89: {
                this.jj_consume_token(89);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final void url() throws ParseException {
        CSSNode cSSNode = new CSSNode(3);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(94);
            this.jjtree.closeNodeScope((Node)cSSNode, true);
            bl = false;
            cSSNode.jjtSetLastToken(this.getToken(0));
            cSSNode.setText(this.token.image);
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void function() throws ParseException {
        CSSNode cSSNode = new CSSNode(4);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 105: {
                    this.jj_consume_token(105);
                    cSSNode.setText(this.token.image + ")");
                    block15: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[19] = this.jj_gen;
                                break block15;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 9: 
                        case 10: 
                        case 22: 
                        case 23: 
                        case 31: 
                        case 34: 
                        case 47: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 94: 
                        case 95: 
                        case 104: 
                        case 105: 
                        case 106: {
                            this.expr();
                            break;
                        }
                        default: {
                            this.jj_la1[20] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(12);
                    return;
                }
                case 104: {
                    this.jj_consume_token(104);
                    cSSNode.setText(this.token.image);
                    String string = this.javaSkipToClosingParantheses();
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.appendText(string);
                    return;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
            throw (RuntimeException)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final String unaryOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final Token dimension() throws ParseException {
        Token token = this.jj_consume_token(92);
        return token;
    }

    public final void calcValue() throws ParseException {
        CSSNode cSSNode = new CSSNode(5);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        String string = null;
        Token token = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: {
                    string = this.unaryOperator();
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 31: {
                    token = this.jj_consume_token(31);
                    break;
                }
                case 91: {
                    token = this.jj_consume_token(91);
                    break;
                }
                case 92: {
                    token = this.dimension();
                    break;
                }
                case 104: 
                case 105: {
                    this.function();
                    break;
                }
                case 95: {
                    this.calc();
                    break;
                }
                case 11: {
                    this.jj_consume_token(11);
                    block22: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[24] = this.jj_gen;
                                break block22;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.calcSum();
                    block23: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[25] = this.jj_gen;
                                break block23;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.jj_consume_token(12);
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)cSSNode, true);
            bl = false;
            cSSNode.jjtSetLastToken(this.getToken(0));
            if (string != null) {
                cSSNode.appendText(string);
            }
            if (token != null) {
                cSSNode.appendText(token.image);
            }
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void calcProductOperator() throws ParseException {
        CSSNode cSSNode = new CSSNode(6);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 40: {
                    this.jj_consume_token(40);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText("*");
                    return;
                }
                case 41: {
                    this.jj_consume_token(41);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText("/");
                    return;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void calcProduct() throws ParseException {
        CSSNode cSSNode = new CSSNode(7);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.calcValue();
            while (this.jj_2_4(2)) {
                block12: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[28] = this.jj_gen;
                            break block12;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.calcProductOperator();
                block13: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[29] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.calcValue();
            }
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void calcSumOperator() throws ParseException {
        CSSNode cSSNode = new CSSNode(8);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: {
                    this.jj_consume_token(9);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText("+");
                    return;
                }
                case 10: {
                    this.jj_consume_token(10);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText("-");
                    return;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void calcSum() throws ParseException {
        this.calcProduct();
        while (this.jj_2_5(2)) {
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[31] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(4);
            }
            this.calcSumOperator();
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(4);
            }
            this.calcProduct();
        }
    }

    public final void calc() throws ParseException {
        CSSNode cSSNode = new CSSNode(9);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(95);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(4);
            }
            this.calcSum();
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(4);
            }
            this.jj_consume_token(12);
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void lineName() throws ParseException {
        CSSNode cSSNode = new CSSNode(10);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(90);
            this.jjtree.closeNodeScope((Node)cSSNode, true);
            bl = false;
            cSSNode.jjtSetLastToken(this.getToken(0));
            cSSNode.setText(this.token.image);
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void lineNames() throws ParseException {
        CSSNode cSSNode = new CSSNode(11);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(34);
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[35] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(4);
            }
            block5 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 90: {
                    this.lineName();
                    while (this.jj_2_6(2)) {
                        block19: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[36] = this.jj_gen;
                                    break block19;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        this.lineName();
                    }
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[37] = this.jj_gen;
                                break block5;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                }
            }
            this.jj_consume_token(35);
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void exprTerm() throws ParseException {
        CSSNode cSSNode = new CSSNode(12);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        String string = null;
        Token token = null;
        try {
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 9: 
                case 10: 
                case 31: 
                case 91: 
                case 92: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 9: 
                        case 10: {
                            string = this.unaryOperator();
                            break;
                        }
                        default: {
                            this.jj_la1[39] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 31: {
                            token = this.jj_consume_token(31);
                            break block2;
                        }
                        case 91: {
                            token = this.jj_consume_token(91);
                            break block2;
                        }
                        case 92: {
                            token = this.dimension();
                            break block2;
                        }
                    }
                    this.jj_la1[40] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                case 22: 
                case 23: {
                    string = this.string();
                    break;
                }
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    string = this.anyIdentifier();
                    break;
                }
                case 94: {
                    this.url();
                    break;
                }
                case 47: {
                    token = this.jj_consume_token(47);
                    break;
                }
                case 104: 
                case 105: {
                    this.function();
                    break;
                }
                case 95: {
                    this.calc();
                    break;
                }
                case 106: {
                    token = this.jj_consume_token(106);
                    break;
                }
                case 34: {
                    this.lineNames();
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block27: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[42] = this.jj_gen;
                        break block27;
                    }
                }
                this.jj_consume_token(4);
            }
            this.jjtree.closeNodeScope((Node)cSSNode, true);
            bl = false;
            cSSNode.jjtSetLastToken(this.getToken(0));
            if (string != null) {
                cSSNode.appendText(string);
            }
            if (token != null) {
                cSSNode.appendText(token.image);
            }
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void exprOperator() throws ParseException {
        CSSNode cSSNode = new CSSNode(13);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 41: {
                    this.jj_consume_token(41);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText("/");
                    return;
                }
                case 37: {
                    this.jj_consume_token(37);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(",");
                    return;
                }
                case 42: {
                    this.jj_consume_token(42);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText("=");
                    return;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void expr() throws ParseException {
        block25: {
            CSSNode cSSNode = new CSSNode(14);
            boolean bl = true;
            this.jjtree.openNodeScope(cSSNode);
            cSSNode.jjtSetFirstToken(this.getToken(1));
            try {
                this.exprTerm();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: 
                        case 9: 
                        case 10: 
                        case 22: 
                        case 23: 
                        case 31: 
                        case 34: 
                        case 37: 
                        case 41: 
                        case 42: 
                        case 47: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 94: 
                        case 95: 
                        case 104: 
                        case 105: 
                        case 106: {
                            break;
                        }
                        default: {
                            this.jj_la1[44] = this.jj_gen;
                            break block25;
                        }
                    }
                    block18: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[45] = this.jj_gen;
                                break block18;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    block8 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 37: 
                        case 41: 
                        case 42: {
                            this.exprOperator();
                            while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 4: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[46] = this.jj_gen;
                                        break block8;
                                    }
                                }
                                this.jj_consume_token(4);
                            }
                        }
                        default: {
                            this.jj_la1[47] = this.jj_gen;
                        }
                    }
                    this.exprTerm();
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.jjtree.clearNodeScope(cSSNode);
                    bl = false;
                } else {
                    this.jjtree.popNode();
                }
                if (throwable instanceof ParseException) {
                    throw (ParseException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            finally {
                if (bl) {
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    cSSNode.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void charsetRule() throws ParseException {
        CSSNode cSSNode = new CSSNode(15);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(55);
            block11: while (true) {
                this.jj_consume_token(4);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[48] = this.jj_gen;
            String string = this.string();
            cSSNode.setText(string);
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[49] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(4);
            }
            this.jj_consume_token(38);
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void importRule() throws ParseException {
        CSSNode cSSNode = new CSSNode(16);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(56);
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[50] = this.jj_gen;
                        break block18;
                    }
                }
                this.jj_consume_token(4);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 22: 
                case 23: {
                    String string = this.string();
                    cSSNode.setText(string);
                    break;
                }
                case 94: {
                    this.url();
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                        break block19;
                    }
                }
                this.jj_consume_token(4);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: 
                case 85: 
                case 86: 
                case 90: {
                    this.mediaList();
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                }
            }
            this.jj_consume_token(38);
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void namespaceRulePrefix() throws ParseException {
        CSSNode cSSNode = new CSSNode(17);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(90);
            this.jjtree.closeNodeScope((Node)cSSNode, true);
            bl = false;
            cSSNode.jjtSetLastToken(this.getToken(0));
            cSSNode.setText(this.token.image);
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void namespaceRuleURL() throws ParseException {
        CSSNode cSSNode = new CSSNode(18);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 94: {
                    this.jj_consume_token(94);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 22: 
                case 23: {
                    String string = this.string();
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(CSSParseHelper.unescapeURL(string));
                    return;
                }
                default: {
                    this.jj_la1[54] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
            throw (RuntimeException)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void namespaceRule() throws ParseException {
        CSSNode cSSNode = new CSSNode(19);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(57);
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[55] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(4);
            }
            block5 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 90: {
                    this.namespaceRulePrefix();
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[56] = this.jj_gen;
                                break block5;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                }
                default: {
                    this.jj_la1[57] = this.jj_gen;
                }
            }
            this.namespaceRuleURL();
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[58] = this.jj_gen;
                        break block19;
                    }
                }
                this.jj_consume_token(4);
            }
            this.jj_consume_token(38);
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void namespacePrefix() throws ParseException {
        CSSNode cSSNode = new CSSNode(20);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            block1 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 40: 
                case 90: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 90: {
                            this.jj_consume_token(90);
                            cSSNode.setText(this.token.image);
                            break block1;
                        }
                        case 40: {
                            this.jj_consume_token(40);
                            cSSNode.setText(this.token.image);
                            break block1;
                        }
                    }
                    this.jj_la1[59] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                }
            }
            this.jj_consume_token(43);
            this.jjtree.closeNodeScope((Node)cSSNode, true);
            bl = false;
            cSSNode.jjtSetLastToken(this.getToken(0));
            cSSNode.appendText("|");
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void elementName() throws ParseException {
        CSSNode cSSNode = new CSSNode(21);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 90: {
                    this.jj_consume_token(90);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 40: {
                    this.jj_consume_token(40);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                default: {
                    this.jj_la1[61] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void typeSelector() throws ParseException {
        if (this.jj_2_7(2)) {
            this.namespacePrefix();
        }
        this.elementName();
    }

    public final void idSelector() throws ParseException {
        CSSNode cSSNode = new CSSNode(22);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(47);
            this.jjtree.closeNodeScope((Node)cSSNode, true);
            bl = false;
            cSSNode.jjtSetLastToken(this.getToken(0));
            cSSNode.setText(this.token.image);
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void classSelector() throws ParseException {
        CSSNode cSSNode = new CSSNode(23);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(36);
            String string = this.anyIdentifier();
            this.jjtree.closeNodeScope((Node)cSSNode, true);
            bl = false;
            cSSNode.jjtSetLastToken(this.getToken(0));
            cSSNode.setText("." + string);
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void attribOperator() throws ParseException {
        CSSNode cSSNode = new CSSNode(24);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 42: {
                    this.jj_consume_token(42);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText("=");
                    return;
                }
                case 48: {
                    this.jj_consume_token(48);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText("~=");
                    return;
                }
                case 49: {
                    this.jj_consume_token(49);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText("|=");
                    return;
                }
                case 50: {
                    this.jj_consume_token(50);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText("^=");
                    return;
                }
                case 51: {
                    this.jj_consume_token(51);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText("$=");
                    return;
                }
                case 52: {
                    this.jj_consume_token(52);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText("*=");
                    return;
                }
                default: {
                    this.jj_la1[62] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void attribValue() throws ParseException {
        CSSNode cSSNode = new CSSNode(25);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 90: {
                    this.jj_consume_token(90);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 22: 
                case 23: {
                    String string = this.string();
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(string);
                    return;
                }
                default: {
                    this.jj_la1[63] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
            throw (RuntimeException)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void attributeSelector() throws ParseException {
        CSSNode cSSNode = new CSSNode(26);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(34);
            block23: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[64] = this.jj_gen;
                        break block23;
                    }
                }
                this.jj_consume_token(4);
            }
            if (this.jj_2_8(2)) {
                this.namespacePrefix();
            }
            this.jj_consume_token(90);
            cSSNode.setText(this.token.image);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 40: {
                    this.jj_consume_token(40);
                    cSSNode.appendText("*");
                    break;
                }
                default: {
                    this.jj_la1[65] = this.jj_gen;
                }
            }
            block24: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[66] = this.jj_gen;
                        break block24;
                    }
                }
                this.jj_consume_token(4);
            }
            block11 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 42: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: {
                    this.attribOperator();
                    block25: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[67] = this.jj_gen;
                                break block25;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.attribValue();
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[68] = this.jj_gen;
                                break block11;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                }
                default: {
                    this.jj_la1[69] = this.jj_gen;
                }
            }
            this.jj_consume_token(35);
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void pseudoNth() throws ParseException {
        block44: {
            CSSNode cSSNode = new CSSNode(27);
            boolean bl = true;
            this.jjtree.openNodeScope(cSSNode);
            cSSNode.jjtSetFirstToken(this.getToken(1));
            try {
                Token token;
                String string;
                block30: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[70] = this.jj_gen;
                            break block30;
                        }
                    }
                    this.jj_consume_token(4);
                }
                if (this.jj_2_10(3)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 9: 
                        case 10: {
                            string = this.unaryOperator();
                            cSSNode.appendText(string);
                            break;
                        }
                        default: {
                            this.jj_la1[71] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 8: {
                            token = this.jj_consume_token(8);
                            cSSNode.appendText(token.image);
                            break;
                        }
                        default: {
                            this.jj_la1[72] = this.jj_gen;
                        }
                    }
                    token = this.jj_consume_token(5);
                    cSSNode.appendText("n");
                    if (this.jj_2_9(2)) {
                        block31: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[73] = this.jj_gen;
                                    break block31;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        string = this.unaryOperator();
                        cSSNode.appendText(string);
                        block32: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[74] = this.jj_gen;
                                    break block32;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        token = this.jj_consume_token(8);
                        cSSNode.appendText(token.image);
                    }
                } else if (this.jj_2_11(2)) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 9: 
                        case 10: {
                            string = this.unaryOperator();
                            cSSNode.appendText(string);
                            break;
                        }
                        default: {
                            this.jj_la1[75] = this.jj_gen;
                        }
                    }
                    token = this.jj_consume_token(8);
                    cSSNode.appendText(token.image);
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 7: {
                            token = this.jj_consume_token(7);
                            cSSNode.appendText(token.image);
                            break;
                        }
                        case 6: {
                            token = this.jj_consume_token(6);
                            cSSNode.appendText(token.image);
                            break;
                        }
                        default: {
                            this.jj_la1[76] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[77] = this.jj_gen;
                            break block44;
                        }
                    }
                    this.jj_consume_token(4);
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.jjtree.clearNodeScope(cSSNode);
                    bl = false;
                } else {
                    this.jjtree.popNode();
                }
                if (throwable instanceof ParseException) {
                    throw (ParseException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            finally {
                if (bl) {
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    cSSNode.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void pseudoHost() throws ParseException {
        block22: {
            CSSNode cSSNode = new CSSNode(28);
            boolean bl = true;
            this.jjtree.openNodeScope(cSSNode);
            cSSNode.jjtSetFirstToken(this.getToken(1));
            try {
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[78] = this.jj_gen;
                            break block14;
                        }
                    }
                    this.jj_consume_token(4);
                }
                block15: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 34: 
                        case 36: 
                        case 39: 
                        case 40: 
                        case 43: 
                        case 47: 
                        case 90: 
                        case 91: 
                        case 96: {
                            break;
                        }
                        default: {
                            this.jj_la1[79] = this.jj_gen;
                            break block22;
                        }
                    }
                    this.simpleSelectorSequence();
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[80] = this.jj_gen;
                                continue block15;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.jjtree.clearNodeScope(cSSNode);
                    bl = false;
                } else {
                    this.jjtree.popNode();
                }
                if (throwable instanceof ParseException) {
                    throw (ParseException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            finally {
                if (bl) {
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    cSSNode.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void pseudoHostContext() throws ParseException {
        block22: {
            CSSNode cSSNode = new CSSNode(29);
            boolean bl = true;
            this.jjtree.openNodeScope(cSSNode);
            cSSNode.jjtSetFirstToken(this.getToken(1));
            try {
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[81] = this.jj_gen;
                            break block14;
                        }
                    }
                    this.jj_consume_token(4);
                }
                block15: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 34: 
                        case 36: 
                        case 39: 
                        case 40: 
                        case 43: 
                        case 47: 
                        case 90: 
                        case 91: 
                        case 96: {
                            break;
                        }
                        default: {
                            this.jj_la1[82] = this.jj_gen;
                            break block22;
                        }
                    }
                    this.simpleSelectorSequence();
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[83] = this.jj_gen;
                                continue block15;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.jjtree.clearNodeScope(cSSNode);
                    bl = false;
                } else {
                    this.jjtree.popNode();
                }
                if (throwable instanceof ParseException) {
                    throw (ParseException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            finally {
                if (bl) {
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    cSSNode.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void pseudoSlotted() throws ParseException {
        block22: {
            CSSNode cSSNode = new CSSNode(30);
            boolean bl = true;
            this.jjtree.openNodeScope(cSSNode);
            cSSNode.jjtSetFirstToken(this.getToken(1));
            try {
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[84] = this.jj_gen;
                            break block14;
                        }
                    }
                    this.jj_consume_token(4);
                }
                block15: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 34: 
                        case 36: 
                        case 39: 
                        case 40: 
                        case 43: 
                        case 47: 
                        case 90: 
                        case 91: 
                        case 96: {
                            break;
                        }
                        default: {
                            this.jj_la1[85] = this.jj_gen;
                            break block22;
                        }
                    }
                    this.simpleSelectorSequence();
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[86] = this.jj_gen;
                                continue block15;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.jjtree.clearNodeScope(cSSNode);
                    bl = false;
                } else {
                    this.jjtree.popNode();
                }
                if (throwable instanceof ParseException) {
                    throw (ParseException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            finally {
                if (bl) {
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    cSSNode.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void relativeSelector() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 4: 
            case 9: 
            case 44: 
            case 45: {
                this.selectorCombinator();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[87] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(4);
                }
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
            }
        }
        this.selector();
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 4: {
                    break;
                }
                default: {
                    this.jj_la1[89] = this.jj_gen;
                    break block19;
                }
            }
            this.jj_consume_token(4);
        }
        block20: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 37: {
                    break;
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                    break block20;
                }
            }
            this.jj_consume_token(37);
            block21: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[91] = this.jj_gen;
                        break block21;
                    }
                }
                this.jj_consume_token(4);
            }
            this.selector();
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[92] = this.jj_gen;
                        continue block20;
                    }
                }
                this.jj_consume_token(4);
            }
            break;
        }
    }

    public final void relativeSelectorList() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 4: 
                case 9: 
                case 34: 
                case 36: 
                case 39: 
                case 40: 
                case 43: 
                case 44: 
                case 45: 
                case 47: 
                case 90: 
                case 91: 
                case 96: {
                    break;
                }
                default: {
                    this.jj_la1[93] = this.jj_gen;
                    break block3;
                }
            }
            this.relativeSelector();
        }
    }

    public final void pseudoHas() throws ParseException {
        CSSNode cSSNode = new CSSNode(31);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[94] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(4);
            }
            this.relativeSelectorList();
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void pseudoIs() throws ParseException {
        CSSNode cSSNode = new CSSNode(32);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[95] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(4);
            }
            this.selector();
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void pseudoWhere() throws ParseException {
        CSSNode cSSNode = new CSSNode(33);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[96] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(4);
            }
            this.selector();
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void pseudoClassSelector() throws ParseException {
        CSSNode cSSNode = new CSSNode(34);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(39);
            cSSNode.setText(":");
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 39: {
                    this.jj_consume_token(39);
                    cSSNode.appendText(":");
                    break;
                }
                default: {
                    this.jj_la1[97] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 103: {
                    this.jj_consume_token(103);
                    cSSNode.appendText(this.token.image);
                    this.pseudoNth();
                    this.jj_consume_token(12);
                    return;
                }
                case 99: {
                    this.jj_consume_token(99);
                    cSSNode.appendText(this.token.image);
                    this.pseudoHost();
                    this.jj_consume_token(12);
                    return;
                }
                case 101: {
                    this.jj_consume_token(101);
                    cSSNode.appendText(this.token.image);
                    this.pseudoHostContext();
                    this.jj_consume_token(12);
                    return;
                }
                case 102: {
                    this.jj_consume_token(102);
                    cSSNode.appendText(this.token.image);
                    this.pseudoSlotted();
                    this.jj_consume_token(12);
                    return;
                }
                case 98: {
                    this.jj_consume_token(98);
                    cSSNode.setText(this.token.image);
                    this.pseudoHas();
                    this.jj_consume_token(12);
                    return;
                }
                case 97: {
                    this.jj_consume_token(97);
                    cSSNode.setText(this.token.image);
                    this.pseudoIs();
                    this.jj_consume_token(12);
                    return;
                }
                case 100: {
                    this.jj_consume_token(100);
                    cSSNode.setText(this.token.image);
                    this.pseudoWhere();
                    this.jj_consume_token(12);
                    return;
                }
                default: {
                    this.jj_la1[100] = this.jj_gen;
                    if (this.jj_2_12(Integer.MAX_VALUE)) {
                        this.jj_consume_token(105);
                        cSSNode.appendText(this.token.image);
                        block26: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[98] = this.jj_gen;
                                    break block26;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 9: 
                            case 10: 
                            case 22: 
                            case 23: 
                            case 31: 
                            case 34: 
                            case 47: 
                            case 83: 
                            case 84: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 88: 
                            case 89: 
                            case 90: 
                            case 91: 
                            case 92: 
                            case 94: 
                            case 95: 
                            case 104: 
                            case 105: 
                            case 106: {
                                this.expr();
                                break;
                            }
                            default: {
                                this.jj_la1[99] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(12);
                        return;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 90: {
                            this.jj_consume_token(90);
                            this.jjtree.closeNodeScope((Node)cSSNode, true);
                            bl = false;
                            cSSNode.jjtSetLastToken(this.getToken(0));
                            cSSNode.appendText(this.token.image);
                            return;
                        }
                    }
                    this.jj_la1[101] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
            throw (RuntimeException)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void funcNot() throws ParseException {
        CSSNode cSSNode = new CSSNode(35);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(96);
            cSSNode.setText(":not(");
            block23: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[102] = this.jj_gen;
                        break block23;
                    }
                }
                this.jj_consume_token(4);
            }
            block5 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 34: 
                case 36: 
                case 39: 
                case 40: 
                case 43: 
                case 47: 
                case 90: 
                case 91: 
                case 96: {
                    this.selector();
                    block24: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[103] = this.jj_gen;
                                break block24;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    block25: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 37: {
                                break;
                            }
                            default: {
                                this.jj_la1[104] = this.jj_gen;
                                break block5;
                            }
                        }
                        this.jj_consume_token(37);
                        block26: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[105] = this.jj_gen;
                                    break block26;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        this.selector();
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[106] = this.jj_gen;
                                    continue block25;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        break;
                    }
                }
                default: {
                    this.jj_la1[107] = this.jj_gen;
                }
            }
            this.jj_consume_token(12);
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void simpleSelectorSequence() throws ParseException {
        block27: {
            if (this.jj_2_13(4)) {
                this.typeSelector();
                block24: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 34: 
                        case 36: 
                        case 39: 
                        case 47: 
                        case 96: {
                            break;
                        }
                        default: {
                            this.jj_la1[108] = this.jj_gen;
                            break block27;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 47: {
                            this.idSelector();
                            continue block24;
                        }
                        case 36: {
                            this.classSelector();
                            continue block24;
                        }
                        case 34: {
                            this.attributeSelector();
                            continue block24;
                        }
                        case 39: {
                            this.pseudoClassSelector();
                            continue block24;
                        }
                        case 96: {
                            this.funcNot();
                            continue block24;
                        }
                    }
                    break;
                }
                this.jj_la1[109] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 34: 
                case 36: 
                case 39: 
                case 47: 
                case 96: {
                    block25: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 47: {
                                this.idSelector();
                                break;
                            }
                            case 36: {
                                this.classSelector();
                                break;
                            }
                            case 34: {
                                this.attributeSelector();
                                break;
                            }
                            case 39: {
                                this.pseudoClassSelector();
                                break;
                            }
                            case 96: {
                                this.funcNot();
                                break;
                            }
                            default: {
                                this.jj_la1[110] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 34: 
                            case 36: 
                            case 39: 
                            case 47: 
                            case 96: {
                                continue block25;
                            }
                        }
                        break;
                    }
                    this.jj_la1[111] = this.jj_gen;
                    break;
                }
                case 91: {
                    this.jj_consume_token(91);
                    break;
                }
                default: {
                    this.jj_la1[112] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void selectorCombinator() throws ParseException {
        CSSNode cSSNode = new CSSNode(36);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            if (this.jj_2_14(2)) {
                block15: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[113] = this.jj_gen;
                            break block15;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.jj_consume_token(9);
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                bl = false;
                cSSNode.jjtSetLastToken(this.getToken(0));
                cSSNode.setText("+");
                return;
            }
            if (this.jj_2_15(2)) {
                block16: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[114] = this.jj_gen;
                            break block16;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.jj_consume_token(44);
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                bl = false;
                cSSNode.jjtSetLastToken(this.getToken(0));
                cSSNode.setText(">");
                return;
            }
            if (this.jj_2_16(2)) {
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[115] = this.jj_gen;
                            break block17;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.jj_consume_token(45);
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                bl = false;
                cSSNode.jjtSetLastToken(this.getToken(0));
                cSSNode.setText("~");
                return;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 4: {
                    this.jj_consume_token(4);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(" ");
                    return;
                }
                default: {
                    this.jj_la1[116] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void selector() throws ParseException {
        CSSNode cSSNode = new CSSNode(37);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.simpleSelectorSequence();
            while (this.jj_2_17(4)) {
                this.selectorCombinator();
                block9: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[117] = this.jj_gen;
                            break block9;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.simpleSelectorSequence();
            }
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void property() throws ParseException {
        CSSNode cSSNode = new CSSNode(38);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 90: {
                    this.jj_consume_token(90);
                    cSSNode.setText(this.token.image);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[118] = this.jj_gen;
                                return;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                }
                default: {
                    this.jj_la1[121] = this.jj_gen;
                    if (this.jj_2_18(2)) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 40: {
                                this.jj_consume_token(40);
                                break;
                            }
                            case 46: {
                                this.jj_consume_token(46);
                                break;
                            }
                            default: {
                                this.jj_la1[119] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Token token = this.token;
                        this.jj_consume_token(90);
                        if (this.m_bKeepDeprecatedProperties) {
                            cSSNode.setText(token.image + this.token.image);
                        } else {
                            this.errorDeprecatedProperty(token);
                        }
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[120] = this.jj_gen;
                                    return;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                    }
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void important() throws ParseException {
        block8: {
            CSSNode cSSNode = new CSSNode(39);
            boolean bl = true;
            this.jjtree.openNodeScope(cSSNode);
            cSSNode.jjtSetFirstToken(this.getToken(1));
            try {
                this.jj_consume_token(82);
                cSSNode.setText(this.token.image);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[122] = this.jj_gen;
                            break block8;
                        }
                    }
                    this.jj_consume_token(4);
                }
            }
            finally {
                if (bl) {
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    cSSNode.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void styleDeclaration() throws ParseException {
        block20: {
            CSSNode cSSNode = new CSSNode(40);
            boolean bl = true;
            this.jjtree.openNodeScope(cSSNode);
            cSSNode.jjtSetFirstToken(this.getToken(1));
            try {
                try {
                    this.property();
                    this.jj_consume_token(39);
                    block13: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[123] = this.jj_gen;
                                break block13;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.expr();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 82: {
                            this.important();
                            break;
                        }
                        default: {
                            this.jj_la1[124] = this.jj_gen;
                            break;
                        }
                    }
                }
                catch (ParseException parseException) {
                    if (this.m_bBrowserCompliantMode) {
                        this.browserCompliantSkipDecl(parseException);
                        break block20;
                    }
                    throw parseException;
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.jjtree.clearNodeScope(cSSNode);
                    bl = false;
                } else {
                    this.jjtree.popNode();
                }
                if (throwable instanceof ParseException) {
                    throw (ParseException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            finally {
                if (bl) {
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    cSSNode.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void styleDeclarationOrRule() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 40: 
            case 46: 
            case 90: {
                this.styleDeclaration();
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 76: {
                        this.mediaRule();
                        this.errorUnexpectedRule("@media", "media rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 58: {
                        this.pageRule();
                        this.errorUnexpectedRule("@page", "page rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 77: {
                        this.fontfaceRule();
                        this.errorUnexpectedRule("@font-face", "font-face rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 78: {
                        this.keyframesRule();
                        this.errorUnexpectedRule("@keyframes", "keyframes rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 79: {
                        this.viewportRule();
                        this.errorUnexpectedRule("@viewport", "viewport rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 80: {
                        this.supportsRule();
                        this.errorUnexpectedRule("@supports", "supports rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 81: {
                        this.unknownRule();
                        this.errorUnexpectedRule("@", "Unknown rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 55: {
                        this.charsetRule();
                        this.errorUnexpectedRule("@charset", "charset rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 56: {
                        this.importRule();
                        this.errorUnexpectedRule("@import", "import rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    case 57: {
                        this.namespaceRule();
                        this.errorUnexpectedRule("@namespace", "namespace rule in the middle of a rule-set is not allowed!");
                        break;
                    }
                    default: {
                        this.jj_la1[125] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block24: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: 
                        case 53: 
                        case 54: {
                            break;
                        }
                        default: {
                            this.jj_la1[126] = this.jj_gen;
                            break block0;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            this.jj_consume_token(4);
                            continue block24;
                        }
                        case 53: {
                            this.jj_consume_token(53);
                            continue block24;
                        }
                        case 54: {
                            this.jj_consume_token(54);
                            continue block24;
                        }
                    }
                    break;
                }
                this.jj_la1[127] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[128] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final CSSNode styleDeclarationList() throws ParseException {
        CSSNode cSSNode = new CSSNode(41);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            block31: {
                try {
                    block22: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[129] = this.jj_gen;
                                break block22;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 40: 
                        case 46: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 90: {
                            this.styleDeclarationOrRule();
                            break;
                        }
                        default: {
                            this.jj_la1[130] = this.jj_gen;
                        }
                    }
                    block23: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 38: {
                                break;
                            }
                            default: {
                                this.jj_la1[131] = this.jj_gen;
                                break block31;
                            }
                        }
                        this.jj_consume_token(38);
                        block24: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[132] = this.jj_gen;
                                    break block24;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 40: 
                            case 46: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 59: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: 
                            case 71: 
                            case 72: 
                            case 73: 
                            case 74: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 80: 
                            case 81: 
                            case 90: {
                                this.styleDeclarationOrRule();
                                continue block23;
                            }
                        }
                        this.jj_la1[133] = this.jj_gen;
                    }
                }
                catch (ParseException parseException) {
                    if (this.m_bBrowserCompliantMode) {
                        this.browserCompliantSkipDecl(parseException);
                    }
                    this.errorSkipTo(parseException, 33);
                    this.token_source.backup(1);
                }
            }
            this.jjtree.closeNodeScope((Node)cSSNode, true);
            bl = false;
            cSSNode.jjtSetLastToken(this.getToken(0));
            CSSNode cSSNode2 = cSSNode;
            return cSSNode2;
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void styleDeclarationBlock() throws ParseException {
        this.jj_consume_token(32);
        try {
            this.styleDeclarationList();
            this.jj_consume_token(33);
        }
        catch (ParseException parseException) {
            if (this.m_bBrowserCompliantMode) {
                this.browserCompliantSkipDecl(parseException);
            }
            this.errorSkipTo(parseException, 33);
        }
    }

    public final void styleRule() throws ParseException {
        block29: {
            CSSNode cSSNode = new CSSNode(42);
            boolean bl = true;
            this.jjtree.openNodeScope(cSSNode);
            cSSNode.jjtSetFirstToken(this.getToken(1));
            try {
                try {
                    this.selector();
                    block19: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[134] = this.jj_gen;
                                break block19;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    block20: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 37: {
                                break;
                            }
                            default: {
                                this.jj_la1[135] = this.jj_gen;
                                break block20;
                            }
                        }
                        this.jj_consume_token(37);
                        block21: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[136] = this.jj_gen;
                                    break block21;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        this.selector();
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[137] = this.jj_gen;
                                    continue block20;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        break;
                    }
                    this.styleDeclarationBlock();
                }
                catch (ParseException parseException) {
                    if (this.m_bBrowserCompliantMode) {
                        this.browserCompliantSkipInSelector(parseException);
                        break block29;
                    }
                    throw parseException;
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.jjtree.clearNodeScope(cSSNode);
                    bl = false;
                } else {
                    this.jjtree.popNode();
                }
                if (throwable instanceof ParseException) {
                    throw (ParseException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            finally {
                if (bl) {
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    cSSNode.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void mediaModifier() throws ParseException {
        CSSNode cSSNode = new CSSNode(43);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 85: 
                case 86: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 86: {
                            this.jj_consume_token(86);
                            cSSNode.setText(this.token.image);
                            this.jj_consume_token(4);
                            return;
                        }
                        case 85: {
                            this.jj_consume_token(85);
                            cSSNode.setText(this.token.image);
                            this.jj_consume_token(4);
                            return;
                        }
                    }
                    this.jj_la1[138] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[139] = this.jj_gen;
                    return;
                }
            }
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void medium() throws ParseException {
        CSSNode cSSNode = new CSSNode(44);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(90);
            this.jjtree.closeNodeScope((Node)cSSNode, true);
            bl = false;
            cSSNode.jjtSetLastToken(this.getToken(0));
            cSSNode.setText(this.token.image);
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void mediaFeature() throws ParseException {
        CSSNode cSSNode = new CSSNode(45);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(90);
            this.jjtree.closeNodeScope((Node)cSSNode, true);
            bl = false;
            cSSNode.jjtSetLastToken(this.getToken(0));
            cSSNode.setText(this.token.image);
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void mediaExpr() throws ParseException {
        block29: {
            CSSNode cSSNode = new CSSNode(46);
            boolean bl = true;
            this.jjtree.openNodeScope(cSSNode);
            cSSNode.jjtSetFirstToken(this.getToken(1));
            try {
                this.jj_consume_token(11);
                block20: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[140] = this.jj_gen;
                            break block20;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.mediaFeature();
                block21: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[141] = this.jj_gen;
                            break block21;
                        }
                    }
                    this.jj_consume_token(4);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        this.jj_consume_token(39);
                        block22: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[142] = this.jj_gen;
                                    break block22;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        this.expr();
                        break;
                    }
                    default: {
                        this.jj_la1[143] = this.jj_gen;
                    }
                }
                this.jj_consume_token(12);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[144] = this.jj_gen;
                            break block29;
                        }
                    }
                    this.jj_consume_token(4);
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.jjtree.clearNodeScope(cSSNode);
                    bl = false;
                } else {
                    this.jjtree.popNode();
                }
                if (throwable instanceof ParseException) {
                    throw (ParseException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            finally {
                if (bl) {
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    cSSNode.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void mediaQuery() throws ParseException {
        CSSNode cSSNode = new CSSNode(47);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 85: 
                case 86: 
                case 90: {
                    this.mediaModifier();
                    this.medium();
                    block24: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[145] = this.jj_gen;
                                break block24;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 84: {
                                break;
                            }
                            default: {
                                this.jj_la1[146] = this.jj_gen;
                                return;
                            }
                        }
                        this.jj_consume_token(84);
                        block26: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[147] = this.jj_gen;
                                    break block26;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        this.mediaExpr();
                    }
                }
                case 11: {
                    this.mediaExpr();
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 84: {
                                break;
                            }
                            default: {
                                this.jj_la1[148] = this.jj_gen;
                                return;
                            }
                        }
                        this.jj_consume_token(84);
                        block28: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[149] = this.jj_gen;
                                    break block28;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        this.mediaExpr();
                    }
                }
                default: {
                    this.jj_la1[150] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
            throw (RuntimeException)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void mediaList() throws ParseException {
        block22: {
            CSSNode cSSNode = new CSSNode(48);
            boolean bl = true;
            this.jjtree.openNodeScope(cSSNode);
            cSSNode.jjtSetFirstToken(this.getToken(1));
            try {
                this.mediaQuery();
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[151] = this.jj_gen;
                            break block14;
                        }
                    }
                    this.jj_consume_token(4);
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 37: {
                            break;
                        }
                        default: {
                            this.jj_la1[152] = this.jj_gen;
                            break block22;
                        }
                    }
                    this.jj_consume_token(37);
                    block16: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[153] = this.jj_gen;
                                break block16;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.mediaQuery();
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.jjtree.clearNodeScope(cSSNode);
                    bl = false;
                } else {
                    this.jjtree.popNode();
                }
                if (throwable instanceof ParseException) {
                    throw (ParseException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            finally {
                if (bl) {
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    cSSNode.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void mediaRuleList() throws ParseException {
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 34: 
                case 36: 
                case 39: 
                case 40: 
                case 43: 
                case 47: 
                case 90: 
                case 91: 
                case 96: {
                    this.styleRule();
                    break;
                }
                case 76: {
                    this.mediaRule();
                    break;
                }
                case 58: {
                    this.pageRule();
                    break;
                }
                case 77: {
                    this.fontfaceRule();
                    break;
                }
                case 78: {
                    this.keyframesRule();
                    break;
                }
                case 79: {
                    this.viewportRule();
                    break;
                }
                case 80: {
                    this.supportsRule();
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 81: {
                    this.unknownRule();
                    break;
                }
                case 55: {
                    this.charsetRule();
                    this.errorUnexpectedRule("@charset", "charset rule in the middle of a @media rule is not allowed!");
                    break;
                }
                case 56: {
                    this.importRule();
                    this.errorUnexpectedRule("@import", "import rule in the middle of a @media rule is not allowed!");
                    break;
                }
                case 57: {
                    this.namespaceRule();
                    this.errorUnexpectedRule("@namespace", "namespace rule in the middle of a @media rule is not allowed!");
                    break;
                }
                default: {
                    this.jj_la1[154] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block20: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[155] = this.jj_gen;
                        break block20;
                    }
                }
                this.jj_consume_token(4);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 34: 
                case 36: 
                case 39: 
                case 40: 
                case 43: 
                case 47: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 90: 
                case 91: 
                case 96: {
                    continue block19;
                }
            }
            break;
        }
        this.jj_la1[156] = this.jj_gen;
    }

    public final void mediaRule() throws ParseException {
        block31: {
            CSSNode cSSNode = new CSSNode(49);
            boolean bl = true;
            this.jjtree.openNodeScope(cSSNode);
            cSSNode.jjtSetFirstToken(this.getToken(1));
            try {
                this.jj_consume_token(76);
                block22: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[157] = this.jj_gen;
                            break block22;
                        }
                    }
                    this.jj_consume_token(4);
                }
                block6 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 11: 
                    case 85: 
                    case 86: 
                    case 90: {
                        this.mediaList();
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[158] = this.jj_gen;
                                    break block6;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                    }
                    default: {
                        this.jj_la1[159] = this.jj_gen;
                    }
                }
                this.jj_consume_token(32);
                try {
                    block24: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[160] = this.jj_gen;
                                break block24;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 34: 
                        case 36: 
                        case 39: 
                        case 40: 
                        case 43: 
                        case 47: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 90: 
                        case 91: 
                        case 96: {
                            this.mediaRuleList();
                            break;
                        }
                        default: {
                            this.jj_la1[161] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(33);
                }
                catch (ParseException parseException) {
                    if (this.m_bBrowserCompliantMode) {
                        this.browserCompliantSkipInRule(parseException);
                        break block31;
                    }
                    this.errorSkipTo(parseException, 33);
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.jjtree.clearNodeScope(cSSNode);
                    bl = false;
                } else {
                    this.jjtree.popNode();
                }
                if (throwable instanceof ParseException) {
                    throw (ParseException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            finally {
                if (bl) {
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    cSSNode.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final String pseudoPage() throws ParseException {
        this.jj_consume_token(39);
        this.jj_consume_token(90);
        return ":" + this.token.image;
    }

    public final void pageSelector() throws ParseException {
        block22: {
            CSSNode cSSNode = new CSSNode(50);
            boolean bl = true;
            this.jjtree.openNodeScope(cSSNode);
            cSSNode.jjtSetFirstToken(this.getToken(1));
            try {
                String string;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        string = this.pseudoPage();
                        cSSNode.setText(string);
                        break;
                    }
                    case 90: {
                        this.jj_consume_token(90);
                        cSSNode.setText(this.token.image);
                        break;
                    }
                    default: {
                        this.jj_la1[162] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block15: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 39: {
                            break;
                        }
                        default: {
                            this.jj_la1[163] = this.jj_gen;
                            break block15;
                        }
                    }
                    string = this.pseudoPage();
                    cSSNode.appendText(string);
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[164] = this.jj_gen;
                            break block22;
                        }
                    }
                    this.jj_consume_token(4);
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.jjtree.clearNodeScope(cSSNode);
                    bl = false;
                } else {
                    this.jjtree.popNode();
                }
                if (throwable instanceof ParseException) {
                    throw (ParseException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            finally {
                if (bl) {
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    cSSNode.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void pageSelectorList() throws ParseException {
        this.pageSelector();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 37: {
                    break;
                }
                default: {
                    this.jj_la1[165] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(37);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[166] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(4);
            }
            this.pageSelector();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void pageMarginSymbol() throws ParseException {
        CSSNode cSSNode = new CSSNode(51);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 59: {
                    this.jj_consume_token(59);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 60: {
                    this.jj_consume_token(60);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 61: {
                    this.jj_consume_token(61);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 62: {
                    this.jj_consume_token(62);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 63: {
                    this.jj_consume_token(63);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 72: {
                    this.jj_consume_token(72);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 73: {
                    this.jj_consume_token(73);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 74: {
                    this.jj_consume_token(74);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 68: {
                    this.jj_consume_token(68);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 67: {
                    this.jj_consume_token(67);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 66: {
                    this.jj_consume_token(66);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 65: {
                    this.jj_consume_token(65);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 64: {
                    this.jj_consume_token(64);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 71: {
                    this.jj_consume_token(71);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 70: {
                    this.jj_consume_token(70);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 69: {
                    this.jj_consume_token(69);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 75: {
                    this.jj_consume_token(75);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                default: {
                    this.jj_la1[167] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void pageBody() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                this.pageMarginSymbol();
                block18: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[168] = this.jj_gen;
                            break block18;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.styleDeclarationBlock();
                block19: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[169] = this.jj_gen;
                            break block19;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.pageBody();
                break;
            }
            default: {
                this.jj_la1[173] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 40: 
                    case 46: 
                    case 90: {
                        this.styleDeclaration();
                        break;
                    }
                    default: {
                        this.jj_la1[170] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 38: {
                        this.jj_consume_token(38);
                        block20: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 4: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[171] = this.jj_gen;
                                    break block20;
                                }
                            }
                            this.jj_consume_token(4);
                        }
                        this.pageBody();
                        break block0;
                    }
                }
                this.jj_la1[172] = this.jj_gen;
            }
        }
    }

    public final void pageRuleBlock() throws ParseException {
        block17: {
            CSSNode cSSNode = new CSSNode(52);
            boolean bl = true;
            this.jjtree.openNodeScope(cSSNode);
            cSSNode.jjtSetFirstToken(this.getToken(1));
            try {
                this.jj_consume_token(32);
                try {
                    block10: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[174] = this.jj_gen;
                                break block10;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.pageBody();
                    this.jj_consume_token(33);
                }
                catch (ParseException parseException) {
                    if (this.m_bBrowserCompliantMode) {
                        this.browserCompliantSkipInRule(parseException);
                        break block17;
                    }
                    this.errorSkipTo(parseException, 33);
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.jjtree.clearNodeScope(cSSNode);
                    bl = false;
                } else {
                    this.jjtree.popNode();
                }
                if (throwable instanceof ParseException) {
                    throw (ParseException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            finally {
                if (bl) {
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    cSSNode.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void pageRule() throws ParseException {
        CSSNode cSSNode = new CSSNode(53);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(58);
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[175] = this.jj_gen;
                        break block14;
                    }
                }
                this.jj_consume_token(4);
            }
            block5 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 39: 
                case 90: {
                    this.pageSelectorList();
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[176] = this.jj_gen;
                                break block5;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                }
                default: {
                    this.jj_la1[177] = this.jj_gen;
                }
            }
            this.pageRuleBlock();
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void fontfaceRule() throws ParseException {
        CSSNode cSSNode = new CSSNode(54);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(77);
            cSSNode.setText(this.token.image);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[178] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(4);
            }
            this.styleDeclarationBlock();
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void keyframesIdentifier() throws ParseException {
        CSSNode cSSNode = new CSSNode(55);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(90);
            this.jjtree.closeNodeScope((Node)cSSNode, true);
            bl = false;
            cSSNode.jjtSetLastToken(this.getToken(0));
            cSSNode.setText(this.token.image);
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void singleKeyframeSelector() throws ParseException {
        CSSNode cSSNode = new CSSNode(56);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 87: {
                    this.jj_consume_token(87);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 88: {
                    this.jj_consume_token(88);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 91: {
                    this.jj_consume_token(91);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                default: {
                    this.jj_la1[179] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void keyframesSelector() throws ParseException {
        block26: {
            CSSNode cSSNode = new CSSNode(57);
            boolean bl = true;
            this.jjtree.openNodeScope(cSSNode);
            cSSNode.jjtSetFirstToken(this.getToken(1));
            try {
                this.singleKeyframeSelector();
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[180] = this.jj_gen;
                            break block17;
                        }
                    }
                    this.jj_consume_token(4);
                }
                block18: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 37: {
                            break;
                        }
                        default: {
                            this.jj_la1[181] = this.jj_gen;
                            break block26;
                        }
                    }
                    this.jj_consume_token(37);
                    block19: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[182] = this.jj_gen;
                                break block19;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.singleKeyframeSelector();
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[183] = this.jj_gen;
                                continue block18;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.jjtree.clearNodeScope(cSSNode);
                    bl = false;
                } else {
                    this.jjtree.popNode();
                }
                if (throwable instanceof ParseException) {
                    throw (ParseException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            finally {
                if (bl) {
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    cSSNode.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void keyframesBlocks() throws ParseException {
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 87: 
                case 88: 
                case 91: {
                    break;
                }
                default: {
                    this.jj_la1[184] = this.jj_gen;
                    break block9;
                }
            }
            this.keyframesSelector();
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[185] = this.jj_gen;
                        break block10;
                    }
                }
                this.jj_consume_token(4);
            }
            this.styleDeclarationBlock();
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[186] = this.jj_gen;
                        continue block9;
                    }
                }
                this.jj_consume_token(4);
            }
            break;
        }
    }

    public final void keyframesRule() throws ParseException {
        block21: {
            CSSNode cSSNode = new CSSNode(58);
            boolean bl = true;
            this.jjtree.openNodeScope(cSSNode);
            cSSNode.jjtSetFirstToken(this.getToken(1));
            try {
                this.jj_consume_token(78);
                cSSNode.setText(this.token.image);
                this.jj_consume_token(4);
                this.keyframesIdentifier();
                block13: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[187] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.jj_consume_token(4);
                }
                this.jj_consume_token(32);
                try {
                    block14: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                break;
                            }
                            default: {
                                this.jj_la1[188] = this.jj_gen;
                                break block14;
                            }
                        }
                        this.jj_consume_token(4);
                    }
                    this.keyframesBlocks();
                    this.jj_consume_token(33);
                }
                catch (ParseException parseException) {
                    if (this.m_bBrowserCompliantMode) {
                        this.browserCompliantSkipInRule(parseException);
                        break block21;
                    }
                    this.errorSkipTo(parseException, 33);
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.jjtree.clearNodeScope(cSSNode);
                    bl = false;
                } else {
                    this.jjtree.popNode();
                }
                if (throwable instanceof ParseException) {
                    throw (ParseException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            finally {
                if (bl) {
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    cSSNode.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void viewportRule() throws ParseException {
        CSSNode cSSNode = new CSSNode(59);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(79);
            cSSNode.setText(this.token.image);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[189] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(4);
            }
            this.styleDeclarationBlock();
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void supportsConditionInParens() throws ParseException {
        CSSNode cSSNode = new CSSNode(60);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(11);
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[190] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(4);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 40: 
                case 46: 
                case 90: {
                    this.styleDeclaration();
                    break;
                }
                case 11: 
                case 85: {
                    this.supportsCondition();
                    break;
                }
                default: {
                    this.jj_la1[191] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_consume_token(12);
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void supportsNegation() throws ParseException {
        CSSNode cSSNode = new CSSNode(61);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(85);
            block8: while (true) {
                this.jj_consume_token(4);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[192] = this.jj_gen;
            this.supportsConditionInParens();
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void supportsConditionOperator() throws ParseException {
        CSSNode cSSNode = new CSSNode(62);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 84: {
                    this.jj_consume_token(84);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                case 89: {
                    this.jj_consume_token(89);
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    bl = false;
                    cSSNode.jjtSetLastToken(this.getToken(0));
                    cSSNode.setText(this.token.image);
                    return;
                }
                default: {
                    this.jj_la1[193] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void supportsCondition() throws ParseException {
        block27: {
            CSSNode cSSNode = new CSSNode(63);
            boolean bl = true;
            this.jjtree.openNodeScope(cSSNode);
            cSSNode.jjtSetFirstToken(this.getToken(1));
            try {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 85: {
                        this.supportsNegation();
                        break;
                    }
                    case 11: {
                        this.supportsConditionInParens();
                        while (this.jj_2_19(2)) {
                            block19: while (true) {
                                this.jj_consume_token(4);
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 4: {
                                        continue block19;
                                    }
                                }
                                break;
                            }
                            this.jj_la1[194] = this.jj_gen;
                            this.supportsConditionOperator();
                            block20: while (true) {
                                this.jj_consume_token(4);
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 4: {
                                        continue block20;
                                    }
                                }
                                break;
                            }
                            this.jj_la1[195] = this.jj_gen;
                            this.supportsConditionInParens();
                        }
                        break;
                    }
                    default: {
                        this.jj_la1[196] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[197] = this.jj_gen;
                            break block27;
                        }
                    }
                    this.jj_consume_token(4);
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.jjtree.clearNodeScope(cSSNode);
                    bl = false;
                } else {
                    this.jjtree.popNode();
                }
                if (throwable instanceof ParseException) {
                    throw (ParseException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            finally {
                if (bl) {
                    this.jjtree.closeNodeScope((Node)cSSNode, true);
                    cSSNode.jjtSetLastToken(this.getToken(0));
                }
            }
        }
    }

    public final void supportsRuleBodyRule() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 34: 
            case 36: 
            case 39: 
            case 40: 
            case 43: 
            case 47: 
            case 90: 
            case 91: 
            case 96: {
                this.styleRule();
                break;
            }
            case 76: {
                this.mediaRule();
                break;
            }
            case 58: {
                this.pageRule();
                break;
            }
            case 77: {
                this.fontfaceRule();
                break;
            }
            case 78: {
                this.keyframesRule();
                break;
            }
            case 80: {
                this.supportsRule();
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 81: {
                this.unknownRule();
                break;
            }
            case 55: {
                this.charsetRule();
                this.errorUnexpectedRule("@charset", "charset rule in the middle of a @supports rule is not allowed!");
                break;
            }
            case 56: {
                this.importRule();
                this.errorUnexpectedRule("@import", "import rule in the middle of a @supports rule is not allowed!");
                break;
            }
            case 57: {
                this.namespaceRule();
                this.errorUnexpectedRule("@namespace", "namespace rule in the middle of a @supports rule is not allowed!");
                break;
            }
            case 79: {
                this.viewportRule();
                this.errorUnexpectedRule("@viewport", "viewport rule in the middle of a @supports rule is not allowed!");
                break;
            }
            default: {
                this.jj_la1[198] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void supportsRuleBody() throws ParseException {
        this.jj_consume_token(32);
        try {
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[199] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(4);
            }
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 34: 
                    case 36: 
                    case 39: 
                    case 40: 
                    case 43: 
                    case 47: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 90: 
                    case 91: 
                    case 96: {
                        break;
                    }
                    default: {
                        this.jj_la1[200] = this.jj_gen;
                        break block12;
                    }
                }
                this.supportsRuleBodyRule();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[201] = this.jj_gen;
                            continue block12;
                        }
                    }
                    this.jj_consume_token(4);
                }
                break;
            }
            this.jj_consume_token(33);
        }
        catch (ParseException parseException) {
            if (this.m_bBrowserCompliantMode) {
                this.browserCompliantSkipInRule(parseException);
            }
            this.errorSkipTo(parseException, 33);
        }
    }

    public final void supportsRule() throws ParseException {
        CSSNode cSSNode = new CSSNode(64);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            this.jj_consume_token(80);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[202] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(4);
            }
            this.supportsCondition();
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        break;
                    }
                    default: {
                        this.jj_la1[203] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(4);
            }
            this.supportsRuleBody();
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void unknownRuleParameterList() throws ParseException {
        CSSNode cSSNode = new CSSNode(65);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            String string = this.javaSkipToOpeningBrace();
            this.jjtree.closeNodeScope((Node)cSSNode, true);
            bl = false;
            cSSNode.jjtSetLastToken(this.getToken(0));
            cSSNode.setText(string);
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void unknownRuleBody() throws ParseException {
        CSSNode cSSNode = new CSSNode(66);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            String string = this.javaSkipToClosingBrace(1);
            this.jjtree.closeNodeScope((Node)cSSNode, true);
            bl = false;
            cSSNode.jjtSetLastToken(this.getToken(0));
            cSSNode.setText(string);
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseEOFException) {
                throw (ParseEOFException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    public final void unknownRule() throws ParseException {
        CSSNode cSSNode = new CSSNode(67);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 81: {
                    this.jj_consume_token(81);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 59: {
                    this.jj_consume_token(59);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 60: {
                    this.jj_consume_token(60);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 61: {
                    this.jj_consume_token(61);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 62: {
                    this.jj_consume_token(62);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 63: {
                    this.jj_consume_token(63);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 64: {
                    this.jj_consume_token(64);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 65: {
                    this.jj_consume_token(65);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 66: {
                    this.jj_consume_token(66);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 67: {
                    this.jj_consume_token(67);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 68: {
                    this.jj_consume_token(68);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 69: {
                    this.jj_consume_token(69);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 70: {
                    this.jj_consume_token(70);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 71: {
                    this.jj_consume_token(71);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 72: {
                    this.jj_consume_token(72);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 73: {
                    this.jj_consume_token(73);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 74: {
                    this.jj_consume_token(74);
                    cSSNode.setText(this.token.image);
                    break;
                }
                case 75: {
                    this.jj_consume_token(75);
                    cSSNode.setText(this.token.image);
                    break;
                }
                default: {
                    this.jj_la1[204] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.unknownRuleParameterList();
            this.unknownRuleBody();
            this.jjtree.closeNodeScope((Node)cSSNode, true);
            bl = false;
            cSSNode.jjtSetLastToken(this.getToken(0));
            this.token_source.SwitchTo(0);
        }
        catch (Throwable throwable) {
            if (bl) {
                this.jjtree.clearNodeScope(cSSNode);
                bl = false;
            } else {
                this.jjtree.popNode();
            }
            if (throwable instanceof ParseException) {
                throw (ParseException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void invalid() throws ParseException {
        CSSNode cSSNode = new CSSNode(68);
        boolean bl = true;
        this.jjtree.openNodeScope(cSSNode);
        cSSNode.jjtSetFirstToken(this.getToken(1));
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    this.jj_consume_token(24);
                    return;
                }
                case 25: {
                    this.jj_consume_token(25);
                    return;
                }
                default: {
                    this.jj_la1[205] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (bl) {
                this.jjtree.closeNodeScope((Node)cSSNode, true);
                cSSNode.jjtSetLastToken(this.getToken(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int n) {
        this.jj_la = n;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, n);
        }
    }

    private boolean jj_3R_245() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_228() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_230());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_230() {
        return this.jj_3R_232();
    }

    private boolean jj_3_6() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        return this.jj_3R_141();
    }

    private boolean jj_3R_211() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        return this.jj_3R_228();
    }

    private boolean jj_3R_212() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        return this.jj_3R_215();
    }

    private boolean jj_3R_231() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_233()) {
            this.jj_scanpos = token;
            if (this.jj_3R_234()) {
                this.jj_scanpos = token;
                if (this.jj_3R_235()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_236()) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(47)) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_237()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_238()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_scan_token(106)) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_239()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_151() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_170()) {
            this.jj_scanpos = token;
            if (this.jj_3R_171()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_233() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_241()) {
            this.jj_scanpos = token;
        }
        token = this.jj_scanpos;
        if (this.jj_scan_token(31)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(91)) {
                this.jj_scanpos = token;
                if (this.jj_3R_242()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_213() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        return this.jj_3R_215();
    }

    private boolean jj_3R_170() {
        return this.jj_scan_token(84);
    }

    private boolean jj_3R_241() {
        return this.jj_3R_143();
    }

    private boolean jj_3R_171() {
        return this.jj_scan_token(89);
    }

    private boolean jj_3R_234() {
        return this.jj_3R_243();
    }

    private boolean jj_3R_242() {
        return this.jj_3R_172();
    }

    private boolean jj_3R_182() {
        if (this.jj_scan_token(39)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_190()) {
            this.jj_scanpos = token;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_191()) {
            this.jj_scanpos = token;
            if (this.jj_3R_192()) {
                this.jj_scanpos = token;
                if (this.jj_3R_193()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_194()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_195()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_196()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_197()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_198()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_199()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_235() {
        return this.jj_3R_187();
    }

    private boolean jj_3R_236() {
        return this.jj_3R_244();
    }

    private boolean jj_3R_190() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_237() {
        return this.jj_3R_173();
    }

    private boolean jj_3R_191() {
        if (this.jj_scan_token(103)) {
            return true;
        }
        return this.jj_3R_207();
    }

    private boolean jj_3R_238() {
        return this.jj_3R_174();
    }

    private boolean jj_3_19() {
        Token token;
        if (this.jj_scan_token(4)) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        return this.jj_3R_151();
    }

    private boolean jj_3R_239() {
        return this.jj_3R_245();
    }

    private boolean jj_3R_192() {
        if (this.jj_scan_token(99)) {
            return true;
        }
        if (this.jj_3R_208()) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_193() {
        if (this.jj_scan_token(101)) {
            return true;
        }
        if (this.jj_3R_209()) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_194() {
        if (this.jj_scan_token(102)) {
            return true;
        }
        if (this.jj_3R_210()) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_195() {
        if (this.jj_scan_token(98)) {
            return true;
        }
        if (this.jj_3R_211()) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_196() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        return this.jj_3R_212();
    }

    private boolean jj_3R_197() {
        if (this.jj_scan_token(100)) {
            return true;
        }
        return this.jj_3R_213();
    }

    private boolean jj_3R_198() {
        Token token;
        if (this.jj_scan_token(105)) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        token = this.jj_scanpos = token;
        if (this.jj_3R_214()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_229() {
        return this.jj_3R_231();
    }

    private boolean jj_3R_199() {
        return this.jj_scan_token(90);
    }

    private boolean jj_3R_214() {
        return this.jj_3R_229();
    }

    private boolean jj_3_1() {
        return this.jj_scan_token(55);
    }

    private boolean jj_3R_183() {
        Token token;
        if (this.jj_scan_token(96)) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        token = this.jj_scanpos = token;
        if (this.jj_3R_200()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3_2() {
        return this.jj_scan_token(56);
    }

    private boolean jj_3_12() {
        return this.jj_scan_token(105);
    }

    private boolean jj_3R_200() {
        Token token;
        if (this.jj_3R_215()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_216());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3_3() {
        return this.jj_scan_token(57);
    }

    private boolean jj_3R_216() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3_13() {
        Token token;
        if (this.jj_3R_147()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_148());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_150() {
        Token token = this.jj_scanpos;
        if (this.jj_3_13()) {
            this.jj_scanpos = token;
            if (this.jj_3R_169()) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(91)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_148() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_163()) {
            this.jj_scanpos = token;
            if (this.jj_3R_164()) {
                this.jj_scanpos = token;
                if (this.jj_3R_165()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_166()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_167()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_163() {
        return this.jj_3R_179();
    }

    private boolean jj_3R_164() {
        return this.jj_3R_180();
    }

    private boolean jj_3R_165() {
        return this.jj_3R_181();
    }

    private boolean jj_3R_166() {
        return this.jj_3R_182();
    }

    private boolean jj_3R_167() {
        return this.jj_3R_183();
    }

    private boolean jj_3R_169() {
        Token token;
        if (this.jj_3R_184()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_184());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_184() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_201()) {
            this.jj_scanpos = token;
            if (this.jj_3R_202()) {
                this.jj_scanpos = token;
                if (this.jj_3R_203()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_204()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_205()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_201() {
        return this.jj_3R_179();
    }

    private boolean jj_3R_202() {
        return this.jj_3R_180();
    }

    private boolean jj_3R_203() {
        return this.jj_3R_181();
    }

    private boolean jj_3R_204() {
        return this.jj_3R_182();
    }

    private boolean jj_3R_205() {
        return this.jj_3R_183();
    }

    private boolean jj_3R_149() {
        Token token = this.jj_scanpos;
        if (this.jj_3_14()) {
            this.jj_scanpos = token;
            if (this.jj_3_15()) {
                this.jj_scanpos = token;
                if (this.jj_3_16()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_168()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_14() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        return this.jj_scan_token(9);
    }

    private boolean jj_3_15() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        return this.jj_scan_token(44);
    }

    private boolean jj_3_16() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        return this.jj_scan_token(45);
    }

    private boolean jj_3R_168() {
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_215() {
        Token token;
        if (this.jj_3R_150()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3_17());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3_17() {
        Token token;
        if (this.jj_3R_149()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        return this.jj_3R_150();
    }

    private boolean jj_3R_243() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(22)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(23)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_142() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_161()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_161() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_175()) {
            this.jj_scanpos = token;
            if (this.jj_3R_176()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_175() {
        return this.jj_scan_token(90);
    }

    private boolean jj_3R_176() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_187() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(90)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(83)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(84)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(85)) {
                        this.jj_scanpos = token;
                        if (this.jj_scan_token(86)) {
                            this.jj_scanpos = token;
                            if (this.jj_scan_token(87)) {
                                this.jj_scanpos = token;
                                if (this.jj_scan_token(88)) {
                                    this.jj_scanpos = token;
                                    if (this.jj_scan_token(89)) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_162() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_177()) {
            this.jj_scanpos = token;
            if (this.jj_3R_178()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_177() {
        return this.jj_scan_token(90);
    }

    private boolean jj_3R_178() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_147() {
        Token token = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_162();
    }

    private boolean jj_3_7() {
        return this.jj_3R_142();
    }

    private boolean jj_3_18() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(40)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(46)) {
                return true;
            }
        }
        return this.jj_scan_token(90);
    }

    private boolean jj_3R_244() {
        return this.jj_scan_token(94);
    }

    private boolean jj_3R_179() {
        return this.jj_scan_token(47);
    }

    private boolean jj_3R_173() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_185()) {
            this.jj_scanpos = token;
            if (this.jj_3R_186()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_185() {
        return this.jj_scan_token(105);
    }

    private boolean jj_3R_180() {
        if (this.jj_scan_token(36)) {
            return true;
        }
        return this.jj_3R_187();
    }

    private boolean jj_3R_186() {
        return this.jj_scan_token(104);
    }

    private boolean jj_3R_206() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_217()) {
            this.jj_scanpos = token;
            if (this.jj_3R_218()) {
                this.jj_scanpos = token;
                if (this.jj_3R_219()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_220()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_221()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_222()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_217() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3R_143() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(10)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(9)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_218() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_219() {
        return this.jj_scan_token(49);
    }

    private boolean jj_3R_220() {
        return this.jj_scan_token(50);
    }

    private boolean jj_3R_221() {
        return this.jj_scan_token(51);
    }

    private boolean jj_3R_222() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_172() {
        return this.jj_scan_token(92);
    }

    private boolean jj_3R_181() {
        Token token;
        if (this.jj_scan_token(34)) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        token = this.jj_scanpos = token;
        if (this.jj_3_8()) {
            this.jj_scanpos = token;
        }
        if (this.jj_scan_token(90)) {
            return true;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_188()) {
            this.jj_scanpos = token;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        token = this.jj_scanpos = token;
        if (this.jj_3R_189()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(35);
    }

    private boolean jj_3_8() {
        return this.jj_3R_142();
    }

    private boolean jj_3R_138() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_154()) {
            this.jj_scanpos = token;
        }
        token = this.jj_scanpos;
        if (this.jj_scan_token(31)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(91)) {
                this.jj_scanpos = token;
                if (this.jj_3R_155()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_156()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_157()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_158()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_154() {
        return this.jj_3R_143();
    }

    private boolean jj_3R_155() {
        return this.jj_3R_172();
    }

    private boolean jj_3R_188() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_156() {
        return this.jj_3R_173();
    }

    private boolean jj_3R_157() {
        return this.jj_3R_174();
    }

    private boolean jj_3R_189() {
        return this.jj_3R_206();
    }

    private boolean jj_3R_158() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_207() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        token = this.jj_scanpos = token;
        if (this.jj_3_10()) {
            this.jj_scanpos = token;
            if (this.jj_3_11()) {
                this.jj_scanpos = token;
                if (this.jj_3R_223()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_224()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_10() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_144()) {
            this.jj_scanpos = token;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_145()) {
            this.jj_scanpos = token;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        token = this.jj_scanpos;
        if (this.jj_3_9()) {
            this.jj_scanpos = token;
        }
        return false;
    }

    private boolean jj_3R_137() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_152()) {
            this.jj_scanpos = token;
            if (this.jj_3R_153()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_144() {
        return this.jj_3R_143();
    }

    private boolean jj_3R_152() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_145() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_153() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3_9() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        if (this.jj_3R_143()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_140() {
        return this.jj_3R_138();
    }

    private boolean jj_3_11() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_146()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(8);
    }

    private boolean jj_3_4() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        if (this.jj_3R_137()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        return this.jj_3R_138();
    }

    private boolean jj_3R_146() {
        return this.jj_3R_143();
    }

    private boolean jj_3R_223() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_224() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_208() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_225());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_139() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_159()) {
            this.jj_scanpos = token;
            if (this.jj_3R_160()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_159() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_225() {
        return this.jj_3R_150();
    }

    private boolean jj_3R_160() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_209() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_226());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3_5() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        if (this.jj_3R_139()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        return this.jj_3R_140();
    }

    private boolean jj_3R_226() {
        return this.jj_3R_150();
    }

    private boolean jj_3R_210() {
        Token token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_scan_token(4));
        this.jj_scanpos = token;
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_227());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_174() {
        return this.jj_scan_token(95);
    }

    private boolean jj_3R_227() {
        return this.jj_3R_150();
    }

    private boolean jj_3R_232() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_240()) {
            this.jj_scanpos = token;
        }
        return this.jj_3R_215();
    }

    private boolean jj_3R_240() {
        return this.jj_3R_149();
    }

    private boolean jj_3R_141() {
        return this.jj_scan_token(90);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 16, 16, 0, 0, 16, 16, 0, 0xC00000, 0, 16, -2134899200, 0, 1536, 1536, 16, 16, -2147481600, 0, 16, 16, 1536, 16, 16, 16, 16, 16, 16, 16, 0, 1536, Integer.MIN_VALUE, -2134899200, 16, 0, -2134899184, 16, 16, 0, 16, 16, 16, 0xC00000, 16, 2048, 0xC00000, 16, 16, 0, 16, 0, 0, 0, 0, 0xC00000, 16, 0, 16, 16, 16, 0, 16, 1536, 256, 16, 16, 1536, 192, 16, 16, 0, 16, 16, 0, 16, 16, 0, 16, 16, 528, 16, 0, 16, 16, 528, 16, 16, 16, 0, 16, -2134899200, 0, 0, 16, 16, 0, 16, 16, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 16, 16, 0, 16, 0, 16, 16, 0, 0, 16, 16, 0, 16, 0, 0, 16, 0, 16, 0, 16, 16, 0, 0, 16, 16, 16, 0, 16, 16, 0, 16, 0, 16, 2048, 16, 0, 16, 0, 16, 0, 16, 16, 2048, 16, 0, 0, 0, 16, 0, 16, 0, 16, 16, 0, 16, 0, 0, 16, 16, 16, 0, 16, 0, 16, 0, 16, 16, 0, 16, 16, 16, 16, 16, 16, 2048, 16, 0, 16, 16, 2048, 16, 0, 16, 0, 16, 16, 16, 0, 0x3000000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0x600000, 0x600000, 0x600000, 0x600000, 0x600000, 0x600000, 0x600000, 0x600000, -8353388, -8353388, 0x600000, 0x600000, 66, 66, 0x600000, 0x600000, 0, 0, 0, 0, 32772, 0, 0, 0, 0, 0, 0, 768, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32772, 0, 1568, 34340, 0, 0, 1568, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 256, 256, 2032640, 0, 0, 256, 0, 0, 0, 2032640, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35220, 0, 0, 35220, 0, 0, 35220, 0, 0, 12288, 0, 32, 0, 0, 47508, 0, 0, 0, 128, 0, 32772, 0, 0, 0, 0, 32, 0, 0, 35220, 32916, 32916, 32916, 32916, 32916, 0, 0, 0, 0, 0, 0, 16640, 0, 0, 0, 0, 0, -8388608, 0x600000, 0x600000, -8371968, 0, -8371968, 64, 0, -8371968, 0, 32, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, -8353388, 0, -8353388, 0, 0, 0, 0, -8353388, 128, 128, 0, 32, 0, -134217728, 0, 0, 16640, 0, 64, -134217728, 0, 0, 0, 128, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16640, 0, 0, 0, 0, 0, 0, -8353388, 0, -8353388, 0, 0, 0, -134217728, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 201588735, 201588735, 0, 0, 0, 0, 0, 0, 0, 0, 133693440, 0, -537395200, 0, 0, 0, 0, 0, -1744830464, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0x18000000, -537395200, 0, 0, -537395200, 0, 0, 0, 0, 0, 0, 0x40000000, 0, 0x4600000, 0x40000000, 0, 0, 0x4000000, 0, 0x4000000, 0x4000000, 0x4000000, 0, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0xC000000, 0, 0, 0xC000000, 0, 0, 0xC000000, 0, 0, 0, 0, 0, 0, 0, 0xC000000, 0, 0, 0, 0, 0, -537395200, 0, 0x4000000, 0, 0, 0, 0, 0, 0xC000000, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0, 262144, 262143, 0, 0, 67371007, 0, 67371007, 0, 0, 67371007, 0, 0, 0, 0, 0x600000, 0x600000, 0, 0, 0, 0, 0, 0, 0x100000, 0, 0x100000, 0, 0x4600000, 0, 0, 0, 201588735, 0, 201588735, 0, 0, 0x4600000, 0, 201588735, 0x4000000, 0, 0, 0, 0, 4095, 0, 0, 0x4000000, 0, 0, 4095, 0, 0, 0, 0x4000000, 0, 0x9800000, 0, 0, 0, 0, 0x9800000, 0, 0, 0, 0, 0, 0, 0x4200000, 0, 0x2100000, 0, 0, 0x200000, 0, 201588735, 0, 201588735, 0, 0, 0, 135167, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 4096, 0, 0, 0, 1792, 768, 0, 0, 0, 0, 768, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1792, 0, 0, 1792, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1792, 254, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0};
    }

    public ParserCSS30(CharStream charStream) {
        int n;
        this.token_source = new ParserCSS30TokenManager(charStream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 206; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(CharStream charStream) {
        int n;
        this.token_source.ReInit(charStream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 206; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public ParserCSS30(ParserCSS30TokenManager parserCSS30TokenManager) {
        int n;
        this.token_source = parserCSS30TokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 206; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(ParserCSS30TokenManager parserCSS30TokenManager) {
        int n;
        this.token_source = parserCSS30TokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 206; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            if (token.next == null) {
                token.next = this.token_source.getNextToken();
            }
            token = token.next;
        }
        return token;
    }

    private int jj_ntk_f() {
        int n;
        this.jj_nt = this.token.next;
        Token token = this.jj_nt;
        if (token == null) {
            this.token.next = this.token_source.getNextToken();
            n = this.jj_ntk = this.token.next.kind;
        } else {
            n = this.jj_ntk = token.kind;
        }
        return n;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] nArray : this.jj_expentries) {
                if (nArray.length != this.jj_expentry.length) continue;
                boolean bl = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.clear();
        boolean[] blArray = new boolean[109];
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 206; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((jj_la1_2[n2] & 1 << n) != 0) {
                    blArray[64 + n] = true;
                }
                if ((jj_la1_3[n2] & 1 << n) == 0) continue;
                blArray[96 + n] = true;
            }
        }
        for (n2 = 0; n2 < 109; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = this.jj_expentries.get(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage, this.token_source == null ? null : ParserCSS30TokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final boolean trace_enabled() {
        return false;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 19; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_scanpos = jJCalls.first;
                    this.jj_lastpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        ParserCSS30.jj_la1_init_0();
        ParserCSS30.jj_la1_init_1();
        ParserCSS30.jj_la1_init_2();
        ParserCSS30.jj_la1_init_3();
    }

    private static final class LookaheadSuccess
    extends IllegalStateException {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

