/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.css.ECSSUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSExpressionTermOptimizer {
    private static final ICommonsList<String> s_aUnitValues0 = new CommonsArrayList();
    private static final CSSExpressionTermOptimizer INSTANCE;

    private CSSExpressionTermOptimizer() {
    }

    @Nonnull
    @Nonempty
    public static String getOptimizedValue(@Nonnull @Nonempty String string) {
        if (s_aUnitValues0.contains((Object)string)) {
            return "0";
        }
        if (string.length() == 7 && string.charAt(0) == '#' && string.charAt(1) == string.charAt(2) && string.charAt(3) == string.charAt(4) && string.charAt(5) == string.charAt(6)) {
            return Character.toString('#') + string.charAt(1) + string.charAt(3) + string.charAt(5);
        }
        return string;
    }

    static {
        for (ECSSUnit eCSSUnit : ECSSUnit.values()) {
            s_aUnitValues0.add((Object)eCSSUnit.format(0));
        }
        INSTANCE = new CSSExpressionTermOptimizer();
    }
}

