/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSelectorMemberSlotted
implements ICSSSelectorMember,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final ICSSSelectorMember m_aSimpleSelector;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorMemberSlotted(@Nonnull ICSSSelectorMember iCSSSelectorMember) {
        ValueEnforcer.notNull((Object)iCSSSelectorMember, (String)"SimpleSelector");
        this.m_aSimpleSelector = iCSSSelectorMember;
    }

    @Nonnull
    public ICSSSelectorMember getSimpleSelector() {
        return this.m_aSimpleSelector;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        StringBuilder stringBuilder = new StringBuilder("::slotted(");
        stringBuilder.append(this.m_aSimpleSelector.getAsCSSString(iCSSWriterSettings, 0));
        return stringBuilder.append(')').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelectorMemberSlotted cSSSelectorMemberSlotted = (CSSSelectorMemberSlotted)object;
        return this.m_aSimpleSelector.equals(cSSSelectorMemberSlotted.m_aSimpleSelector);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aSimpleSelector).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("simpleSelector", (Object)this.m_aSimpleSelector).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

