/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.ICSSPageRuleMember;
import com.helger.css.property.ECSSProperty;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSDeclaration
implements ICSSSourceLocationAware,
ICSSPageRuleMember {
    public static final boolean DEFAULT_IMPORTANT = false;
    private String m_sProperty;
    private CSSExpression m_aExpression;
    private boolean m_bIsImportant;
    private CSSSourceLocation m_aSourceLocation;

    public CSSDeclaration(@Nonnull @Nonempty String string, @Nonnull CSSExpression cSSExpression) {
        this(string, cSSExpression, false);
    }

    public CSSDeclaration(@Nonnull @Nonempty String string, @Nonnull CSSExpression cSSExpression, boolean bl) {
        this.setProperty(string);
        this.setExpression(cSSExpression);
        this.setImportant(bl);
    }

    @Nonnull
    @Nonempty
    public String getProperty() {
        return this.m_sProperty;
    }

    @Nonnull
    public CSSDeclaration setProperty(@Nonnull @Nonempty String string) {
        this.m_sProperty = ((String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Property")).toLowerCase(Locale.US);
        return this;
    }

    @Nonnull
    public CSSDeclaration setProperty(@Nonnull ECSSProperty eCSSProperty) {
        ValueEnforcer.notNull((Object)eCSSProperty, (String)"Property");
        return this.setProperty(eCSSProperty.getName());
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public CSSExpression getExpression() {
        return this.m_aExpression;
    }

    @Nonnull
    public CSSDeclaration setExpression(@Nonnull CSSExpression cSSExpression) {
        this.m_aExpression = (CSSExpression)ValueEnforcer.notNull((Object)cSSExpression, (String)"Expression");
        return this;
    }

    public boolean isImportant() {
        return this.m_bIsImportant;
    }

    @Nonnull
    public CSSDeclaration setImportant(boolean bl) {
        this.m_bIsImportant = bl;
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.m_sProperty + ':' + this.m_aExpression.getAsCSSString(iCSSWriterSettings, n) + (this.m_bIsImportant ? " !important" : "");
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSDeclaration cSSDeclaration = (CSSDeclaration)object;
        return this.m_sProperty.equals(cSSDeclaration.m_sProperty) && this.m_aExpression.equals(cSSDeclaration.m_aExpression) && this.m_bIsImportant == cSSDeclaration.m_bIsImportant;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sProperty).append((Object)this.m_aExpression).append(this.m_bIsImportant).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("property", (Object)this.m_sProperty).append("expression", (Object)this.m_aExpression).append("important", this.m_bIsImportant).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

