/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSWritableList<DATATYPE extends ICSSWriteable>
implements ICSSSourceLocationAware,
ICSSWriteable {
    private final ICommonsList<DATATYPE> m_aElements = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    protected final void add(@Nonnull DATATYPE DATATYPE) {
        ValueEnforcer.notNull(DATATYPE, (String)"Element");
        this.m_aElements.add(DATATYPE);
    }

    protected final void add(@Nonnegative int n, @Nonnull DATATYPE DATATYPE) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull(DATATYPE, (String)"Element");
        if (n >= this.m_aElements.size()) {
            this.m_aElements.add(DATATYPE);
        } else {
            this.m_aElements.add(n, DATATYPE);
        }
    }

    protected final void set(@Nonnegative int n, @Nonnull DATATYPE DATATYPE) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull(DATATYPE, (String)"Element");
        if (n >= this.m_aElements.size()) {
            this.m_aElements.add(DATATYPE);
        } else {
            this.m_aElements.set(n, DATATYPE);
        }
    }

    @Nonnull
    protected final EChange remove(@Nonnull DATATYPE DATATYPE) {
        return EChange.valueOf((boolean)this.m_aElements.remove(DATATYPE));
    }

    @Nonnull
    protected final EChange remove(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aElements.size()) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf((this.m_aElements.remove(n) != null ? 1 : 0) != 0);
    }

    @Nonnull
    protected final EChange removeAll() {
        return this.m_aElements.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    protected final ICommonsList<DATATYPE> getAll() {
        return (ICommonsList)this.m_aElements.getClone();
    }

    @Nullable
    protected final DATATYPE getAtIndex(@Nonnegative int n) {
        return (DATATYPE)((ICSSWriteable)this.m_aElements.getAtIndex(n));
    }

    protected final boolean isEmpty() {
        return this.m_aElements.isEmpty();
    }

    protected final boolean isNotEmpty() {
        return this.m_aElements.isNotEmpty();
    }

    @Nonnegative
    protected final int getCount() {
        return this.m_aElements.size();
    }

    protected final boolean containsAny(@Nonnull Predicate<? super DATATYPE> predicate) {
        return this.m_aElements.containsAny(predicate);
    }

    @Nullable
    protected final DATATYPE findFirst(@Nonnull Predicate<? super DATATYPE> predicate) {
        return (DATATYPE)((ICSSWriteable)this.m_aElements.findFirst(predicate));
    }

    protected final void findAll(@Nonnull Predicate<? super DATATYPE> predicate, @Nonnull Collection<? super DATATYPE> collection) {
        this.m_aElements.findAll(predicate, collection::add);
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        int n2 = this.m_aElements.size();
        if (n2 == 0) {
            return "";
        }
        if (n2 == 1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(((ICSSWriteable)this.m_aElements.getFirst()).getAsCSSString(iCSSWriterSettings, n));
            if (!bl) {
                stringBuilder.append(';');
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (ICSSWriteable iCSSWriteable : this.m_aElements) {
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n + 1));
            }
            stringBuilder.append(iCSSWriteable.getAsCSSString(iCSSWriterSettings, n + 1));
            if (!bl || n3 < n2 - 1) {
                stringBuilder.append(';');
            }
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getNewLineString());
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSWritableList cSSWritableList = (CSSWritableList)object;
        return this.m_aElements.equals(cSSWritableList.m_aElements);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aElements).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("elements", this.m_aElements).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

