/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSDeclarationContainer;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.ICSSSelectorMember;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.decl.IHasCSSDeclarations;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSStyleRule
implements ICSSTopLevelRule,
IHasCSSDeclarations<CSSStyleRule>,
ICSSSourceLocationAware {
    private final ICommonsList<CSSSelector> m_aSelectors = new CommonsArrayList();
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasSelectors() {
        return this.m_aSelectors.isNotEmpty();
    }

    @Nonnegative
    public int getSelectorCount() {
        return this.m_aSelectors.size();
    }

    @Nonnull
    public CSSStyleRule addSelector(@Nonnull ICSSSelectorMember iCSSSelectorMember) {
        ValueEnforcer.notNull((Object)iCSSSelectorMember, (String)"SingleSelectorMember");
        return this.addSelector(new CSSSelector().addMember(iCSSSelectorMember));
    }

    @Nonnull
    public CSSStyleRule addSelector(@Nonnull CSSSelector cSSSelector) {
        ValueEnforcer.notNull((Object)cSSSelector, (String)"Selector");
        this.m_aSelectors.add((Object)cSSSelector);
        return this;
    }

    @Nonnull
    public CSSStyleRule addSelector(@Nonnegative int n, @Nonnull ICSSSelectorMember iCSSSelectorMember) {
        ValueEnforcer.notNull((Object)iCSSSelectorMember, (String)"SingleSelectorMember");
        return this.addSelector(n, new CSSSelector().addMember(iCSSSelectorMember));
    }

    @Nonnull
    public CSSStyleRule addSelector(@Nonnegative int n, @Nonnull CSSSelector cSSSelector) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSSelector, (String)"Selector");
        if (n >= this.getSelectorCount()) {
            this.m_aSelectors.add((Object)cSSSelector);
        } else {
            this.m_aSelectors.add(n, (Object)cSSSelector);
        }
        return this;
    }

    @Nonnull
    public EChange removeSelector(@Nonnull CSSSelector cSSSelector) {
        return EChange.valueOf((boolean)this.m_aSelectors.remove((Object)cSSSelector));
    }

    @Nonnull
    public EChange removeSelector(@Nonnegative int n) {
        return this.m_aSelectors.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllSelectors() {
        return this.m_aSelectors.removeAll();
    }

    @Nullable
    public CSSSelector getSelectorAtIndex(@Nonnegative int n) {
        return (CSSSelector)this.m_aSelectors.getAtIndex(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSSelector> getAllSelectors() {
        return (ICommonsList)this.m_aSelectors.getClone();
    }

    @Override
    @Nonnull
    public CSSStyleRule addDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public CSSStyleRule addDeclaration(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(n, cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        return this.m_aDeclarations.removeDeclaration(cSSDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnegative int n) {
        return this.m_aDeclarations.removeDeclaration(n);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        return this.m_aDeclarations.removeAllDeclarations();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return this.m_aDeclarations.getDeclarationAtIndex(n);
    }

    @Override
    @Nonnull
    public CSSStyleRule setDeclarationAtIndex(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.setDeclarationAtIndex(n, cSSDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.m_aDeclarations.hasDeclarations();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String string) {
        return this.m_aDeclarations.getDeclarationOfPropertyName(string);
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyNameCaseInsensitive(@Nullable String string) {
        return this.m_aDeclarations.getDeclarationOfPropertyNameCaseInsensitive(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String string) {
        return this.m_aDeclarations.getAllDeclarationsOfPropertyName(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyNameCaseInsensitive(@Nullable String string) {
        return this.m_aDeclarations.getAllDeclarationsOfPropertyNameCaseInsensitive(string);
    }

    @Nonnull
    public String getSelectorsAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (CSSSelector cSSSelector : this.m_aSelectors) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(',');
                if (!bl) {
                    stringBuilder.append(iCSSWriterSettings.getNewLineString()).append(iCSSWriterSettings.getIndent(n));
                }
            }
            stringBuilder.append(cSSSelector.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && !this.hasDeclarations()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getSelectorsAsCSSString(iCSSWriterSettings, n));
        stringBuilder.append(this.m_aDeclarations.getAsCSSString(iCSSWriterSettings, n));
        if (!bl) {
            stringBuilder.append(iCSSWriterSettings.getNewLineString());
        }
        return stringBuilder.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSStyleRule cSSStyleRule = (CSSStyleRule)object;
        return this.m_aSelectors.equals(cSSStyleRule.m_aSelectors) && this.m_aDeclarations.equals(cSSStyleRule.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aSelectors).append((Object)this.m_aDeclarations).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("selectors", this.m_aSelectors).append("declarations", (Object)this.m_aDeclarations).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

