/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSMediaExpression;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSMediaQuery
implements ICSSWriteable,
ICSSSourceLocationAware {
    private final EModifier m_eModifier;
    private final String m_sMedium;
    private final ICommonsList<CSSMediaExpression> m_aMediaExpressions = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public CSSMediaQuery(@Nullable String string) {
        this(EModifier.NONE, string);
    }

    public CSSMediaQuery(@Nonnull EModifier eModifier, @Nullable String string) {
        ValueEnforcer.notNull((Object)((Object)eModifier), (String)"Modifier");
        this.m_eModifier = eModifier;
        this.m_sMedium = string;
    }

    @Nonnull
    public EModifier getModifier() {
        return this.m_eModifier;
    }

    public boolean isNot() {
        return this.m_eModifier == EModifier.NOT;
    }

    public boolean isOnly() {
        return this.m_eModifier == EModifier.ONLY;
    }

    @Nullable
    public String getMedium() {
        return this.m_sMedium;
    }

    public boolean hasMediaExpressions() {
        return this.m_aMediaExpressions.isNotEmpty();
    }

    @Nonnegative
    public int getMediaExpressionCount() {
        return this.m_aMediaExpressions.size();
    }

    @Nonnull
    public CSSMediaQuery addMediaExpression(@Nonnull CSSMediaExpression cSSMediaExpression) {
        ValueEnforcer.notNull((Object)cSSMediaExpression, (String)"MediaExpression");
        this.m_aMediaExpressions.add((Object)cSSMediaExpression);
        return this;
    }

    @Nonnull
    public CSSMediaQuery addMediaExpression(@Nonnegative int n, @Nonnull CSSMediaExpression cSSMediaExpression) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSMediaExpression, (String)"MediaExpression");
        if (n >= this.getMediaExpressionCount()) {
            this.m_aMediaExpressions.add((Object)cSSMediaExpression);
        } else {
            this.m_aMediaExpressions.add(n, (Object)cSSMediaExpression);
        }
        return this;
    }

    @Nonnull
    public EChange removeMediaExpression(@Nullable CSSMediaExpression cSSMediaExpression) {
        return EChange.valueOf((boolean)this.m_aMediaExpressions.remove((Object)cSSMediaExpression));
    }

    @Nonnull
    public EChange removeMediaExpression(int n) {
        return this.m_aMediaExpressions.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllMediaExpressions() {
        return this.m_aMediaExpressions.removeAll();
    }

    @Nullable
    public CSSMediaExpression getMediaExpression(@Nonnegative int n) {
        return (CSSMediaExpression)this.m_aMediaExpressions.getAtIndex(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSMediaExpression> getAllMediaExpressions() {
        return (ICommonsList)this.m_aMediaExpressions.getClone();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_eModifier.getCSSText());
        boolean bl = true;
        if (this.m_sMedium != null) {
            stringBuilder.append(this.m_sMedium);
            bl = false;
        }
        if (this.m_aMediaExpressions.isNotEmpty()) {
            for (CSSMediaExpression cSSMediaExpression : this.m_aMediaExpressions) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(" and ");
                }
                stringBuilder.append(cSSMediaExpression.getAsCSSString(iCSSWriterSettings, n));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSMediaQuery cSSMediaQuery = (CSSMediaQuery)object;
        return this.m_eModifier.equals((Object)cSSMediaQuery.m_eModifier) && EqualsHelper.equals((Object)this.m_sMedium, (Object)cSSMediaQuery.m_sMedium) && this.m_aMediaExpressions.equals(cSSMediaQuery.m_aMediaExpressions);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eModifier).append((Object)this.m_sMedium).append(this.m_aMediaExpressions).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("modifier", (Enum)this.m_eModifier).append("medium", (Object)this.m_sMedium).append("expressions", this.m_aMediaExpressions).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }

    public static enum EModifier {
        NONE(""),
        NOT("not "),
        ONLY("only ");

        private final String m_sText;

        private EModifier(String string2) {
            this.m_sText = string2;
        }

        @Nonnull
        public String getCSSText() {
            return this.m_sText;
        }
    }
}

