/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSWritableList;
import com.helger.css.decl.IHasCSSDeclarations;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSDeclarationList
extends CSSWritableList<CSSDeclaration>
implements IHasCSSDeclarations<CSSDeclarationList> {
    @Override
    @Nonnull
    public final CSSDeclarationList addDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        this.add(cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public CSSDeclarationList addDeclaration(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.add(n, cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        return this.remove(cSSDeclaration);
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnegative int n) {
        return this.remove(n);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        return this.removeAll();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.getAll();
    }

    @Override
    @Nullable
    public final CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return (CSSDeclaration)this.getAtIndex(n);
    }

    @Override
    @Nonnull
    public CSSDeclarationList setDeclarationAtIndex(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        this.set(n, cSSDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.isNotEmpty();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.getCount();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return this.findFirst(cSSDeclaration -> cSSDeclaration.getProperty().equals(string));
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyNameCaseInsensitive(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        return this.findFirst(cSSDeclaration -> cSSDeclaration.getProperty().equalsIgnoreCase(string));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String string) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (StringHelper.hasText((String)string)) {
            this.findAll(cSSDeclaration -> cSSDeclaration.getProperty().equals(string), commonsArrayList);
        }
        return commonsArrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyNameCaseInsensitive(@Nullable String string) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (StringHelper.hasText((String)string)) {
            this.findAll(cSSDeclaration -> cSSDeclaration.getProperty().equalsIgnoreCase(string), commonsArrayList);
        }
        return commonsArrayList;
    }
}

