/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSDeclarationList;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.CSSExpressionMemberFunction;
import com.helger.css.decl.CSSExpressionMemberMath;
import com.helger.css.decl.CSSExpressionMemberMathProduct;
import com.helger.css.decl.CSSExpressionMemberMathUnitProduct;
import com.helger.css.decl.CSSExpressionMemberMathUnitSimple;
import com.helger.css.decl.CSSExpressionMemberTermSimple;
import com.helger.css.decl.CSSExpressionMemberTermURI;
import com.helger.css.decl.CSSFontFaceRule;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSKeyframesBlock;
import com.helger.css.decl.CSSKeyframesRule;
import com.helger.css.decl.CSSMediaExpression;
import com.helger.css.decl.CSSMediaQuery;
import com.helger.css.decl.CSSMediaRule;
import com.helger.css.decl.CSSNamespaceRule;
import com.helger.css.decl.CSSPageRule;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.CSSSelectorAttribute;
import com.helger.css.decl.CSSSelectorMemberFunctionLike;
import com.helger.css.decl.CSSSelectorMemberNot;
import com.helger.css.decl.CSSSelectorSimpleMember;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CSSSupportsConditionDeclaration;
import com.helger.css.decl.CSSSupportsConditionNegation;
import com.helger.css.decl.CSSSupportsConditionNested;
import com.helger.css.decl.CSSSupportsRule;
import com.helger.css.decl.CSSURI;
import com.helger.css.decl.CSSUnknownRule;
import com.helger.css.decl.CSSViewportRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ECSSAttributeOperator;
import com.helger.css.decl.ECSSExpressionOperator;
import com.helger.css.decl.ECSSMathOperator;
import com.helger.css.decl.ECSSSelectorCombinator;
import com.helger.css.decl.ECSSSupportsConditionOperator;
import com.helger.css.decl.ICSSExpressionMathMember;
import com.helger.css.decl.ICSSExpressionMember;
import com.helger.css.decl.ICSSSelectorMember;
import com.helger.css.decl.ICSSSupportsConditionMember;
import com.helger.css.handler.CSSHandlingException;
import com.helger.css.handler.ECSSNodeType;
import com.helger.css.media.ECSSMediaExpressionFeature;
import com.helger.css.media.ECSSMedium;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.CSSParseHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
final class CSSNodeToDomainObject {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSNodeToDomainObject.class);
    private final ECSSVersion m_eVersion;

    public CSSNodeToDomainObject(@Nonnull ECSSVersion eCSSVersion) {
        this.m_eVersion = (ECSSVersion)((Object)ValueEnforcer.notNull((Object)((Object)eCSSVersion), (String)"Version"));
    }

    private void _expectNodeType(@Nonnull CSSNode cSSNode, @Nonnull ECSSNodeType eCSSNodeType) {
        if (!eCSSNodeType.isNode(cSSNode, this.m_eVersion)) {
            throw new CSSHandlingException(cSSNode, "Expected a '" + eCSSNodeType.getNodeName(this.m_eVersion) + "' node but received a '" + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + "'");
        }
    }

    private static void _throwUnexpectedChildrenCount(@Nonnull CSSNode cSSNode, @Nonnull @Nonempty String string) {
        s_aLogger.error(string);
        for (int i = 0; i < cSSNode.jjtGetNumChildren(); ++i) {
            s_aLogger.error("  " + cSSNode.jjtGetChild(i));
        }
        throw new CSSHandlingException(cSSNode, string);
    }

    @Nonnull
    private CSSImportRule _createImportRule(@Nonnull CSSNode cSSNode) {
        Serializable serializable;
        this._expectNodeType(cSSNode, ECSSNodeType.IMPORTRULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 2) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(cSSNode, "Expected at last 2 children but got " + n + "!");
        }
        CSSURI cSSURI = null;
        int n2 = 0;
        if (n > 0) {
            serializable = cSSNode.jjtGetChild(0);
            if (ECSSNodeType.URL.isNode((CSSNode)serializable, this.m_eVersion)) {
                cSSURI = new CSSURI(((CSSNode)serializable).getText());
                cSSURI.setSourceLocation(((CSSNode)serializable).getSourceLocation());
                ++n2;
            } else if (!ECSSNodeType.MEDIALIST.isNode((CSSNode)serializable, this.m_eVersion)) {
                throw new IllegalStateException("Expected an URI or MEDIALIST node but got " + ECSSNodeType.getNodeName((CSSNode)serializable, this.m_eVersion));
            }
        }
        if (cSSURI == null) {
            cSSURI = new CSSURI(CSSParseHelper.extractStringValue(cSSNode.getText()));
        }
        serializable = new CSSImportRule(cSSURI);
        ((CSSImportRule)serializable).setSourceLocation(cSSNode.getSourceLocation());
        if (n > n2) {
            CSSNode cSSNode2 = cSSNode.jjtGetChild(n2);
            if (ECSSNodeType.MEDIALIST.isNode(cSSNode2, this.m_eVersion)) {
                for (CSSNode cSSNode3 : cSSNode2) {
                    ((CSSImportRule)serializable).addMediaQuery(this._createMediaQuery(cSSNode3));
                }
                ++n2;
            } else {
                s_aLogger.error("Expected an MEDIALIST node but got " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
            }
        }
        if (n2 < n) {
            s_aLogger.error("Import statement has children which are unhandled.");
        }
        return serializable;
    }

    @Nonnull
    private CSSSelectorAttribute _createSelectorAttribute(@Nonnull CSSNode cSSNode) {
        CSSSelectorAttribute cSSSelectorAttribute;
        this._expectNodeType(cSSNode, ECSSNodeType.ATTRIB);
        int n = cSSNode.jjtGetNumChildren();
        String string = null;
        int n2 = 0;
        if (n > 0 && ECSSNodeType.NAMESPACEPREFIX.isNode(cSSNode.jjtGetChild(0), this.m_eVersion)) {
            string = cSSNode.jjtGetChild(0).getText();
            n2 = 1;
        }
        String string2 = cSSNode.getText();
        if (n == n2) {
            cSSSelectorAttribute = new CSSSelectorAttribute(string, string2);
        } else {
            int n3 = n2 + 2;
            if (n != n3) {
                CSSNodeToDomainObject._throwUnexpectedChildrenCount(cSSNode, "Illegal number of children present (" + n + ") - expected " + n3);
            }
            CSSNode cSSNode2 = cSSNode.jjtGetChild(n2);
            this._expectNodeType(cSSNode2, ECSSNodeType.ATTRIBOPERATOR);
            CSSNode cSSNode3 = cSSNode.jjtGetChild(n2 + 1);
            this._expectNodeType(cSSNode3, ECSSNodeType.ATTRIBVALUE);
            cSSSelectorAttribute = new CSSSelectorAttribute(string, string2, ECSSAttributeOperator.getFromNameOrNull(cSSNode2.getText()), cSSNode3.getText());
        }
        cSSSelectorAttribute.setSourceLocation(cSSNode.getSourceLocation());
        return cSSSelectorAttribute;
    }

    @Nullable
    private ICSSSelectorMember _createSelectorMember(CSSNode cSSNode) {
        int n = cSSNode.jjtGetNumChildren();
        if (ECSSNodeType.NAMESPACEPREFIX.isNode(cSSNode, this.m_eVersion) || ECSSNodeType.ELEMENTNAME.isNode(cSSNode, this.m_eVersion) || ECSSNodeType.HASH.isNode(cSSNode, this.m_eVersion) || ECSSNodeType.CLASS.isNode(cSSNode, this.m_eVersion)) {
            if (n != 0) {
                CSSNodeToDomainObject._throwUnexpectedChildrenCount(cSSNode, "CSS simple selector member expected 0 children and got " + n);
            }
            CSSSelectorSimpleMember cSSSelectorSimpleMember = new CSSSelectorSimpleMember(cSSNode.getText());
            cSSSelectorSimpleMember.setSourceLocation(cSSNode.getSourceLocation());
            return cSSSelectorSimpleMember;
        }
        if (ECSSNodeType.ATTRIB.isNode(cSSNode, this.m_eVersion)) {
            return this._createSelectorAttribute(cSSNode);
        }
        if (ECSSNodeType.SELECTORCOMBINATOR.isNode(cSSNode, this.m_eVersion)) {
            String string = cSSNode.getText();
            ECSSSelectorCombinator eCSSSelectorCombinator = ECSSSelectorCombinator.getFromNameOrNull(string);
            if (eCSSSelectorCombinator == null) {
                s_aLogger.error("Failed to parse CSS selector combinator '" + string + "'");
            }
            return eCSSSelectorCombinator;
        }
        if (ECSSNodeType.NEGATION.isNode(cSSNode, this.m_eVersion)) {
            ArrayList<CSSSelector> arrayList = new ArrayList<CSSSelector>();
            for (int i = 0; i < n; ++i) {
                CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
                CSSSelector cSSSelector = this._createSelector(cSSNode2);
                arrayList.add(cSSSelector);
            }
            CSSSelectorMemberNot cSSSelectorMemberNot = new CSSSelectorMemberNot(arrayList);
            cSSSelectorMemberNot.setSourceLocation(cSSNode.getSourceLocation());
            return cSSSelectorMemberNot;
        }
        if (ECSSNodeType.PSEUDO.isNode(cSSNode, this.m_eVersion)) {
            if (n == 0) {
                CSSSelectorSimpleMember cSSSelectorSimpleMember = new CSSSelectorSimpleMember(cSSNode.getText());
                cSSSelectorSimpleMember.setSourceLocation(cSSNode.getSourceLocation());
                return cSSSelectorSimpleMember;
            }
            if (n == 1) {
                CSSNode cSSNode3 = cSSNode.jjtGetChild(0);
                if (ECSSNodeType.NTH.isNode(cSSNode3, this.m_eVersion)) {
                    CSSSelectorSimpleMember cSSSelectorSimpleMember = new CSSSelectorSimpleMember(cSSNode.getText() + cSSNode3.getText() + ")");
                    cSSSelectorSimpleMember.setSourceLocation(cSSNode.getSourceLocation());
                    return cSSSelectorSimpleMember;
                }
                CSSExpression cSSExpression = this._createExpression(cSSNode3);
                CSSSelectorMemberFunctionLike cSSSelectorMemberFunctionLike = new CSSSelectorMemberFunctionLike(cSSNode.getText(), cSSExpression);
                cSSSelectorMemberFunctionLike.setSourceLocation(cSSNode.getSourceLocation());
                return cSSSelectorMemberFunctionLike;
            }
            throw new UnsupportedOperationException("Not supporting pseudo-selectors with functions and " + n + " args: " + cSSNode.toString());
        }
        s_aLogger.error("Unsupported selector child: " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion));
        return null;
    }

    @Nonnull
    private CSSSelector _createSelector(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.SELECTOR);
        CSSSelector cSSSelector = new CSSSelector();
        cSSSelector.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            ICSSSelectorMember iCSSSelectorMember = this._createSelectorMember(cSSNode2);
            if (iCSSSelectorMember == null) continue;
            cSSSelector.addMember(iCSSSelectorMember);
        }
        return cSSSelector;
    }

    @Nonnull
    private CSSExpressionMemberMathProduct _createExpressionMathProduct(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.MATHPRODUCT);
        CSSExpressionMemberMathProduct cSSExpressionMemberMathProduct = new CSSExpressionMemberMathProduct();
        cSSExpressionMemberMathProduct.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            Serializable serializable;
            if (ECSSNodeType.MATHUNIT.isNode(cSSNode2, this.m_eVersion)) {
                int n = cSSNode2.jjtGetNumChildren();
                if (n == 0) {
                    serializable = new CSSExpressionMemberMathUnitSimple(cSSNode2.getText());
                    serializable.setSourceLocation(cSSNode2.getSourceLocation());
                    cSSExpressionMemberMathProduct.addMember((ICSSExpressionMathMember)serializable);
                    continue;
                }
                if (n != 1) {
                    CSSNodeToDomainObject._throwUnexpectedChildrenCount(cSSNode2, "CSS math unit expected 1 child and got " + n);
                }
                serializable = cSSNode2.jjtGetChild(0);
                CSSExpressionMemberMathProduct cSSExpressionMemberMathProduct2 = this._createExpressionMathProduct((CSSNode)serializable);
                CSSExpressionMemberMathUnitProduct cSSExpressionMemberMathUnitProduct = new CSSExpressionMemberMathUnitProduct(cSSExpressionMemberMathProduct2);
                cSSExpressionMemberMathProduct.addMember(cSSExpressionMemberMathUnitProduct);
                continue;
            }
            if (ECSSNodeType.MATHPRODUCTOPERATOR.isNode(cSSNode2, this.m_eVersion)) {
                String string = cSSNode2.getText();
                serializable = ECSSMathOperator.getFromNameOrNull(string);
                if (serializable == null) {
                    s_aLogger.error("Failed to parse math product operator '" + string + "'");
                    continue;
                }
                cSSExpressionMemberMathProduct.addMember((ICSSExpressionMathMember)serializable);
                continue;
            }
            s_aLogger.error("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSExpressionMemberMathProduct;
    }

    @Nonnull
    private CSSExpressionMemberTermURI _createExpressionURL(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.URL);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 0) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(cSSNode, "Expected 0 children but got " + n + "!");
        }
        CSSURI cSSURI = new CSSURI(cSSNode.getText());
        cSSURI.setSourceLocation(cSSNode.getSourceLocation());
        return new CSSExpressionMemberTermURI(cSSURI);
    }

    @Nonnull
    private CSSExpressionMemberFunction _createExpressionFunction(@Nonnull CSSNode cSSNode) {
        CSSExpressionMemberFunction cSSExpressionMemberFunction;
        this._expectNodeType(cSSNode, ECSSNodeType.FUNCTION);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 1) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(cSSNode, "Expected 0 or 1 children but got " + n + "!");
        }
        String string = cSSNode.getText();
        if (n == 1) {
            CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
            CSSExpression cSSExpression = this._createExpression(cSSNode2);
            cSSExpressionMemberFunction = new CSSExpressionMemberFunction(string, cSSExpression);
        } else {
            cSSExpressionMemberFunction = new CSSExpressionMemberFunction(string);
        }
        cSSExpressionMemberFunction.setSourceLocation(cSSNode.getSourceLocation());
        return cSSExpressionMemberFunction;
    }

    @Nonnull
    private CSSExpressionMemberMath _createExpressionMathTerm(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.MATH);
        CSSExpressionMemberMath cSSExpressionMemberMath = new CSSExpressionMemberMath();
        cSSExpressionMemberMath.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.MATHPRODUCT.isNode(cSSNode2, this.m_eVersion)) {
                cSSExpressionMemberMath.addMember(this._createExpressionMathProduct(cSSNode2));
                continue;
            }
            if (ECSSNodeType.MATHSUMOPERATOR.isNode(cSSNode2, this.m_eVersion)) {
                String string = cSSNode2.getText();
                ECSSMathOperator eCSSMathOperator = ECSSMathOperator.getFromNameOrNull(string);
                if (eCSSMathOperator == null) {
                    s_aLogger.error("Failed to parse math operator '" + string + "'");
                    continue;
                }
                cSSExpressionMemberMath.addMember(eCSSMathOperator);
                continue;
            }
            s_aLogger.error("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSExpressionMemberMath;
    }

    @Nonnull
    private ICSSExpressionMember _createExpressionTerm(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.EXPRTERM);
        int n = cSSNode.jjtGetNumChildren();
        if (n > 1) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(cSSNode, "Expected 0 or 1 children but got " + n + "!");
        }
        if (n == 0) {
            CSSExpressionMemberTermSimple cSSExpressionMemberTermSimple = new CSSExpressionMemberTermSimple(cSSNode.getText());
            cSSExpressionMemberTermSimple.setSourceLocation(cSSNode.getSourceLocation());
            return cSSExpressionMemberTermSimple;
        }
        CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
        if (ECSSNodeType.URL.isNode(cSSNode2, this.m_eVersion)) {
            return this._createExpressionURL(cSSNode2);
        }
        if (ECSSNodeType.FUNCTION.isNode(cSSNode2, this.m_eVersion)) {
            return this._createExpressionFunction(cSSNode2);
        }
        if (ECSSNodeType.MATH.isNode(cSSNode2, this.m_eVersion)) {
            return this._createExpressionMathTerm(cSSNode2);
        }
        throw new IllegalStateException("Expected an expression term but got " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
    }

    @Nonnull
    private CSSExpression _createExpression(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.EXPR);
        CSSExpression cSSExpression = new CSSExpression();
        cSSExpression.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.EXPRTERM.isNode(cSSNode2, this.m_eVersion)) {
                cSSExpression.addMember(this._createExpressionTerm(cSSNode2));
                continue;
            }
            if (ECSSNodeType.EXPROPERATOR.isNode(cSSNode2, this.m_eVersion)) {
                String string = cSSNode2.getText();
                ECSSExpressionOperator eCSSExpressionOperator = ECSSExpressionOperator.getFromNameOrNull(string);
                if (eCSSExpressionOperator == null) {
                    s_aLogger.error("Failed to parse expression operator '" + string + "'");
                    continue;
                }
                cSSExpression.addMember(eCSSExpressionOperator);
                continue;
            }
            s_aLogger.error("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSExpression;
    }

    @Nullable
    private CSSDeclaration _createDeclaration(@Nonnull CSSNode cSSNode) {
        Serializable serializable;
        this._expectNodeType(cSSNode, ECSSNodeType.STYLEDECLARATION);
        int n = cSSNode.jjtGetNumChildren();
        if (n < 1 || n > 3) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(cSSNode, "Expected 1-3 children but got " + n + "!");
        }
        if (n == 1) {
            return null;
        }
        if (!ECSSNodeType.EXPR.isNode(cSSNode.jjtGetChild(1), this.m_eVersion)) {
            return null;
        }
        String string = cSSNode.jjtGetChild(0).getText();
        CSSExpression cSSExpression = this._createExpression(cSSNode.jjtGetChild(1));
        boolean bl = false;
        if (n == 3) {
            serializable = cSSNode.jjtGetChild(2);
            if (ECSSNodeType.IMPORTANT.isNode((CSSNode)serializable, this.m_eVersion)) {
                bl = true;
            } else {
                s_aLogger.error("Expected an " + ECSSNodeType.IMPORTANT.getNodeName(this.m_eVersion) + " token but got a " + ECSSNodeType.getNodeName((CSSNode)serializable, this.m_eVersion));
            }
        }
        serializable = new CSSDeclaration(string, cSSExpression, bl);
        ((CSSDeclaration)serializable).setSourceLocation(cSSNode.getSourceLocation());
        return serializable;
    }

    @Nonnull
    private CSSStyleRule _createStyleRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.STYLERULE);
        CSSStyleRule cSSStyleRule = new CSSStyleRule();
        cSSStyleRule.setSourceLocation(cSSNode.getSourceLocation());
        boolean bl = true;
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.SELECTOR.isNode(cSSNode2, this.m_eVersion)) {
                if (!bl) {
                    s_aLogger.error("Found a selector after a declaration!");
                }
                cSSStyleRule.addSelector(this._createSelector(cSSNode2));
                continue;
            }
            bl = false;
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode2, this.m_eVersion)) {
                int n = cSSNode2.jjtGetNumChildren();
                for (int i = 0; i < n; ++i) {
                    CSSDeclaration cSSDeclaration;
                    CSSNode cSSNode3 = cSSNode2.jjtGetChild(i);
                    if (ECSSNodeType.isErrorNode(cSSNode3, this.m_eVersion) || (cSSDeclaration = this._createDeclaration(cSSNode3)) == null) continue;
                    cSSStyleRule.addDeclaration(cSSDeclaration);
                }
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            s_aLogger.error("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSStyleRule;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private CSSPageRule _createPageRule(@Nonnull CSSNode cSSNode) {
        Serializable serializable;
        this._expectNodeType(cSSNode, ECSSNodeType.PAGERULE);
        int n = cSSNode.jjtGetNumChildren();
        String string = null;
        int n2 = 0;
        if (n > 0 && ECSSNodeType.PSEUDOPAGE.isNode((CSSNode)(serializable = cSSNode.jjtGetChild(0)), this.m_eVersion)) {
            string = ((CSSNode)serializable).getText();
            ++n2;
        }
        serializable = new CSSPageRule(string);
        ((CSSPageRule)serializable).setSourceLocation(cSSNode.getSourceLocation());
        for (int i = n2; i < n; ++i) {
            CSSNode cSSNode2 = cSSNode.jjtGetChild(i);
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode2, this.m_eVersion)) {
                int n3 = cSSNode2.jjtGetNumChildren();
                for (int j = 0; j < n3; ++j) {
                    CSSDeclaration cSSDeclaration = this._createDeclaration(cSSNode2.jjtGetChild(j));
                    if (cSSDeclaration == null) continue;
                    ((CSSPageRule)serializable).addDeclaration(cSSDeclaration);
                }
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            s_aLogger.error("Unsupported page rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return serializable;
    }

    @Nonnull
    private CSSMediaRule _createMediaRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.MEDIARULE);
        CSSMediaRule cSSMediaRule = new CSSMediaRule();
        cSSMediaRule.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.MEDIALIST.isNode(cSSNode2, this.m_eVersion)) {
                for (CSSNode cSSNode3 : cSSNode2) {
                    cSSMediaRule.addMediaQuery(this._createMediaQuery(cSSNode3));
                }
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createStyleRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createMediaRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createPageRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createFontFaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createKeyframesRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createViewportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSMediaRule.addRule(this._createSupportsRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            s_aLogger.error("Unsupported media-rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSMediaRule;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private CSSMediaQuery _createMediaQuery(@Nonnull CSSNode cSSNode) {
        Object object;
        Object object2;
        if (ECSSNodeType.MEDIUM.isNode(cSSNode, this.m_eVersion)) {
            String string = cSSNode.getText();
            if (ECSSMedium.getFromNameOrNull(string) == null) {
                s_aLogger.warn("CSS " + this.m_eVersion.getVersionString() + " Media query uses unknown medium '" + string + "'");
            }
            CSSMediaQuery cSSMediaQuery = new CSSMediaQuery(CSSMediaQuery.EModifier.NONE, string);
            cSSMediaQuery.setSourceLocation(cSSNode.getSourceLocation());
            return cSSMediaQuery;
        }
        this._expectNodeType(cSSNode, ECSSNodeType.MEDIAQUERY);
        int n = cSSNode.jjtGetNumChildren();
        int n2 = 0;
        CSSMediaQuery.EModifier eModifier = CSSMediaQuery.EModifier.NONE;
        if (n > 0 && ECSSNodeType.MEDIAMODIFIER.isNode((CSSNode)(object2 = cSSNode.jjtGetChild(0)), this.m_eVersion)) {
            object = ((CSSNode)object2).getText();
            if (object != null) {
                if ("not".equalsIgnoreCase((String)object)) {
                    eModifier = CSSMediaQuery.EModifier.NOT;
                } else if ("only".equalsIgnoreCase((String)object)) {
                    eModifier = CSSMediaQuery.EModifier.ONLY;
                } else {
                    s_aLogger.error("Unsupported media modifier '" + (String)object + "' found!");
                }
            }
            ++n2;
        }
        object2 = null;
        if (n > n2 && ECSSNodeType.MEDIUM.isNode((CSSNode)(object = cSSNode.jjtGetChild(n2)), this.m_eVersion)) {
            object2 = ((CSSNode)object).getText();
            if (ECSSMedium.getFromNameOrNull((String)object2) == null) {
                s_aLogger.warn("CSS " + this.m_eVersion.getVersionString() + " media query uses unknown medium '" + (String)object2 + "'");
            }
            ++n2;
        }
        object = new CSSMediaQuery(eModifier, (String)object2);
        ((CSSMediaQuery)object).setSourceLocation(cSSNode.getSourceLocation());
        for (int i = n2; i < n; ++i) {
            CSSNode cSSNode2 = cSSNode.jjtGetChild(i);
            if (ECSSNodeType.MEDIAEXPR.isNode(cSSNode2, this.m_eVersion)) {
                ((CSSMediaQuery)object).addMediaExpression(this._createMediaExpr(cSSNode2));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            s_aLogger.error("Unsupported media query child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return object;
    }

    @Nonnull
    private CSSMediaExpression _createMediaExpr(@Nonnull CSSNode cSSNode) {
        CSSMediaExpression cSSMediaExpression;
        CSSNode cSSNode2;
        this._expectNodeType(cSSNode, ECSSNodeType.MEDIAEXPR);
        int n = cSSNode.jjtGetNumChildren();
        if (n != 1 && n != 2) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(cSSNode, "Expected 1 or 2 children but got " + n + "!");
        }
        if (!ECSSNodeType.MEDIAFEATURE.isNode(cSSNode2 = cSSNode.jjtGetChild(0), this.m_eVersion)) {
            throw new IllegalStateException("Expected a media feature but got " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        String string = cSSNode2.getText();
        if (ECSSMediaExpressionFeature.getFromNameOrNull(string) == null) {
            s_aLogger.warn("Media expression uses unknown feature '" + string + "'");
        }
        if (n == 1) {
            cSSMediaExpression = new CSSMediaExpression(string);
        } else {
            CSSNode cSSNode3 = cSSNode.jjtGetChild(1);
            cSSMediaExpression = new CSSMediaExpression(string, this._createExpression(cSSNode3));
        }
        cSSMediaExpression.setSourceLocation(cSSNode.getSourceLocation());
        return cSSMediaExpression;
    }

    @Nonnull
    private CSSFontFaceRule _createFontFaceRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.FONTFACERULE);
        CSSFontFaceRule cSSFontFaceRule = new CSSFontFaceRule();
        cSSFontFaceRule.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode2, this.m_eVersion)) {
                int n = cSSNode2.jjtGetNumChildren();
                for (int i = 0; i < n; ++i) {
                    CSSDeclaration cSSDeclaration = this._createDeclaration(cSSNode2.jjtGetChild(i));
                    if (cSSDeclaration == null) continue;
                    cSSFontFaceRule.addDeclaration(cSSDeclaration);
                }
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            s_aLogger.error("Unsupported font-face rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSFontFaceRule;
    }

    @Nonnull
    private CSSKeyframesRule _createKeyframesRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.KEYFRAMESRULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n == 0) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(cSSNode, "Expected at least 1 child but got " + n + "!");
        }
        String string = cSSNode.getText();
        CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
        this._expectNodeType(cSSNode2, ECSSNodeType.KEYFRAMESIDENTIFIER);
        String string2 = cSSNode2.getText();
        CSSKeyframesRule cSSKeyframesRule = new CSSKeyframesRule(string, string2);
        cSSKeyframesRule.setSourceLocation(cSSNode.getSourceLocation());
        CSSKeyframesBlock cSSKeyframesBlock = null;
        for (int i = 1; i < n; ++i) {
            CSSNode cSSNode3 = cSSNode.jjtGetChild(i);
            if (ECSSNodeType.KEYFRAMESSELECTOR.isNode(cSSNode3, this.m_eVersion)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Serializable serializable : cSSNode3) {
                    this._expectNodeType((CSSNode)serializable, ECSSNodeType.SINGLEKEYFRAMESELECTOR);
                    arrayList.add(serializable.getText());
                }
                cSSKeyframesBlock = new CSSKeyframesBlock(arrayList);
                cSSKeyframesBlock.setSourceLocation(cSSNode3.getSourceLocation());
                cSSKeyframesRule.addBlock(cSSKeyframesBlock);
                continue;
            }
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode3, this.m_eVersion)) {
                if (cSSKeyframesBlock == null) {
                    throw new IllegalStateException("No keyframes block present!");
                }
                int n2 = cSSNode3.jjtGetNumChildren();
                for (int j = 0; j < n2; ++j) {
                    Serializable serializable;
                    serializable = this._createDeclaration(cSSNode3.jjtGetChild(j));
                    if (serializable == null) continue;
                    cSSKeyframesBlock.addDeclaration((CSSDeclaration)serializable);
                }
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode3, this.m_eVersion)) continue;
            s_aLogger.error("Unsupported keyframes rule child: " + ECSSNodeType.getNodeName(cSSNode3, this.m_eVersion));
        }
        return cSSKeyframesRule;
    }

    @Nonnull
    private CSSViewportRule _createViewportRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.VIEWPORTRULE);
        String string = cSSNode.getText();
        CSSViewportRule cSSViewportRule = new CSSViewportRule(string);
        cSSViewportRule.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode2, this.m_eVersion)) {
                int n = cSSNode2.jjtGetNumChildren();
                for (int i = 0; i < n; ++i) {
                    CSSDeclaration cSSDeclaration = this._createDeclaration(cSSNode2.jjtGetChild(i));
                    if (cSSDeclaration == null) continue;
                    cSSViewportRule.addDeclaration(cSSDeclaration);
                }
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            s_aLogger.error("Unsupported viewport rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSViewportRule;
    }

    @Nonnull
    private CSSNamespaceRule _createNamespaceRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.NAMESPACERULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n < 1 || n > 2) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(cSSNode, "Expected at least 1 child and at last 2 children but got " + n + "!");
        }
        String string = null;
        int n2 = 0;
        if (ECSSNodeType.NAMESPACERULEPREFIX.isNode(cSSNode.jjtGetChild(0), this.m_eVersion)) {
            string = cSSNode.jjtGetChild(0).getText();
            ++n2;
        }
        CSSNode cSSNode2 = cSSNode.jjtGetChild(n2);
        this._expectNodeType(cSSNode2, ECSSNodeType.NAMESPACERULEURL);
        String string2 = CSSParseHelper.extractStringValue(cSSNode2.getText());
        CSSNamespaceRule cSSNamespaceRule = new CSSNamespaceRule(string, string2);
        cSSNamespaceRule.setSourceLocation(cSSNode.getSourceLocation());
        return cSSNamespaceRule;
    }

    @Nullable
    private ICSSSupportsConditionMember _createSupportsConditionMemberRecursive(@Nonnull CSSNode cSSNode) {
        int n = cSSNode.jjtGetNumChildren();
        if (ECSSNodeType.SUPPORTSCONDITIONOPERATOR.isNode(cSSNode, this.m_eVersion)) {
            if (n != 0) {
                CSSNodeToDomainObject._throwUnexpectedChildrenCount(cSSNode, "Expected no children but got " + n + "!");
            }
            return ECSSSupportsConditionOperator.getFromNameCaseInsensitiveOrNull(cSSNode.getText());
        }
        if (ECSSNodeType.SUPPORTSNEGATION.isNode(cSSNode, this.m_eVersion)) {
            ICSSSupportsConditionMember iCSSSupportsConditionMember;
            if (n != 1) {
                CSSNodeToDomainObject._throwUnexpectedChildrenCount(cSSNode, "Expected at exactly 1 child but got " + n + "!");
            }
            if ((iCSSSupportsConditionMember = this._createSupportsConditionMemberRecursive(cSSNode.jjtGetChild(0))) == null) {
                return null;
            }
            CSSSupportsConditionNegation cSSSupportsConditionNegation = new CSSSupportsConditionNegation(iCSSSupportsConditionMember);
            cSSSupportsConditionNegation.setSourceLocation(cSSNode.getSourceLocation());
            return cSSSupportsConditionNegation;
        }
        if (ECSSNodeType.SUPPORTSCONDITIONINPARENS.isNode(cSSNode, this.m_eVersion)) {
            CSSNode cSSNode2;
            if (n != 1) {
                CSSNodeToDomainObject._throwUnexpectedChildrenCount(cSSNode, "Expected at exactly 1 child but got " + n + "!");
            }
            if (ECSSNodeType.STYLEDECLARATION.isNode(cSSNode2 = cSSNode.jjtGetChild(0), this.m_eVersion)) {
                CSSDeclaration cSSDeclaration = this._createDeclaration(cSSNode2);
                if (cSSDeclaration == null) {
                    throw new CSSHandlingException(cSSNode2, "The style declaration in the @supports rule is invalid!");
                }
                CSSSupportsConditionDeclaration cSSSupportsConditionDeclaration = new CSSSupportsConditionDeclaration(cSSDeclaration);
                cSSSupportsConditionDeclaration.setSourceLocation(cSSNode.getSourceLocation());
                return cSSSupportsConditionDeclaration;
            }
            if (ECSSNodeType.SUPPORTSCONDITION.isNode(cSSNode2, this.m_eVersion)) {
                CSSSupportsConditionNested cSSSupportsConditionNested = new CSSSupportsConditionNested();
                for (CSSNode cSSNode3 : cSSNode2) {
                    ICSSSupportsConditionMember iCSSSupportsConditionMember = this._createSupportsConditionMemberRecursive(cSSNode3);
                    if (iCSSSupportsConditionMember == null) continue;
                    cSSSupportsConditionNested.addMember(iCSSSupportsConditionMember);
                }
                return cSSSupportsConditionNested;
            }
            s_aLogger.error("Unsupported supportsConditionInParents child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
            return null;
        }
        if (!ECSSNodeType.isErrorNode(cSSNode, this.m_eVersion)) {
            s_aLogger.error("Unsupported supports-condition child: " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion));
        }
        return null;
    }

    @Nonnull
    private CSSSupportsRule _createSupportsRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.SUPPORTSRULE);
        CSSSupportsRule cSSSupportsRule = new CSSSupportsRule();
        cSSSupportsRule.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.SUPPORTSCONDITION.isNode(cSSNode2, this.m_eVersion)) {
                for (CSSNode cSSNode3 : cSSNode2) {
                    ICSSSupportsConditionMember iCSSSupportsConditionMember = this._createSupportsConditionMemberRecursive(cSSNode3);
                    if (iCSSSupportsConditionMember == null) continue;
                    cSSSupportsRule.addSupportConditionMember(iCSSSupportsConditionMember);
                }
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createStyleRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createMediaRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createPageRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createFontFaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createKeyframesRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createViewportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(cSSNode2, this.m_eVersion)) {
                cSSSupportsRule.addRule(this._createSupportsRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.isErrorNode(cSSNode2, this.m_eVersion)) continue;
            s_aLogger.error("Unsupported supports-rule child: " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cSSSupportsRule;
    }

    @Nonnull
    private CSSUnknownRule _createUnknownRule(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.UNKNOWNRULE);
        int n = cSSNode.jjtGetNumChildren();
        if (n != 2) {
            CSSNodeToDomainObject._throwUnexpectedChildrenCount(cSSNode, "Expected 2 children but got " + n + "!");
        }
        CSSNode cSSNode2 = cSSNode.jjtGetChild(0);
        this._expectNodeType(cSSNode2, ECSSNodeType.UNKNOWNRULEPARAMETERLIST);
        CSSNode cSSNode3 = cSSNode.jjtGetChild(1);
        this._expectNodeType(cSSNode3, ECSSNodeType.UNKNOWNRULEBODY);
        String string = cSSNode.getText();
        CSSUnknownRule cSSUnknownRule = new CSSUnknownRule(string);
        cSSUnknownRule.setSourceLocation(cSSNode.getSourceLocation());
        cSSUnknownRule.setParameterList(cSSNode2.getText());
        cSSUnknownRule.setBody(cSSNode3.getText());
        return cSSUnknownRule;
    }

    @Nonnull
    public CascadingStyleSheet createCascadingStyleSheetFromNode(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.ROOT);
        CascadingStyleSheet cascadingStyleSheet = new CascadingStyleSheet();
        cascadingStyleSheet.setSourceLocation(cSSNode.getSourceLocation());
        for (CSSNode cSSNode2 : cSSNode) {
            if (ECSSNodeType.CHARSET.isNode(cSSNode2, this.m_eVersion)) continue;
            if (ECSSNodeType.IMPORTRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addImportRule(this._createImportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.NAMESPACERULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addNamespaceRule(this._createNamespaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createStyleRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createPageRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createMediaRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createFontFaceRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createKeyframesRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.VIEWPORTRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createViewportRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.SUPPORTSRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createSupportsRule(cSSNode2));
                continue;
            }
            if (ECSSNodeType.UNKNOWNRULE.isNode(cSSNode2, this.m_eVersion)) {
                cascadingStyleSheet.addRule(this._createUnknownRule(cSSNode2));
                continue;
            }
            s_aLogger.error("Unsupported child of " + ECSSNodeType.getNodeName(cSSNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(cSSNode2, this.m_eVersion));
        }
        return cascadingStyleSheet;
    }

    @Nonnull
    public CSSDeclarationList createDeclarationListFromNode(@Nonnull CSSNode cSSNode) {
        this._expectNodeType(cSSNode, ECSSNodeType.STYLEDECLARATIONLIST);
        CSSDeclarationList cSSDeclarationList = new CSSDeclarationList();
        cSSDeclarationList.setSourceLocation(cSSNode.getSourceLocation());
        int n = cSSNode.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            CSSDeclaration cSSDeclaration = this._createDeclaration(cSSNode.jjtGetChild(i));
            if (cSSDeclaration == null) continue;
            cSSDeclarationList.addDeclaration(cSSDeclaration);
        }
        return cSSDeclarationList;
    }
}

